/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;

public interface KieServerExtension {
    public boolean isInitialized();

    public boolean isActive();

    public void init(KieServerImpl var1, KieServerRegistry var2);

    public void destroy(KieServerImpl var1, KieServerRegistry var2);

    public void createContainer(String var1, KieContainerInstance var2, Map<String, Object> var3);

    public void updateContainer(String var1, KieContainerInstance var2, Map<String, Object> var3);

    public boolean isUpdateContainerAllowed(String var1, KieContainerInstance var2, Map<String, Object> var3);

    default public void activateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    default public void deactivateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void disposeContainer(String var1, KieContainerInstance var2, Map<String, Object> var3);

    public List<Object> getAppComponents(SupportedTransports var1);

    public <T> T getAppComponents(Class<T> var1);

    public String getImplementedCapability();

    public List<Object> getServices();

    public String getExtensionName();

    public Integer getStartOrder();

    default public List<Message> healthCheck(boolean report) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (!this.isInitialized()) {
            messages.add(new Message(Severity.ERROR, this.getExtensionName() + " failed to start"));
        }
        return messages;
    }

    default public void serverStarted() {
    }
}

