/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.ReleaseIdComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerContainerDeployment {
    private static final Logger LOG = LoggerFactory.getLogger(KieServerContainerDeployment.class);
    private final String containerId;
    private final ReleaseId releaseId;

    public KieServerContainerDeployment(String containerId, ReleaseId releaseId) {
        if (containerId == null || containerId.trim().isEmpty()) {
            throw new IllegalArgumentException("illegal containerId: " + containerId);
        }
        if (releaseId == null) {
            throw new IllegalArgumentException("null releaseId");
        }
        this.containerId = containerId;
        this.releaseId = releaseId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KieServerContainerDeployment)) {
            return false;
        }
        KieServerContainerDeployment other = (KieServerContainerDeployment)obj;
        if (this.containerId == null ? other.containerId != null : !this.containerId.equals(other.containerId)) {
            return false;
        }
        return !(this.releaseId == null ? other.releaseId != null : !this.releaseId.equals(other.releaseId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.containerId == null ? 0 : this.containerId.hashCode());
        result = 31 * result + (this.releaseId == null ? 0 : this.releaseId.hashCode());
        return result;
    }

    public String toString() {
        return this.containerId + '=' + this.releaseId.getGroupId() + ':' + this.releaseId.getArtifactId() + ':' + this.releaseId.getVersion();
    }

    public static String toString(Collection<KieServerContainerDeployment> deployments) {
        StringBuilder sb = new StringBuilder();
        if (deployments != null) {
            Iterator<KieServerContainerDeployment> iter = deployments.iterator();
            while (iter.hasNext()) {
                KieServerContainerDeployment deployment = iter.next();
                sb.append(deployment.toString());
                if (!iter.hasNext()) continue;
                sb.append('|');
            }
        }
        return sb.toString();
    }

    public static Set<KieServerContainerDeployment> fromString(String str) {
        return KieServerContainerDeployment.fromString(str, true);
    }

    public static Set<KieServerContainerDeployment> fromString(String str, boolean onlyLatest) {
        LinkedHashSet<KieServerContainerDeployment> deployments = new LinkedHashSet<KieServerContainerDeployment>();
        if (str != null && !str.isEmpty()) {
            TreeMap<String, TreeSet<ReleaseId>> containerIds_releaseIds = new TreeMap<String, TreeSet<ReleaseId>>();
            for (String unit : str.split("\\|")) {
                boolean recognized = false;
                String[] split = unit.split("=");
                if (split.length == 2) {
                    String containerId = split[0].trim();
                    String[] gav = split[1].trim().split(":");
                    if (!containerId.isEmpty() && gav.length == 3) {
                        recognized = true;
                        TreeSet<ReleaseId> releaseIds = (TreeSet<ReleaseId>)containerIds_releaseIds.get(containerId);
                        if (releaseIds == null) {
                            releaseIds = new TreeSet<ReleaseId>((Comparator<ReleaseId>)new ReleaseIdComparator(ReleaseIdComparator.SortDirection.DESCENDING));
                            containerIds_releaseIds.put(containerId, releaseIds);
                        }
                        releaseIds.add(KieServices.Factory.get().newReleaseId(gav[0], gav[1], gav[2]));
                    }
                }
                if (recognized || !LOG.isWarnEnabled()) continue;
                LOG.warn(String.format("skipping unrecognized deployment: %s", unit));
            }
            block1: for (Map.Entry entry : containerIds_releaseIds.entrySet()) {
                String containerId = (String)entry.getKey();
                Set releaseIds = (Set)entry.getValue();
                for (ReleaseId releaseId : releaseIds) {
                    KieServerContainerDeployment deployment = new KieServerContainerDeployment(containerId, releaseId);
                    deployments.add(deployment);
                    if (!onlyLatest) continue;
                    continue block1;
                }
            }
        }
        return deployments;
    }
}

