/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import org.appformer.maven.support.AFReleaseId;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.impl.InternalKieContainer;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.KieMavenRepository;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.services.impl.KieContainerInstanceImpl;

public class KieContainerInstanceImplTest {
    private static final String CONTAINER_ID = "my-container";
    private static final String GROUP_ID = "org.kie.server.test";
    private static final String ARTIFACT_ID = "my-test-artifact";
    private static final String VERSION_100 = "1.0.0.Final";
    private static final String VERSION_101 = "1.0.1.Final";
    private static final org.kie.server.api.model.ReleaseId RELEASE_ID_100 = new org.kie.server.api.model.ReleaseId("org.kie.server.test", "my-test-artifact", "1.0.0.Final");
    private static final org.kie.server.api.model.ReleaseId RELEASE_ID_101 = new org.kie.server.api.model.ReleaseId("org.kie.server.test", "my-test-artifact", "1.0.1.Final");

    @Test
    public void testUpdatingOfReleaseId() {
        this.createEmptyKjar(GROUP_ID, ARTIFACT_ID, VERSION_100);
        this.createEmptyKjar(GROUP_ID, ARTIFACT_ID, VERSION_101);
        KieServices ks = KieServices.Factory.get();
        InternalKieContainer kieContainer = (InternalKieContainer)ks.newKieContainer(CONTAINER_ID, (ReleaseId)RELEASE_ID_100);
        KieContainerInstanceImpl containerInstance = new KieContainerInstanceImpl(CONTAINER_ID, KieContainerStatus.STARTED, kieContainer);
        Marshaller marshaller = containerInstance.getMarshaller(MarshallingFormat.JAXB);
        KieContainerResource containerResource = containerInstance.getResource();
        Assertions.assertThat((Object)containerResource).isNotNull();
        this.verifyReleaseId(containerResource.getReleaseId(), RELEASE_ID_100);
        this.verifyReleaseId(containerResource.getResolvedReleaseId(), RELEASE_ID_100);
        Marshaller updatedMarshaller = containerInstance.getMarshaller(MarshallingFormat.JAXB);
        Assertions.assertThat((Object)updatedMarshaller).isEqualTo((Object)marshaller);
        containerInstance.getKieContainer().updateToVersion((ReleaseId)RELEASE_ID_101);
        containerResource = containerInstance.getResource();
        Assertions.assertThat((Object)containerResource).isNotNull();
        this.verifyReleaseId(containerResource.getReleaseId(), RELEASE_ID_101);
        this.verifyReleaseId(containerResource.getResolvedReleaseId(), RELEASE_ID_101);
        updatedMarshaller = containerInstance.getMarshaller(MarshallingFormat.JAXB);
        Assertions.assertThat((Object)updatedMarshaller).isNotEqualTo((Object)marshaller);
    }

    private void verifyReleaseId(org.kie.server.api.model.ReleaseId actualReleaseId, org.kie.server.api.model.ReleaseId expectedReleaseId) {
        Assertions.assertThat((Object)actualReleaseId).isNotNull();
        Assertions.assertThat((String)actualReleaseId.getGroupId()).isEqualTo((Object)expectedReleaseId.getGroupId());
        Assertions.assertThat((String)actualReleaseId.getArtifactId()).isEqualTo((Object)expectedReleaseId.getArtifactId());
        Assertions.assertThat((String)actualReleaseId.getVersion()).isEqualTo((Object)expectedReleaseId.getVersion());
    }

    private void createEmptyKjar(String groupId, String artifactId, String version) {
        KieServices kieServices = KieServices.Factory.get();
        KieFileSystem kfs = kieServices.newKieFileSystem();
        ReleaseId releaseId = kieServices.newReleaseId(groupId, artifactId, version);
        kfs.generateAndWritePomXML(releaseId);
        KieModule kieModule = kieServices.newKieBuilder(kfs).buildAll().getKieModule();
        byte[] pom = kfs.read("pom.xml");
        byte[] jar = ((InternalKieModule)kieModule).getBytes();
        KieMavenRepository.getKieMavenRepository().installArtifact((AFReleaseId)releaseId, jar, pom);
    }
}

