/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.core.impl.InternalKieContainer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.KieScanner;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.Severity;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;
import org.kie.server.services.impl.util.DummyKieServerExtension;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class KieServerImplOperationTest {
    private static final File REPOSITORY_DIR = new File("target/repository-dir");
    private static final String KIE_SERVER_ID = "kie-server-impl-test";
    private KieServerImpl kieServer;
    private String origServerId = null;
    private KieServerStateRepository repository;
    private DummyKieServerExtension errorKieServerExtension;
    @Mock
    private KieServices services;

    @Before
    public void setupKieServerImpl() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.origServerId = KieServerEnvironment.getServerId();
        System.setProperty("org.kie.server.id", KIE_SERVER_ID);
        KieServerEnvironment.setServerId((String)KIE_SERVER_ID);
        FileUtils.deleteDirectory((File)REPOSITORY_DIR);
        FileUtils.forceMkdir((File)REPOSITORY_DIR);
        this.repository = new KieServerStateFileRepository(REPOSITORY_DIR);
        this.errorKieServerExtension = new DummyKieServerExtension();
        this.kieServer = new KieServerImpl(this.repository, this.services){

            protected Map<String, Object> getContainerParameters(org.kie.api.builder.ReleaseId releaseId, List<Message> messages) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("ContainerMessages", messages);
                return parameters;
            }
        };
        this.kieServer.init();
        this.kieServer.getServerRegistry().registerServerExtension((KieServerExtension)this.errorKieServerExtension);
    }

    @After
    public void cleanUp() {
        if (this.kieServer != null) {
            this.kieServer.destroy();
        }
        KieServerEnvironment.setServerId((String)this.origServerId);
    }

    @Test
    public void testDisposeContainerWithScanner() {
        InternalKieScanner mockedScanner = (InternalKieScanner)Mockito.mock(InternalKieScanner.class);
        Mockito.when((Object)mockedScanner.getStatus()).thenReturn((Object)KieScanner.Status.RUNNING);
        InternalKieContainer mockedKieContainer = (InternalKieContainer)Mockito.mock(InternalKieContainer.class);
        Mockito.when((Object)mockedKieContainer.getReleaseId()).thenReturn((Object)new ReleaseId("g", "a", "v"));
        KieContainerInstanceImpl kieContainerInstance = (KieContainerInstanceImpl)Mockito.mock(KieContainerInstanceImpl.class);
        Mockito.when((Object)kieContainerInstance.getContainerId()).thenReturn((Object)"id");
        Mockito.when((Object)kieContainerInstance.getStatus()).thenReturn((Object)KieContainerStatus.STARTED);
        Mockito.when((Object)kieContainerInstance.getKieContainer()).thenReturn((Object)mockedKieContainer);
        Mockito.when((Object)kieContainerInstance.getResource()).thenReturn((Object)new KieContainerResource("id", new ReleaseId("g", "a", "v")));
        Mockito.when((Object)kieContainerInstance.getScanner()).thenReturn((Object)mockedScanner);
        this.kieServer.getServerRegistry().registerContainer("id", kieContainerInstance);
        this.kieServer.disposeContainer("id");
        ((KieContainerInstanceImpl)Mockito.verify((Object)kieContainerInstance, (VerificationMode)Mockito.times((int)1))).stopScanner();
    }

    @Test
    public void testDisposeContainerWithNoScanner() {
        InternalKieContainer mockedKieContainer = (InternalKieContainer)Mockito.mock(InternalKieContainer.class);
        Mockito.when((Object)mockedKieContainer.getReleaseId()).thenReturn((Object)new ReleaseId("g", "a", "v"));
        KieContainerInstanceImpl kieContainerInstance = (KieContainerInstanceImpl)Mockito.mock(KieContainerInstanceImpl.class);
        Mockito.when((Object)kieContainerInstance.getContainerId()).thenReturn((Object)"id");
        Mockito.when((Object)kieContainerInstance.getStatus()).thenReturn((Object)KieContainerStatus.STARTED);
        Mockito.when((Object)kieContainerInstance.getKieContainer()).thenReturn((Object)mockedKieContainer);
        Mockito.when((Object)kieContainerInstance.getResource()).thenReturn((Object)new KieContainerResource("id", new ReleaseId("g", "a", "v")));
        this.kieServer.getServerRegistry().registerContainer("id", kieContainerInstance);
        this.kieServer.disposeContainer("id");
        ((KieContainerInstanceImpl)Mockito.verify((Object)kieContainerInstance, (VerificationMode)Mockito.times((int)0))).stopScanner();
    }

    @Test
    public void testActivateAndDeactivateContainer() {
        InternalKieContainer mockedKieContainer = (InternalKieContainer)Mockito.mock(InternalKieContainer.class);
        Mockito.when((Object)mockedKieContainer.getReleaseId()).thenReturn((Object)new ReleaseId("g", "a", "v"));
        KieContainerResource container = new KieContainerResource("id", new ReleaseId("g", "a", "v"));
        KieContainerInstanceImpl kieContainerInstance = (KieContainerInstanceImpl)Mockito.mock(KieContainerInstanceImpl.class);
        Mockito.when((Object)kieContainerInstance.getContainerId()).thenReturn((Object)"id");
        Mockito.when((Object)kieContainerInstance.getStatus()).thenReturn((Object)KieContainerStatus.STARTED);
        Mockito.when((Object)kieContainerInstance.getKieContainer()).thenReturn((Object)mockedKieContainer);
        Mockito.when((Object)kieContainerInstance.getResource()).thenReturn((Object)container);
        this.kieServer.getServerRegistry().registerContainer("id", kieContainerInstance);
        KieServerState currentState = this.repository.load(KIE_SERVER_ID);
        currentState.getContainers().add(container);
        this.repository.store(KIE_SERVER_ID, currentState);
        this.kieServer.deactivateContainer("id");
        currentState = this.repository.load(KIE_SERVER_ID);
        Assert.assertNotNull((Object)currentState);
        Assert.assertNotNull((Object)currentState.getContainers());
        Assert.assertEquals((long)1L, (long)currentState.getContainers().size());
        container = (KieContainerResource)currentState.getContainers().iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)KieContainerStatus.DEACTIVATED, (Object)container.getStatus());
        Mockito.when((Object)kieContainerInstance.getStatus()).thenReturn((Object)KieContainerStatus.DEACTIVATED);
        this.kieServer.activateContainer("id");
        currentState = this.repository.load(KIE_SERVER_ID);
        Assert.assertNotNull((Object)currentState);
        Assert.assertNotNull((Object)currentState.getContainers());
        Assert.assertEquals((long)1L, (long)currentState.getContainers().size());
        container = (KieContainerResource)currentState.getContainers().iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)container.getStatus());
    }

    @Test
    public void testDeletionContainer() {
        String containerId = "test-container";
        ReleaseId releaseId = new ReleaseId("g", "a", "v");
        KieContainerResource container = new KieContainerResource("id", releaseId);
        container.setMessages(Collections.singletonList(new Message(Severity.ERROR, "Compilation failure")));
        InternalKieContainer mockedKieContainer = (InternalKieContainer)Mockito.mock(InternalKieContainer.class);
        KieRepository mockedKieRepository = (KieRepository)Mockito.mock(KieRepository.class);
        Mockito.when((Object)mockedKieContainer.getReleaseId()).thenReturn((Object)new ReleaseId("g", "a", "v"));
        Mockito.when((Object)mockedKieContainer.getContainerReleaseId()).thenReturn((Object)new ReleaseId("g", "a", "v"));
        Mockito.when((Object)this.services.getRepository()).thenReturn((Object)mockedKieRepository);
        MutableBoolean fail = new MutableBoolean(false);
        Mockito.when((Object)this.services.newKieContainer(containerId, (org.kie.api.builder.ReleaseId)releaseId)).then(e -> {
            if (fail.isTrue()) {
                throw new IllegalStateException("already exists in container");
            }
            return mockedKieContainer;
        });
        this.errorKieServerExtension.addMessage(new Message(Severity.ERROR, "compilation failure"));
        this.kieServer.createContainer(containerId, container);
        Assert.assertTrue((boolean)((KieContainerResource)this.kieServer.getContainerInfo(containerId).getResult()).getStatus().equals((Object)KieContainerStatus.FAILED));
        this.errorKieServerExtension.clear();
        fail.setTrue();
        this.kieServer.createContainer(containerId, container);
        Assert.assertTrue((boolean)((KieContainerResource)this.kieServer.getContainerInfo(containerId).getResult()).getStatus().equals((Object)KieContainerStatus.FAILED));
        this.kieServer.disposeContainer(containerId);
        Assert.assertNull((Object)this.kieServer.getContainerInfo(containerId).getResult());
        ((InternalKieContainer)Mockito.verify((Object)mockedKieContainer, (VerificationMode)Mockito.times((int)1))).dispose();
    }
}

