/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.appformer.maven.support.AFReleaseId;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.scanner.KieMavenRepository;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;

public class KieServerImplTest {
    private static final File REPOSITORY_DIR = new File("target/repository-dir");
    private static final String KIE_SERVER_ID = "kie-server-impl-test";
    private static final String GROUP_ID = "org.kie.server.test";
    private static final String DEFAULT_VERSION = "1.0.0.Final";
    private KieServerImpl kieServer;
    private org.kie.api.builder.ReleaseId releaseId;
    private String origServerId = null;

    @Before
    public void setupKieServerImpl() throws Exception {
        this.origServerId = KieServerEnvironment.getServerId();
        System.setProperty("org.kie.server.id", KIE_SERVER_ID);
        KieServerEnvironment.setServerId((String)KIE_SERVER_ID);
        FileUtils.deleteDirectory((File)REPOSITORY_DIR);
        FileUtils.forceMkdir((File)REPOSITORY_DIR);
        this.kieServer = new KieServerImpl((KieServerStateRepository)new KieServerStateFileRepository(REPOSITORY_DIR));
    }

    @After
    public void cleanUp() {
        if (this.kieServer != null) {
            this.kieServer.destroy();
        }
        KieServerEnvironment.setServerId((String)this.origServerId);
    }

    @Test
    public void testPersistScannerState() {
        String containerId = "persist-scanner-state";
        this.createEmptyKjar(containerId);
        KieContainerResource kieContainerResource = new KieContainerResource(containerId, new ReleaseId(this.releaseId));
        this.kieServer.createContainer(containerId, kieContainerResource);
        KieScannerResource kieScannerResource = new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(20000L));
        this.kieServer.updateScanner(containerId, kieScannerResource);
        KieServerStateFileRepository stateRepository = new KieServerStateFileRepository(REPOSITORY_DIR);
        KieServerState state = stateRepository.load(KIE_SERVER_ID);
        Set containers = state.getContainers();
        Assertions.assertThat((Iterable)containers).hasSize(1);
        KieContainerResource container = (KieContainerResource)containers.iterator().next();
        Assertions.assertThat((Object)container.getScanner()).isEqualTo((Object)kieScannerResource);
        KieScannerResource updatedKieScannerResource = new KieScannerResource(KieScannerStatus.DISPOSED);
        this.kieServer.updateScanner(containerId, updatedKieScannerResource);
        stateRepository = new KieServerStateFileRepository(REPOSITORY_DIR);
        state = stateRepository.load(KIE_SERVER_ID);
        containers = state.getContainers();
        Assertions.assertThat((Iterable)containers).hasSize(1);
        container = (KieContainerResource)containers.iterator().next();
        Assertions.assertThat((Object)container.getScanner()).isEqualTo((Object)updatedKieScannerResource);
    }

    @Test
    public void testCreateScannerWhenCreatingContainer() {
        String containerId = "scanner-state-when-creating-container";
        this.createEmptyKjar(containerId);
        KieContainerResource kieContainerResource = new KieContainerResource(containerId, new ReleaseId(this.releaseId));
        KieScannerResource kieScannerResource = new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(20000L));
        kieContainerResource.setScanner(kieScannerResource);
        ServiceResponse createResponse = this.kieServer.createContainer(containerId, kieContainerResource);
        Assertions.assertThat((Comparable)createResponse.getType()).isEqualTo((Object)ServiceResponse.ResponseType.SUCCESS);
        Assertions.assertThat((Object)((KieContainerResource)createResponse.getResult()).getScanner()).isEqualTo((Object)kieScannerResource);
        ServiceResponse getResponse = this.kieServer.getContainerInfo(containerId);
        Assertions.assertThat((Comparable)getResponse.getType()).isEqualTo((Object)ServiceResponse.ResponseType.SUCCESS);
        Assertions.assertThat((Object)((KieContainerResource)getResponse.getResult()).getScanner()).isEqualTo((Object)kieScannerResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutorPropertiesInStateRepository() {
        KieServerStateFileRepository stateRepository = new KieServerStateFileRepository(REPOSITORY_DIR);
        KieServerState state = stateRepository.load(KIE_SERVER_ID);
        String executorInterval = state.getConfiguration().getConfigItemValue("org.kie.executor.interval");
        String executorRetries = state.getConfiguration().getConfigItemValue("org.kie.executor.retry.count");
        String executorPool = state.getConfiguration().getConfigItemValue("org.kie.executor.pool.size");
        String executorTimeUnit = state.getConfiguration().getConfigItemValue("org.kie.executor.timeunit");
        String executorJMSQueue = state.getConfiguration().getConfigItemValue("org.kie.executor.jms.queue");
        String executorDisabled = state.getConfiguration().getConfigItemValue("org.kie.executor.disabled");
        Assert.assertNull((Object)executorInterval);
        Assert.assertNull((Object)executorRetries);
        Assert.assertNull((Object)executorPool);
        Assert.assertNull((Object)executorTimeUnit);
        Assert.assertNull((Object)executorJMSQueue);
        Assert.assertNull((Object)executorDisabled);
        try {
            System.setProperty("org.kie.executor.interval", "4");
            System.setProperty("org.kie.executor.retry.count", "7");
            System.setProperty("org.kie.executor.pool.size", "11");
            System.setProperty("org.kie.executor.timeunit", "HOURS");
            System.setProperty("org.kie.executor.jms.queue", "queue/MY.OWN.QUEUE");
            System.setProperty("org.kie.executor.disabled", "true");
            stateRepository.clearCache();
            state = stateRepository.load(KIE_SERVER_ID);
            executorInterval = state.getConfiguration().getConfigItemValue("org.kie.executor.interval");
            executorRetries = state.getConfiguration().getConfigItemValue("org.kie.executor.retry.count");
            executorPool = state.getConfiguration().getConfigItemValue("org.kie.executor.pool.size");
            executorTimeUnit = state.getConfiguration().getConfigItemValue("org.kie.executor.timeunit");
            executorJMSQueue = state.getConfiguration().getConfigItemValue("org.kie.executor.jms.queue");
            executorDisabled = state.getConfiguration().getConfigItemValue("org.kie.executor.disabled");
            Assert.assertNotNull((Object)executorInterval);
            Assert.assertNotNull((Object)executorRetries);
            Assert.assertNotNull((Object)executorPool);
            Assert.assertNotNull((Object)executorTimeUnit);
            Assert.assertNotNull((Object)executorJMSQueue);
            Assert.assertNotNull((Object)executorDisabled);
            Assert.assertEquals((Object)"4", (Object)executorInterval);
            Assert.assertEquals((Object)"7", (Object)executorRetries);
            Assert.assertEquals((Object)"11", (Object)executorPool);
            Assert.assertEquals((Object)"HOURS", (Object)executorTimeUnit);
            Assert.assertEquals((Object)"queue/MY.OWN.QUEUE", (Object)executorJMSQueue);
            Assert.assertEquals((Object)"true", (Object)executorDisabled);
        }
        finally {
            System.clearProperty("org.kie.executor.interval");
            System.clearProperty("org.kie.executor.retry.count");
            System.clearProperty("org.kie.executor.pool.size");
            System.clearProperty("org.kie.executor.timeunit");
            System.clearProperty("org.kie.executor.jms.queue");
            System.clearProperty("org.kie.executor.disabled");
        }
    }

    private void assertReleaseIds(String containerId, ReleaseId configuredReleaseId, ReleaseId resolvedReleaseId, long timeoutMillis) throws InterruptedException {
        for (long timeSpentWaiting = 0L; timeSpentWaiting < timeoutMillis; timeSpentWaiting += 200L) {
            ServiceResponse listResponse = this.kieServer.listContainers(KieContainerResourceFilter.ACCEPT_ALL);
            Assertions.assertThat((Comparable)listResponse.getType()).isEqualTo((Object)ServiceResponse.ResponseType.SUCCESS);
            List containers = ((KieContainerResourceList)listResponse.getResult()).getContainers();
            for (KieContainerResource container : containers) {
                if (!configuredReleaseId.equals((Object)container.getReleaseId()) || !resolvedReleaseId.equals((Object)container.getResolvedReleaseId())) continue;
                return;
            }
            Thread.sleep(200L);
        }
        Assertions.fail((String)("Waiting too long for container " + containerId + " to have expected releaseIds updated! expected: releaseId=" + configuredReleaseId + ", resolvedReleaseId=" + resolvedReleaseId));
    }

    private void createEmptyKjar(String artifactId) {
        this.createEmptyKjar(artifactId, DEFAULT_VERSION);
    }

    private void createEmptyKjar(String artifactId, String version) {
        KieServices kieServices = KieServices.Factory.get();
        KieFileSystem kfs = kieServices.newKieFileSystem();
        this.releaseId = kieServices.newReleaseId(GROUP_ID, artifactId, version);
        KieModule kieModule = kieServices.newKieBuilder(kfs).buildAll().getKieModule();
        KieMavenRepository.getKieMavenRepository().installArtifact((AFReleaseId)this.releaseId, (InternalKieModule)kieModule, this.createPomFile(artifactId, version));
        kieServices.getRepository().addKieModule(kieModule);
    }

    private File createPomFile(String artifactId, String version) {
        String pomContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>org.kie.server.test</groupId>\n  <artifactId>" + artifactId + "</artifactId>\n  <version>" + version + "</version>\n  <packaging>pom</packaging>\n</project>";
        try {
            File file = new File("target/" + artifactId + "-1.0.0.Final.pom");
            FileUtils.write((File)file, (CharSequence)pomContent);
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

