/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.appformer.maven.support.AFReleaseId;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.scanner.KieMavenRepository;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.CreateContainerCommand;
import org.kie.server.api.commands.DisposeContainerCommand;
import org.kie.server.api.commands.UpdateReleaseIdCommand;
import org.kie.server.api.commands.UpdateScannerCommand;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerMode;
import org.kie.server.api.model.KieServerStateInfo;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.api.model.Severity;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieControllerNotConnectedException;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieContainerCommandServiceImpl;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.controller.DefaultRestControllerImpl;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class AbstractKieServerImplTest {
    static final File REPOSITORY_DIR = new File("target/repository-dir");
    static final String KIE_SERVER_ID = "kie-server-impl-test";
    static final String GROUP_ID = "org.kie.server.test";
    static final String PRODUCTION_MODE_VERSION = "1.0.0.Final";
    static final String DEVELOPMENT_MODE_VERSION = "1.0.0-SNAPSHOT";
    protected KieServerMode mode;
    protected String testVersion;
    protected KieServerImpl kieServer;
    protected org.kie.api.builder.ReleaseId releaseId;
    protected String origServerId = null;
    protected List<KieServerExtension> extensions;

    abstract KieServerMode getTestMode();

    @Before
    public void setupKieServerImpl() throws Exception {
        this.extensions = new ArrayList<KieServerExtension>();
        this.mode = this.getTestMode();
        this.testVersion = this.getVersion(this.mode);
        this.origServerId = KieServerEnvironment.getServerId();
        System.setProperty("org.kie.server.mode", this.mode.name());
        System.setProperty("org.kie.server.id", KIE_SERVER_ID);
        KieServerEnvironment.setServerId((String)KIE_SERVER_ID);
        FileUtils.deleteDirectory((File)REPOSITORY_DIR);
        FileUtils.forceMkdir((File)REPOSITORY_DIR);
        this.kieServer = new KieServerImpl((KieServerStateRepository)new KieServerStateFileRepository(REPOSITORY_DIR)){

            public List<KieServerExtension> getServerExtensions() {
                return AbstractKieServerImplTest.this.extensions;
            }
        };
        this.kieServer.init();
    }

    protected String getVersion(KieServerMode mode) {
        return mode.equals((Object)KieServerMode.DEVELOPMENT) ? DEVELOPMENT_MODE_VERSION : PRODUCTION_MODE_VERSION;
    }

    @After
    public void cleanUp() {
        if (this.kieServer != null) {
            this.kieServer.destroy();
        }
        KieServerEnvironment.setServerId((String)this.origServerId);
    }

    @Test
    public void testCheckMode() {
        Assert.assertSame((Object)this.mode, (Object)((KieServerInfo)this.kieServer.getInfo().getResult()).getMode());
    }

    @Test
    public void testReadinessCheck() {
        Assert.assertTrue((boolean)this.kieServer.isKieServerReady());
    }

    @Test(timeout=10000L)
    public void testReadinessCheckDelayedStart() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch startedlatch = new CountDownLatch(1);
        this.kieServer.destroy();
        this.kieServer = this.delayedKieServer(latch, startedlatch);
        Assert.assertFalse((boolean)this.kieServer.isKieServerReady());
        latch.countDown();
        startedlatch.await();
        Assert.assertTrue((boolean)this.kieServer.isKieServerReady());
    }

    @Test
    public void testHealthCheck() {
        List healthMessages = this.kieServer.healthCheck(false);
        Assert.assertEquals((long)healthMessages.size(), (long)0L);
    }

    @Test
    public void testHealthCheckWithReport() {
        List healthMessages = this.kieServer.healthCheck(true);
        Assert.assertEquals((long)healthMessages.size(), (long)2L);
        Message header = (Message)healthMessages.get(0);
        Assert.assertEquals((Object)Severity.INFO, (Object)header.getSeverity());
        Assert.assertEquals((long)2L, (long)header.getMessages().size());
        Message footer = (Message)healthMessages.get(1);
        Assert.assertEquals((Object)Severity.INFO, (Object)footer.getSeverity());
        Assert.assertEquals((long)1L, (long)footer.getMessages().size());
    }

    @Test(timeout=10000L)
    public void testHealthCheckDelayedStart() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch startedlatch = new CountDownLatch(1);
        this.kieServer.destroy();
        this.kieServer = this.delayedKieServer(latch, startedlatch);
        Assert.assertFalse((boolean)this.kieServer.isKieServerReady());
        List healthMessages = this.kieServer.healthCheck(false);
        Assert.assertEquals((long)healthMessages.size(), (long)1L);
        Message notReady = (Message)healthMessages.get(0);
        Assert.assertEquals((Object)Severity.ERROR, (Object)notReady.getSeverity());
        Assert.assertEquals((long)1L, (long)notReady.getMessages().size());
        latch.countDown();
        startedlatch.await();
        Assert.assertTrue((boolean)this.kieServer.isKieServerReady());
        healthMessages = this.kieServer.healthCheck(false);
        Assert.assertEquals((long)healthMessages.size(), (long)0L);
    }

    @Test
    public void testHealthCheckFailedContainer() {
        this.kieServer.destroy();
        this.kieServer = new KieServerImpl((KieServerStateRepository)new KieServerStateFileRepository(REPOSITORY_DIR)){

            protected List<KieContainerInstanceImpl> getContainers() {
                ArrayList<KieContainerInstanceImpl> containers = new ArrayList<KieContainerInstanceImpl>();
                KieContainerInstanceImpl container = new KieContainerInstanceImpl("test", KieContainerStatus.FAILED);
                containers.add(container);
                return containers;
            }
        };
        this.kieServer.init();
        List healthMessages = this.kieServer.healthCheck(false);
        Assert.assertEquals((long)healthMessages.size(), (long)1L);
        Message failedContainer = (Message)healthMessages.get(0);
        Assert.assertEquals((Object)Severity.WARN, (Object)failedContainer.getSeverity());
        Assert.assertEquals((long)1L, (long)failedContainer.getMessages().size());
        Assert.assertEquals((Object)"KIE Container 'test' is in FAILED state", failedContainer.getMessages().iterator().next());
    }

    @Test
    public void testHealthCheckFailedContainerManagementDisabled() {
        System.setProperty("org.kie.server.mgmt.api.disabled", "true");
        this.kieServer.destroy();
        this.kieServer = new KieServerImpl((KieServerStateRepository)new KieServerStateFileRepository(REPOSITORY_DIR)){

            protected List<KieContainerInstanceImpl> getContainers() {
                ArrayList<KieContainerInstanceImpl> containers = new ArrayList<KieContainerInstanceImpl>();
                KieContainerInstanceImpl container = new KieContainerInstanceImpl("test", KieContainerStatus.FAILED);
                containers.add(container);
                return containers;
            }
        };
        this.kieServer.init();
        List healthMessages = this.kieServer.healthCheck(false);
        Assert.assertEquals((long)1L, (long)healthMessages.size());
        Message failedContainer = (Message)healthMessages.get(0);
        Assert.assertEquals((Object)Severity.ERROR, (Object)failedContainer.getSeverity());
        Assert.assertEquals((long)1L, (long)failedContainer.getMessages().size());
        Assert.assertEquals((Object)"KIE Container 'test' is in FAILED state", failedContainer.getMessages().iterator().next());
        System.clearProperty("org.kie.server.mgmt.api.disabled");
    }

    @Test
    public void testHealthCheckFailedExtension() {
        this.extensions.add(new KieServerExtension(){

            public List<Message> healthCheck(boolean report) {
                List messages = super.healthCheck(report);
                messages.add(new Message(Severity.ERROR, "TEST extension is unhealthy"));
                return messages;
            }

            public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
            }

            public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
                return false;
            }

            public boolean isInitialized() {
                return true;
            }

            public boolean isActive() {
                return true;
            }

            public void init(KieServerImpl kieServer, KieServerRegistry registry) {
            }

            public Integer getStartOrder() {
                return 10;
            }

            public List<Object> getServices() {
                return null;
            }

            public String getImplementedCapability() {
                return "TEST";
            }

            public String getExtensionName() {
                return "TEST";
            }

            public <T> T getAppComponents(Class<T> serviceType) {
                return null;
            }

            public List<Object> getAppComponents(SupportedTransports type) {
                return null;
            }

            public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
            }

            public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
            }

            public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
            }
        });
        this.kieServer.init();
        List healthMessages = this.kieServer.healthCheck(false);
        Assert.assertEquals((long)healthMessages.size(), (long)1L);
        Message failedContainer = (Message)healthMessages.get(0);
        Assert.assertEquals((Object)Severity.ERROR, (Object)failedContainer.getSeverity());
        Assert.assertEquals((long)1L, (long)failedContainer.getMessages().size());
        Assert.assertEquals((Object)"TEST extension is unhealthy", failedContainer.getMessages().iterator().next());
    }

    @Test
    public void testManagementDisabledDefault() {
        Assert.assertNull((Object)this.kieServer.checkAccessability());
    }

    @Test
    public void testManagementDisabledConfigured() {
        System.setProperty("org.kie.server.mgmt.api.disabled", "true");
        try {
            this.kieServer.destroy();
            this.kieServer = new KieServerImpl((KieServerStateRepository)new KieServerStateFileRepository(REPOSITORY_DIR));
            this.kieServer.init();
            ServiceResponse forbidden = this.kieServer.checkAccessability();
            this.assertForbiddenResponse(forbidden);
        }
        finally {
            System.clearProperty("org.kie.server.mgmt.api.disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManagementDisabledConfiguredViaCommandService() {
        System.setProperty("org.kie.server.mgmt.api.disabled", "true");
        try {
            this.kieServer.destroy();
            this.kieServer = new KieServerImpl((KieServerStateRepository)new KieServerStateFileRepository(REPOSITORY_DIR));
            this.kieServer.init();
            KieContainerCommandServiceImpl commandService = new KieContainerCommandServiceImpl(this.kieServer, this.kieServer.getServerRegistry());
            ArrayList<Object> commands = new ArrayList<Object>();
            commands.add(new CreateContainerCommand());
            commands.add(new DisposeContainerCommand());
            commands.add(new UpdateScannerCommand());
            commands.add(new UpdateReleaseIdCommand());
            CommandScript commandScript = new CommandScript(commands);
            ServiceResponsesList responseList = commandService.executeScript(commandScript, MarshallingFormat.JAXB, null);
            Assert.assertNotNull((Object)responseList);
            List responses = responseList.getResponses();
            Assert.assertEquals((long)4L, (long)responses.size());
            for (ServiceResponse forbidden : responses) {
                this.assertForbiddenResponse(forbidden);
            }
        }
        finally {
            System.clearProperty("org.kie.server.mgmt.api.disabled");
        }
    }

    @Test
    public void testPersistScannerState() {
        String containerId = "persist-scanner-state";
        this.createEmptyKjar(containerId);
        KieContainerResource kieContainerResource = new KieContainerResource(containerId, new ReleaseId(this.releaseId));
        this.kieServer.createContainer(containerId, kieContainerResource);
        KieScannerResource kieScannerResource = new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(20000L));
        this.kieServer.updateScanner(containerId, kieScannerResource);
        KieServerStateFileRepository stateRepository = new KieServerStateFileRepository(REPOSITORY_DIR);
        KieServerState state = stateRepository.load(KIE_SERVER_ID);
        Set containers = state.getContainers();
        Assertions.assertThat((Iterable)containers).hasSize(1);
        KieContainerResource container = (KieContainerResource)containers.iterator().next();
        Assertions.assertThat((Object)container.getScanner()).isEqualTo((Object)kieScannerResource);
        KieScannerResource updatedKieScannerResource = new KieScannerResource(KieScannerStatus.DISPOSED);
        this.kieServer.updateScanner(containerId, updatedKieScannerResource);
        stateRepository = new KieServerStateFileRepository(REPOSITORY_DIR);
        state = stateRepository.load(KIE_SERVER_ID);
        containers = state.getContainers();
        Assertions.assertThat((Iterable)containers).hasSize(1);
        container = (KieContainerResource)containers.iterator().next();
        Assertions.assertThat((Object)container.getScanner()).isEqualTo((Object)updatedKieScannerResource);
        this.kieServer.disposeContainer(containerId);
    }

    @Test
    public void testCreateScannerWhenCreatingContainer() {
        String containerId = "scanner-state-when-creating-container";
        this.createEmptyKjar(containerId);
        KieContainerResource kieContainerResource = new KieContainerResource(containerId, new ReleaseId(this.releaseId));
        KieScannerResource kieScannerResource = new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(20000L));
        kieContainerResource.setScanner(kieScannerResource);
        ServiceResponse createResponse = this.kieServer.createContainer(containerId, kieContainerResource);
        Assertions.assertThat((Comparable)createResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.SUCCESS);
        Assertions.assertThat((Object)((KieContainerResource)createResponse.getResult()).getScanner()).isEqualTo((Object)kieScannerResource);
        ServiceResponse getResponse = this.kieServer.getContainerInfo(containerId);
        Assertions.assertThat((Comparable)getResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.SUCCESS);
        Assertions.assertThat((Object)((KieContainerResource)getResponse.getResult()).getScanner()).isEqualTo((Object)kieScannerResource);
        this.kieServer.disposeContainer(containerId);
    }

    @Test
    public void testCreateContainerValidationNullContainer() {
        String containerId = "container-to-create";
        this.createEmptyKjar(containerId);
        ServiceResponse createResponse = this.kieServer.createContainer(containerId, null);
        Assertions.assertThat((Comparable)createResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.FAILURE);
    }

    @Test
    public void testCreateContainerValidationNullRelease() {
        String containerId = "container-to-create";
        this.createEmptyKjar(containerId);
        KieContainerResource kieContainerResource = new KieContainerResource(containerId, null);
        KieScannerResource kieScannerResource = new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(20000L));
        kieContainerResource.setScanner(kieScannerResource);
        ServiceResponse createResponse = this.kieServer.createContainer(containerId, kieContainerResource);
        Assertions.assertThat((Comparable)createResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.FAILURE);
    }

    @Test
    public void testUpdateContainer() {
        KieServerExtension extension = (KieServerExtension)Mockito.mock(KieServerExtension.class);
        Mockito.when((Object)extension.isUpdateContainerAllowed((String)Matchers.any(), (KieContainerInstance)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)true);
        this.extensions.add(extension);
        String containerId = "container-to-update";
        this.startContainerToUpdate(containerId, this.getVersion(this.mode));
        ServiceResponse updateResponse = this.kieServer.updateContainerReleaseId(containerId, new ReleaseId(this.releaseId), true);
        Assertions.assertThat((Comparable)updateResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.SUCCESS);
        ((KieServerExtension)Mockito.verify((Object)extension)).isUpdateContainerAllowed(Matchers.anyString(), (KieContainerInstance)Matchers.any(), (Map)Matchers.any());
        ((KieServerExtension)Mockito.verify((Object)extension)).updateContainer((String)Matchers.any(), (KieContainerInstance)Matchers.any(), (Map)Matchers.any());
        this.kieServer.disposeContainer(containerId);
    }

    @Test
    public void testUpdateContainerWithExtensionNotAllowing() {
        KieServerExtension extension = (KieServerExtension)Mockito.mock(KieServerExtension.class);
        Mockito.when((Object)extension.isUpdateContainerAllowed((String)Matchers.any(), (KieContainerInstance)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)false);
        this.extensions.add(extension);
        String containerId = "container-to-update";
        this.startContainerToUpdate(containerId, this.getVersion(this.mode));
        ServiceResponse updateResponse = this.kieServer.updateContainerReleaseId(containerId, new ReleaseId(this.releaseId), true);
        Assertions.assertThat((Comparable)updateResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.FAILURE);
        ((KieServerExtension)Mockito.verify((Object)extension)).isUpdateContainerAllowed(Matchers.anyString(), (KieContainerInstance)Matchers.any(), (Map)Matchers.any());
        ((KieServerExtension)Mockito.verify((Object)extension, (VerificationMode)Mockito.never())).updateContainer((String)Matchers.any(), (KieContainerInstance)Matchers.any(), (Map)Matchers.any());
        this.kieServer.disposeContainer(containerId);
    }

    @Test
    public void testUpdateContainerWithNullReleaseID() {
        KieServerExtension extension = (KieServerExtension)Mockito.mock(KieServerExtension.class);
        Mockito.when((Object)extension.isUpdateContainerAllowed((String)Matchers.any(), (KieContainerInstance)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)false);
        this.extensions.add(extension);
        String containerId = "container-to-update";
        this.startContainerToUpdate(containerId, this.getVersion(this.mode));
        ServiceResponse updateResponse = this.kieServer.updateContainerReleaseId(containerId, null, true);
        Assertions.assertThat((Comparable)updateResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.FAILURE);
        ((KieServerExtension)Mockito.verify((Object)extension, (VerificationMode)Mockito.never())).isUpdateContainerAllowed(Matchers.anyString(), (KieContainerInstance)Matchers.any(), (Map)Matchers.any());
        ((KieServerExtension)Mockito.verify((Object)extension, (VerificationMode)Mockito.never())).updateContainer((String)Matchers.any(), (KieContainerInstance)Matchers.any(), (Map)Matchers.any());
        this.kieServer.disposeContainer(containerId);
    }

    protected void startContainerToUpdate(String containerId, String version) {
        this.createEmptyKjar(containerId, version);
        ReleaseId releaseId = new ReleaseId(this.releaseId);
        KieContainerResource kieContainerResource = new KieContainerResource(containerId, releaseId);
        KieScannerResource kieScannerResource = new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(20000L));
        kieContainerResource.setScanner(kieScannerResource);
        ServiceResponse createResponse = this.kieServer.createContainer(containerId, kieContainerResource);
        Assertions.assertThat((Comparable)createResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.SUCCESS);
        Assertions.assertThat((Object)((KieContainerResource)createResponse.getResult()).getScanner()).isEqualTo((Object)kieScannerResource);
        ServiceResponse getResponse = this.kieServer.getContainerInfo(containerId);
        Assertions.assertThat((Comparable)getResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.SUCCESS);
        Assertions.assertThat((Object)((KieContainerResource)getResponse.getResult()).getScanner()).isEqualTo((Object)kieScannerResource);
    }

    @Test
    public void kieServerStateResponseTest() {
        System.setProperty("org.kie.server.user", "kieserver");
        System.setProperty("org.kie.server.pwd", "kieserver1!");
        System.setProperty("org.kie.server.token", "abcd-abcd-abcd-abcd");
        System.setProperty("org.kie.server.controller.user", "ControllerUser");
        System.setProperty("org.kie.server.controller.pwd", "ControllerUser1234");
        System.setProperty("org.kie.server.controller.token", "abcd-abcd-abcd-abcd");
        try {
            this.kieServer.destroy();
            this.kieServer = new KieServerImpl((KieServerStateRepository)new KieServerStateFileRepository(REPOSITORY_DIR));
            this.kieServer.init();
            ServiceResponse kieServerStateResponse = this.kieServer.getServerState();
            Assert.assertNotNull((Object)kieServerStateResponse);
            Assertions.assertThat((Comparable)kieServerStateResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.SUCCESS);
            List configItems = ((KieServerStateInfo)kieServerStateResponse.getResult()).getConfiguration().getConfigItems();
            Assert.assertTrue((boolean)configItems.contains(new KieServerConfigItem("org.kie.server.user", "kieserver", "java.lang.String")));
            Assert.assertFalse((boolean)configItems.contains(new KieServerConfigItem("org.kie.server.pwd", "kieserver1!", "java.lang.String")));
            Assert.assertFalse((boolean)configItems.contains(new KieServerConfigItem("org.kie.server.token", "abcd-abcd-abcd-abcd", "java.lang.String")));
            Assert.assertTrue((boolean)configItems.contains(new KieServerConfigItem("org.kie.server.controller.user", "ControllerUser", "java.lang.String")));
            Assert.assertFalse((boolean)configItems.contains(new KieServerConfigItem("org.kie.server.controller.pwd", "ControllerUser1234", "java.lang.String")));
            Assert.assertFalse((boolean)configItems.contains(new KieServerConfigItem("org.kie.server.controller.token", "abcd-abcd-abcd-abcd", "java.lang.String")));
        }
        finally {
            System.clearProperty("org.kie.server.user");
            System.clearProperty("org.kie.server.pwd");
            System.clearProperty("org.kie.server.token");
            System.clearProperty("org.kie.server.controller.user");
            System.clearProperty("org.kie.server.controller.pwd");
            System.clearProperty("org.kie.server.controller.token");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutorPropertiesInStateRepository() {
        KieServerStateFileRepository stateRepository = new KieServerStateFileRepository(REPOSITORY_DIR);
        KieServerState state = stateRepository.load(KIE_SERVER_ID);
        String executorInterval = state.getConfiguration().getConfigItemValue("org.kie.executor.interval");
        String executorRetries = state.getConfiguration().getConfigItemValue("org.kie.executor.retry.count");
        String executorPool = state.getConfiguration().getConfigItemValue("org.kie.executor.pool.size");
        String executorTimeUnit = state.getConfiguration().getConfigItemValue("org.kie.executor.timeunit");
        String executorJMSQueue = state.getConfiguration().getConfigItemValue("org.kie.executor.jms.queue");
        String executorDisabled = state.getConfiguration().getConfigItemValue("org.kie.executor.disabled");
        Assert.assertNull((Object)executorInterval);
        Assert.assertNull((Object)executorRetries);
        Assert.assertNull((Object)executorPool);
        Assert.assertNull((Object)executorTimeUnit);
        Assert.assertNull((Object)executorJMSQueue);
        Assert.assertNull((Object)executorDisabled);
        try {
            System.setProperty("org.kie.executor.interval", "4");
            System.setProperty("org.kie.executor.retry.count", "7");
            System.setProperty("org.kie.executor.pool.size", "11");
            System.setProperty("org.kie.executor.timeunit", "HOURS");
            System.setProperty("org.kie.executor.jms.queue", "queue/MY.OWN.QUEUE");
            System.setProperty("org.kie.executor.disabled", "true");
            stateRepository.clearCache();
            state = stateRepository.load(KIE_SERVER_ID);
            executorInterval = state.getConfiguration().getConfigItemValue("org.kie.executor.interval");
            executorRetries = state.getConfiguration().getConfigItemValue("org.kie.executor.retry.count");
            executorPool = state.getConfiguration().getConfigItemValue("org.kie.executor.pool.size");
            executorTimeUnit = state.getConfiguration().getConfigItemValue("org.kie.executor.timeunit");
            executorJMSQueue = state.getConfiguration().getConfigItemValue("org.kie.executor.jms.queue");
            executorDisabled = state.getConfiguration().getConfigItemValue("org.kie.executor.disabled");
            Assert.assertNotNull((Object)executorInterval);
            Assert.assertNotNull((Object)executorRetries);
            Assert.assertNotNull((Object)executorPool);
            Assert.assertNotNull((Object)executorTimeUnit);
            Assert.assertNotNull((Object)executorJMSQueue);
            Assert.assertNotNull((Object)executorDisabled);
            Assert.assertEquals((Object)"4", (Object)executorInterval);
            Assert.assertEquals((Object)"7", (Object)executorRetries);
            Assert.assertEquals((Object)"11", (Object)executorPool);
            Assert.assertEquals((Object)"HOURS", (Object)executorTimeUnit);
            Assert.assertEquals((Object)"queue/MY.OWN.QUEUE", (Object)executorJMSQueue);
            Assert.assertEquals((Object)"true", (Object)executorDisabled);
        }
        finally {
            System.clearProperty("org.kie.executor.interval");
            System.clearProperty("org.kie.executor.retry.count");
            System.clearProperty("org.kie.executor.pool.size");
            System.clearProperty("org.kie.executor.timeunit");
            System.clearProperty("org.kie.executor.jms.queue");
            System.clearProperty("org.kie.executor.disabled");
        }
    }

    protected KieServerImpl delayedKieServer(final CountDownLatch latch, final CountDownLatch startedlatch) {
        KieServerImpl server = new KieServerImpl((KieServerStateRepository)new KieServerStateFileRepository(REPOSITORY_DIR)){

            public void markAsReady() {
                super.markAsReady();
                startedlatch.countDown();
            }

            public KieServerController getController() {
                return new DefaultRestControllerImpl(this.getServerRegistry()){

                    public KieServerSetup connect(KieServerInfo serverInfo) {
                        try {
                            if (latch.await(10L, TimeUnit.MILLISECONDS)) {
                                return new KieServerSetup();
                            }
                            throw new KieControllerNotConnectedException("Unable to connect to any controller");
                        }
                        catch (InterruptedException e) {
                            throw new KieControllerNotConnectedException("Unable to connect to any controller");
                        }
                    }
                };
            }
        };
        server.init();
        return server;
    }

    protected void assertForbiddenResponse(ServiceResponse<?> forbidden) {
        Assert.assertNotNull(forbidden);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.FAILURE, (Object)forbidden.getType());
        Assert.assertEquals((Object)"KIE Server management api is disabled", (Object)forbidden.getMsg());
    }

    protected void assertReleaseIds(String containerId, ReleaseId configuredReleaseId, ReleaseId resolvedReleaseId, long timeoutMillis) throws InterruptedException {
        for (long timeSpentWaiting = 0L; timeSpentWaiting < timeoutMillis; timeSpentWaiting += 200L) {
            ServiceResponse listResponse = this.kieServer.listContainers(KieContainerResourceFilter.ACCEPT_ALL);
            Assertions.assertThat((Comparable)listResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.SUCCESS);
            List containers = ((KieContainerResourceList)listResponse.getResult()).getContainers();
            for (KieContainerResource container : containers) {
                if (!configuredReleaseId.equals((Object)container.getReleaseId()) || !resolvedReleaseId.equals((Object)container.getResolvedReleaseId())) continue;
                return;
            }
            Thread.sleep(200L);
        }
        Assertions.fail((String)("Waiting too long for container " + containerId + " to have expected releaseIds updated! expected: releaseId=" + configuredReleaseId + ", resolvedReleaseId=" + resolvedReleaseId));
    }

    protected void createEmptyKjar(String artifactId) {
        this.createEmptyKjar(artifactId, this.testVersion);
    }

    protected void createEmptyKjar(String artifactId, String version) {
        KieServices kieServices = KieServices.Factory.get();
        KieFileSystem kfs = kieServices.newKieFileSystem();
        this.releaseId = kieServices.newReleaseId(GROUP_ID, artifactId, version);
        KieModule kieModule = kieServices.newKieBuilder(kfs).buildAll().getKieModule();
        KieMavenRepository.getKieMavenRepository().installArtifact((AFReleaseId)this.releaseId, (InternalKieModule)kieModule, this.createPomFile(artifactId, version));
        kieServices.getRepository().addKieModule(kieModule);
    }

    protected File createPomFile(String artifactId, String version) {
        String pomContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>org.kie.server.test</groupId>\n  <artifactId>" + artifactId + "</artifactId>\n  <version>" + version + "</version>\n  <packaging>pom</packaging>\n</project>";
        try {
            File file = new File("target/" + artifactId + "-1.0.0.Final.pom");
            FileUtils.write((File)file, (CharSequence)pomContent);
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

