/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.storage.file;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.soup.commons.xstream.XStreamUtils;

public class KieServerStateFileRepository
implements KieServerStateRepository {
    private final File repositoryDir;
    private XStream xs;
    private Map<String, KieServerState> knownStates = new ConcurrentHashMap<String, KieServerState>();

    public KieServerStateFileRepository(File repositoryDir) {
        this.repositoryDir = repositoryDir;
        this.xs = XStreamUtils.createTrustingXStream((ReflectionProvider)new PureJavaReflectionProvider());
        String[] voidDeny = new String[]{"void.class", "Void.class"};
        this.xs.denyTypes(voidDeny);
        this.xs.alias("kie-server-state", KieServerState.class);
        this.xs.alias("container", KieContainerResource.class);
        this.xs.alias("config-item", KieServerConfigItem.class);
    }

    public KieServerStateFileRepository() {
        this(new File(System.getProperty("org.kie.server.repo", ".")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void store(String serverId, KieServerState kieServerState) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(this.repositoryDir, serverId + ".xml"));
            this.xs.toXML((Object)kieServerState, (OutputStream)fos);
        }
        catch (IOException iOException) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.knownStates.put(serverId, kieServerState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KieServerState load(String serverId) {
        if (this.knownStates.containsKey(serverId)) {
            return this.knownStates.get(serverId);
        }
        Map<String, KieServerState> map = this.knownStates;
        synchronized (map) {
            File serverStateFile = new File(this.repositoryDir, serverId + ".xml");
            KieServerState kieServerState = new KieServerState();
            if (serverStateFile.exists()) {
                kieServerState = (KieServerState)this.xs.fromXML(serverStateFile);
                String defaultController = System.getProperty("org.kie.server.controller");
                if (defaultController != null) {
                    String[] controllerList = defaultController.split(",");
                    HashSet<String> controllers = new HashSet<String>();
                    for (String controller : controllerList) {
                        controllers.add(controller.trim());
                    }
                    kieServerState.setControllers(controllers);
                }
                this.populateWithSystemProperties(kieServerState.getConfiguration());
            } else {
                KieServerConfig config = new KieServerConfig();
                this.populateWithSystemProperties(config);
                kieServerState.setConfiguration(config);
            }
            this.knownStates.put(serverId, kieServerState);
            return kieServerState;
        }
    }

    protected void populateWithSystemProperties(KieServerConfig config) {
        this.populateWithProperties(config, System.getProperties());
    }

    void populateWithProperties(KieServerConfig config, Properties properties) {
        for (String property : properties.stringPropertyNames()) {
            if (!property.startsWith("org.kie.server") && !property.startsWith("org.kie.executor")) continue;
            KieServerConfigItem configItem = new KieServerConfigItem(property, properties.getProperty(property), String.class.getName());
            config.addConfigItem(configItem);
        }
    }

    public void clearCache() {
        this.knownStates.clear();
    }
}

