/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.services.impl.security.JACCIdentityProvider;

public class JACCIdentityProviderWildFlyTomcatTest {
    private static final String PRINCIPAL_NAME = "yoda";
    private static final String GROUP_ONE_NAME = "groupOne";
    private static final String GROUP_TWO_NAME = "groupTwo";
    private PolicyContextHandler handler;

    @Before
    public void setUp() throws Exception {
        final GroupImpl groupRoles = new GroupImpl("Roles");
        GroupImpl groupOne = new GroupImpl(GROUP_ONE_NAME);
        GroupImpl groupTwo = new GroupImpl(GROUP_TWO_NAME);
        final UserImpl user = new UserImpl(PRINCIPAL_NAME);
        groupOne.addMember(user);
        groupTwo.addMember(user);
        groupRoles.addMember((Principal)((Object)groupOne));
        groupRoles.addMember((Principal)((Object)groupTwo));
        this.handler = new PolicyContextHandler(){

            public boolean supports(String key) throws PolicyContextException {
                return "javax.security.auth.Subject.container".equals(key);
            }

            public String[] getKeys() throws PolicyContextException {
                return new String[]{"javax.security.auth.Subject.container"};
            }

            public Object getContext(String key, Object data) throws PolicyContextException {
                LinkedHashSet<Object> principals = new LinkedHashSet<Object>();
                principals.add(groupRoles);
                principals.add(user);
                Subject s = new Subject(true, principals, Collections.EMPTY_SET, Collections.EMPTY_SET);
                return s;
            }
        };
        PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)this.handler, (boolean)true);
    }

    @Test
    public void testGetName() throws Exception {
        JACCIdentityProvider jaccIdentityProvider = new JACCIdentityProvider();
        Assert.assertEquals((Object)PRINCIPAL_NAME, (Object)jaccIdentityProvider.getName());
    }

    @Test
    public void testGetRoles() throws Exception {
        JACCIdentityProvider jaccIdentityProvider = new JACCIdentityProvider();
        Assert.assertEquals((long)2L, (long)jaccIdentityProvider.getRoles().size());
        Assert.assertTrue((boolean)jaccIdentityProvider.getRoles().contains(GROUP_ONE_NAME));
        Assert.assertTrue((boolean)jaccIdentityProvider.getRoles().contains(GROUP_TWO_NAME));
    }

    private class UserImpl
    implements Principal {
        private String name;

        public UserImpl(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private class GroupImpl
    implements Group {
        private String name;
        private Collection<Principal> members;

        public GroupImpl(String name) {
            this.name = name;
            this.members = new ArrayList<Principal>();
        }

        public String getName() {
            return this.name;
        }

        public boolean addMember(Principal user) {
            if (this.members.contains(user)) {
                return false;
            }
            this.members.add(user);
            return true;
        }

        public boolean removeMember(Principal user) {
            if (this.members.contains(user)) {
                this.members.remove(user);
                return true;
            }
            return false;
        }

        public boolean isMember(Principal member) {
            return this.members.contains(member);
        }

        public Enumeration<? extends Principal> members() {
            return Collections.enumeration(this.members);
        }
    }
}

