/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.dmn;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServerCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.api.model.Wrapped;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.dmn.ModelEvaluatorServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNKieContainerCommandServiceImpl
implements KieContainerCommandService {
    private static final Logger LOG = LoggerFactory.getLogger(DMNKieContainerCommandServiceImpl.class);
    private KieServerRegistry context;
    private ModelEvaluatorServiceBase modelEvaluatorServiceBase;

    public DMNKieContainerCommandServiceImpl(KieServerRegistry context, ModelEvaluatorServiceBase modelEvaluatorServiceBase) {
        this.context = context;
        this.modelEvaluatorServiceBase = modelEvaluatorServiceBase;
    }

    public ServiceResponse<String> callContainer(String containerId, String payload, MarshallingFormat marshallingFormat, String classType) {
        return null;
    }

    public ServiceResponsesList executeScript(CommandScript commands, MarshallingFormat marshallingFormat, String classType) {
        ArrayList<ServiceResponse> responses = new ArrayList<ServiceResponse>();
        for (KieServerCommand command : commands.getCommands()) {
            if (!(command instanceof DescriptorCommand)) {
                LOG.warn("Unsupported command '{}' given, will not process it", (Object)command.getClass().getName());
                continue;
            }
            try {
                ServiceResponse result = null;
                ModelEvaluatorServiceBase handler = null;
                DescriptorCommand descriptorCommand = (DescriptorCommand)command;
                if (!"DMNService".equals(descriptorCommand.getService())) {
                    throw new IllegalStateException("Unable to find handler for " + descriptorCommand.getService() + " service");
                }
                handler = this.modelEvaluatorServiceBase;
                ArrayList arguments = new ArrayList();
                for (Object arg : descriptorCommand.getArguments()) {
                    LOG.debug("Before :: Argument with type {} and value {}", arg.getClass(), arg);
                    if (arg instanceof Wrapped) {
                        arg = ((Wrapped)arg).unwrap();
                    }
                    LOG.debug("After :: Argument with type {} and value {}", arg.getClass(), arg);
                    arguments.add(arg);
                }
                if (descriptorCommand.getPayload() != null && !descriptorCommand.getPayload().isEmpty()) {
                    arguments.add(descriptorCommand.getPayload());
                }
                if (descriptorCommand.getMarshallerFormat() != null && !descriptorCommand.getMarshallerFormat().isEmpty()) {
                    arguments.add(descriptorCommand.getMarshallerFormat());
                }
                LOG.debug("About to execute {} operation on {} with args {}", new Object[]{descriptorCommand.getMethod(), handler, arguments});
                result = (ServiceResponse)MethodUtils.invokeMethod((Object)handler, (String)descriptorCommand.getMethod(), (Object[])arguments.toArray());
                LOG.debug("Handler {} returned response {}", (Object)handler, (Object)result);
                responses.add(result);
            }
            catch (InvocationTargetException e) {
                responses.add(new ServiceResponse(ServiceResponse.ResponseType.FAILURE, e.getTargetException().getMessage()));
            }
            catch (Throwable e) {
                LOG.error("Error while processing {} command", (Object)command, (Object)e);
                responses.add(new ServiceResponse(ServiceResponse.ResponseType.FAILURE, e.getMessage()));
            }
        }
        LOG.debug("About to return responses '{}'", responses);
        return new ServiceResponsesList(responses);
    }
}

