/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.dmn.modelspecific;

import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.kie.api.builder.ReleaseId;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.model.api.DecisionService;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.model.DMNModelIOSets;
import org.kie.dmn.openapi.model.DMNOASResult;
import org.kie.server.api.KieServerEnvironment;

public class OASGenerator {
    private final String containerId;
    private final ReleaseId releaseId;

    public OASGenerator(String containerId, ReleaseId releaseId) {
        this.containerId = containerId;
        this.releaseId = releaseId;
    }

    public String generateOAS(Collection<DMNModel> models, boolean asJSON) throws Exception, IOException {
        DMNOASResult dmnoas = DMNOASGeneratorFactory.generator(models, (String)"#/components/schemas/").build();
        OpenAPI openAPI = this.loadOASTemplate();
        Info info = ((Info)OASFactory.createObject(Info.class)).title(this.containerId + " DMN endpoints").description("DMN model-specific OAS generated for container " + this.containerId + " as " + this.releaseId).version(this.releaseId.getVersion());
        openAPI.info(info);
        Server server = (Server)OASFactory.createObject(Server.class);
        String contextRoot = KieServerEnvironment.getContextRoot();
        if (contextRoot != null) {
            server.url(contextRoot + "/services/rest");
        }
        openAPI.addServer(server);
        for (Map.Entry kv : dmnoas.getSchemas().entrySet()) {
            openAPI.getComponents().addSchema(dmnoas.getNamingPolicy().getName((DMNType)kv.getKey()), (Schema)kv.getValue());
        }
        openAPI.paths((Paths)OASFactory.createObject(Paths.class));
        for (DMNModel dmnModel : models) {
            openAPI.addTag(OASFactory.createTag().name(dmnModel.getName()).description(" "));
            this.pathModel(openAPI, dmnModel, dmnoas);
            this.pathModelDMNResult(openAPI, dmnModel, dmnoas);
            for (DecisionService ds : dmnModel.getDefinitions().getDecisionService()) {
                if (ds.getAdditionalAttributes().keySet().stream().anyMatch(qn -> qn.getLocalPart().equals("dynamicDecisionService"))) continue;
                this.pathModelDS(openAPI, dmnModel, ds, dmnoas);
                this.pathModelDSDMNResult(openAPI, dmnModel, ds, dmnoas);
            }
        }
        String content = OpenApiSerializer.serialize((OpenAPI)openAPI, (Format)(asJSON ? Format.JSON : Format.YAML));
        return content;
    }

    private void pathModelDSDMNResult(OpenAPI openAPI, DMNModel dmnModel, DecisionService ds, DMNOASResult dmnoas) {
        String description = "model decision service '" + ds.getName() + "' for structured DMNResult";
        DMNModelIOSets ioSets = dmnoas.lookupIOSetsByModel(dmnModel);
        DMNType identifyInputSet = ioSets.lookupDSIOSetsByName(ds.getName()).getDSInputSet();
        String inputRef = dmnoas.getNamingPolicy().getRef(identifyInputSet);
        Operation operation = this.buildOperationWithIORefs(description, inputRef, "#/components/schemas/MSDMNE_KogitoDMNResult").summary(description).addTag(dmnModel.getName());
        PathItem pathItem = (PathItem)OASFactory.createObject(PathItem.class);
        pathItem.POST(operation);
        openAPI.getPaths().addPathItem("/server/containers/" + this.containerId + "/dmn/models/" + dmnModel.getName() + "/" + ds.getName() + "/dmnresult", pathItem);
    }

    private void pathModelDS(OpenAPI openAPI, DMNModel dmnModel, DecisionService ds, DMNOASResult dmnoas) {
        String description = "model decision service '" + ds.getName() + "'";
        DMNModelIOSets ioSets = dmnoas.lookupIOSetsByModel(dmnModel);
        DMNType identifyInputSet = ioSets.lookupDSIOSetsByName(ds.getName()).getDSInputSet();
        DMNType identifyOutputSet = ioSets.lookupDSIOSetsByName(ds.getName()).getDSOutputSet();
        String inputRef = dmnoas.getNamingPolicy().getRef(identifyInputSet);
        String outputRef = dmnoas.getNamingPolicy().getRef(identifyOutputSet);
        Operation operation = this.buildOperationWithIORefs(description, inputRef, outputRef).summary(description).addTag(dmnModel.getName());
        PathItem pathItem = (PathItem)OASFactory.createObject(PathItem.class);
        pathItem.POST(operation);
        openAPI.getPaths().addPathItem("/server/containers/" + this.containerId + "/dmn/models/" + dmnModel.getName() + "/" + ds.getName(), pathItem);
    }

    private void pathModelDMNResult(OpenAPI openAPI, DMNModel dmnModel, DMNOASResult dmnoas) {
        String description = "model evaluation for structured DMNResult";
        DMNModelIOSets ioSets = dmnoas.lookupIOSetsByModel(dmnModel);
        DMNType identifyInputSet = ioSets.getInputSet();
        String inputRef = dmnoas.getNamingPolicy().getRef(identifyInputSet);
        Operation operation = this.buildOperationWithIORefs("model evaluation for structured DMNResult", inputRef, "#/components/schemas/MSDMNE_KogitoDMNResult").summary("model evaluation for structured DMNResult").addTag(dmnModel.getName());
        PathItem pathItem = (PathItem)OASFactory.createObject(PathItem.class);
        pathItem.POST(operation);
        openAPI.getPaths().addPathItem("/server/containers/" + this.containerId + "/dmn/models/" + dmnModel.getName() + "/dmnresult", pathItem);
    }

    private void pathModel(OpenAPI openAPI, DMNModel dmnModel, DMNOASResult dmnoas) {
        PathItem pathItem = (PathItem)OASFactory.createObject(PathItem.class);
        openAPI.getPaths().addPathItem("/server/containers/" + this.containerId + "/dmn/models/" + dmnModel.getName(), pathItem);
        this.pathModelGET(pathItem, dmnModel);
        this.pathModelPOST(pathItem, dmnModel, dmnoas);
    }

    private void pathModelPOST(PathItem pathItem, DMNModel dmnModel, DMNOASResult dmnoas) {
        String description = "model evaluation";
        DMNModelIOSets ioSets = dmnoas.lookupIOSetsByModel(dmnModel);
        DMNType identifyInputSet = ioSets.getInputSet();
        DMNType identifyOutputSet = ioSets.getOutputSet();
        String inputRef = dmnoas.getNamingPolicy().getRef(identifyInputSet);
        String outputRef = dmnoas.getNamingPolicy().getRef(identifyOutputSet);
        Operation operation = this.buildOperationWithIORefs("model evaluation", inputRef, outputRef).summary("model evaluation").addTag(dmnModel.getName());
        pathItem.POST(operation);
    }

    private void pathModelGET(PathItem pathItem, DMNModel dmnModel) {
        MediaType mediaType = OASFactory.createMediaType().schema(OASFactory.createSchema().type(Schema.SchemaType.STRING));
        Content content = ((Content)OASFactory.createObject(Content.class)).addMediaType("application/xml", mediaType);
        APIResponse apiResponse = ((APIResponse)OASFactory.createObject(APIResponse.class)).description("model without decision-logic");
        apiResponse.content(content);
        APIResponses apiResponses = (APIResponses)OASFactory.createObject(APIResponses.class);
        apiResponses.defaultValue(apiResponse);
        Operation getOperation = ((Operation)OASFactory.createObject(Operation.class)).responses(apiResponses).summary("Retrieve DMN model XML without decision-logic").addTag(dmnModel.getName());
        pathItem.GET(getOperation);
    }

    private Operation buildOperationWithIORefs(String description, String inputRef, String outputRef) {
        MediaType mediaType = OASFactory.createMediaType().schema((Schema)OASFactory.createSchema().ref(outputRef));
        Content content = ((Content)OASFactory.createObject(Content.class)).addMediaType("application/json", mediaType);
        APIResponse apiResponse = ((APIResponse)OASFactory.createObject(APIResponse.class)).description(description);
        apiResponse.content(content);
        APIResponses apiResponses = (APIResponses)OASFactory.createObject(APIResponses.class);
        apiResponses.defaultValue(apiResponse);
        MediaType requestMediaType = OASFactory.createMediaType().schema((Schema)OASFactory.createSchema().ref(inputRef));
        Content requestContent = OASFactory.createContent().addMediaType("application/json", requestMediaType);
        RequestBody requestBody = OASFactory.createRequestBody().description(description).content(requestContent);
        Operation operation = ((Operation)OASFactory.createObject(Operation.class)).responses(apiResponses).requestBody(requestBody);
        return operation;
    }

    /*
     * Exception decompiling
     */
    private OpenAPI loadOASTemplate() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

