/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.cluster;

import java.util.Arrays;
import java.util.List;
import org.jbpm.executor.AsynchronousJobEvent;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.RequeueAware;
import org.kie.api.cluster.ClusterAwareService;
import org.kie.api.cluster.ClusterListener;
import org.kie.api.cluster.ClusterNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteredJobFailOverListener
implements ClusterListener,
AsynchronousJobListener {
    private static final Logger logger = LoggerFactory.getLogger(ClusteredJobFailOverListener.class);
    private ClusterAwareService clusterService;
    private RequeueAware executorService;

    public ClusteredJobFailOverListener(ClusterAwareService clusterService, RequeueAware executorService) {
        this.clusterService = clusterService;
        this.executorService = executorService;
    }

    public void nodeJoined(ClusterNode node) {
        logger.info("Node joined in cluster {} node {}", (Object)node.getServerId(), (Object)node);
    }

    public void nodeLeft(ClusterNode node) {
        List jobs = this.clusterService.getDataFromPartition("jobs", node.toKey());
        if (jobs == null || jobs.isEmpty()) {
            return;
        }
        logger.info("Node left cluster {}, failing over and requeuing {}", (Object)node, (Object)Arrays.toString(jobs.toArray()));
        jobs.forEach(jobId -> {
            try {
                this.executorService.requeueById(jobId);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Job was already completed or cancelled {}. Cannot be rescheduled", jobId);
            }
        });
    }

    public void afterJobScheduled(AsynchronousJobEvent event) {
        logger.debug("Adding job scheduled {} for failover", (Object)event);
        Long data = event.getJob().getId();
        this.clusterService.addData("jobs", this.clusterService.getThisNode().toKey(), (Object)data);
    }

    public void afterJobExecuted(AsynchronousJobEvent event) {
        logger.debug("Removing executed job {} from failover", (Object)event.getJob());
        Long data = event.getJob().getId();
        this.clusterService.removeData("jobs", this.clusterService.getThisNode().toKey(), (Object)data);
    }

    public void afterJobCancelled(AsynchronousJobEvent event) {
        logger.debug("Removing cancelled job {} from failover", (Object)event.getJob());
        Long data = event.getJob().getId();
        this.clusterService.removeData("jobs", this.clusterService.getThisNode().toKey(), (Object)data);
    }

    public void beforeJobScheduled(AsynchronousJobEvent event) {
    }

    public void beforeJobExecuted(AsynchronousJobEvent event) {
    }

    public void beforeJobCancelled(AsynchronousJobEvent event) {
    }
}

