/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.jbpm.services.api.model.ProcessInstanceWithVarsDesc;
import org.jbpm.services.api.model.UserTaskInstanceWithVarsDesc;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.QueryService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.query.QueryContext;
import org.kie.server.api.model.definition.BaseQueryFilterSpec;
import org.kie.server.api.model.definition.ProcessInstanceQueryFilterSpec;
import org.kie.server.api.model.definition.QueryParam;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.TaskInstanceList;
import org.kie.server.services.jbpm.search.QueryCallback;
import org.kie.server.services.jbpm.search.QueryServiceTemplate;
import org.kie.server.services.jbpm.search.RequestCallback;
import org.kie.server.services.jbpm.search.util.ProcessInstanceQueryStrategy;
import org.kie.server.services.jbpm.search.util.QueryStrategy;
import org.mockito.Mockito;

public class QueryServiceTemplateTest {
    QueryServiceTemplate qst;

    @Before
    public void init() {
        QueryService queryServiceMock = (QueryService)Mockito.mock(QueryService.class);
        this.qst = new QueryServiceTemplate(queryServiceMock);
        Mockito.when((Object)queryServiceMock.query((String)Mockito.any(), (QueryResultMapper)Mockito.any(), (QueryContext)Mockito.any(), new org.jbpm.services.api.query.model.QueryParam[]{(org.jbpm.services.api.query.model.QueryParam)Mockito.any(org.jbpm.services.api.query.model.QueryParam.class)})).thenReturn(this.getProcessInstances());
    }

    @Test
    public void testGetWithFilters() {
        QueryCallback queryCallback = new QueryCallback(){

            public QueryStrategy getQueryStrategy() {
                return new ProcessInstanceQueryStrategy();
            }

            public String getQueryName() {
                return "TEST_QUERY";
            }

            public String getMapperName() {
                return "ProcessInstancesWithCustomVariables";
            }
        };
        RequestCallback reqCallback = new RequestCallback(){

            public BaseQueryFilterSpec getQueryFilterSpec() {
                ProcessInstanceQueryFilterSpec querySpec = new ProcessInstanceQueryFilterSpec();
                QueryParam[] parameters = new QueryParam[1];
                QueryParam param1 = new QueryParam();
                param1.setColumn("PROCESSNAME");
                param1.setOperator("EQUALS");
                ArrayList<String> values = new ArrayList<String>();
                values.add("test-process");
                param1.setValue(values);
                parameters[0] = param1;
                querySpec.setParameters(parameters);
                return querySpec;
            }
        };
        ProcessInstanceList processInstances = (ProcessInstanceList)this.qst.getWithFilters(Integer.valueOf(3), Integer.valueOf(11), queryCallback, reqCallback);
        Assert.assertEquals((long)2L, (long)processInstances.getProcessInstances().length);
    }

    @Test
    public void testTransformProcessInstanceCollection() {
        QueryResultMapper qrmMock = (QueryResultMapper)Mockito.mock(QueryResultMapper.class);
        Mockito.when((Object)qrmMock.getType()).thenReturn(ProcessInstanceWithVarsDesc.class);
        ProcessInstanceList processInstances = (ProcessInstanceList)this.qst.transform(this.getProcessInstances(), qrmMock);
        Assert.assertEquals((long)2L, (long)processInstances.getProcessInstances().length);
    }

    @Test
    public void testTransformUserTaskInstanceCollection() {
        QueryResultMapper qrmMock = (QueryResultMapper)Mockito.mock(QueryResultMapper.class);
        Mockito.when((Object)qrmMock.getType()).thenReturn(UserTaskInstanceWithVarsDesc.class);
        TaskInstanceList taskInstances = (TaskInstanceList)this.qst.transform(this.getUserTaskInstances(), qrmMock);
        Assert.assertEquals((long)1L, (long)taskInstances.getTasks().length);
    }

    @Test
    public void testTransformNoCollection() {
        QueryResultMapper qrmMock = (QueryResultMapper)Mockito.mock(QueryResultMapper.class);
        Mockito.when((Object)qrmMock.getType()).thenReturn(String.class);
        String nonCollection = "This is not a collection.";
        Object transformed = this.qst.transform((Object)nonCollection, qrmMock);
        Assert.assertEquals((Object)nonCollection, (Object)transformed);
    }

    @Test
    public void testTransformNull() {
        QueryResultMapper qrmMock = (QueryResultMapper)Mockito.mock(QueryResultMapper.class);
        Mockito.when((Object)qrmMock.getType()).thenReturn(String.class);
        Object transformed = this.qst.transform(null, qrmMock);
        Assert.assertNull((Object)transformed);
    }

    private Collection<ProcessInstanceWithVarsDesc> getProcessInstances() {
        ArrayList<ProcessInstanceWithVarsDesc> processInstances = new ArrayList<ProcessInstanceWithVarsDesc>();
        org.jbpm.kie.services.impl.model.ProcessInstanceWithVarsDesc processInstance1 = new org.jbpm.kie.services.impl.model.ProcessInstanceWithVarsDesc(42L, "test-process-id", "test-process", "1.0", 1, "test-deployment", new Date(), "mswiderski", "test description", "ck101");
        org.jbpm.kie.services.impl.model.ProcessInstanceWithVarsDesc processInstance2 = new org.jbpm.kie.services.impl.model.ProcessInstanceWithVarsDesc(43L, "anotehr-process-id", "another-process", "1.3", 2, "another-deployment", new Date(), "mfusco", "another description", "ck102");
        processInstances.add((ProcessInstanceWithVarsDesc)processInstance1);
        processInstances.add((ProcessInstanceWithVarsDesc)processInstance2);
        return processInstances;
    }

    private Collection<UserTaskInstanceWithVarsDesc> getUserTaskInstances() {
        ArrayList<UserTaskInstanceWithVarsDesc> tasks = new ArrayList<UserTaskInstanceWithVarsDesc>();
        org.jbpm.kie.services.impl.model.UserTaskInstanceWithVarsDesc task1 = new org.jbpm.kie.services.impl.model.UserTaskInstanceWithVarsDesc(new Long(1L), "RESERVED", new Date(), "test-task", "Test task", new Integer(1), "ddoyle", "mswiderski", "test-deployment", "test-process", new Long(1L), new Date(), new Date());
        tasks.add((UserTaskInstanceWithVarsDesc)task1);
        return tasks;
    }
}

