/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.executor.ExecutorService;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.jbpm.JbpmKieServerExtension;
import org.kie.server.services.jbpm.JbpmKieServerExtensionBaseTest;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class JbpmKieServerExtensionTest
extends JbpmKieServerExtensionBaseTest {
    @Mock
    private KieServerImpl kieServer;
    @Mock
    private KieServerRegistry kieServerRegistry;
    private JbpmKieServerExtension serverExtension;

    @Before
    public void setUp() throws Exception {
        this.serverExtension = new JbpmKieServerExtension();
    }

    @Test
    public void testExecutorServiceDisabling() throws Exception {
        KieServerConfigItem configItemTm = new KieServerConfigItem("org.kie.server.persistence.tm", "org.hibernate.service.jta.platform.internal.BitronixJtaPlatform", String.class.getName());
        KieServerConfigItem configItemExecutor = new KieServerConfigItem("org.kie.executor.disabled", "true", String.class.getName());
        KieServerConfig kieServerConfig = new KieServerConfig();
        kieServerConfig.addConfigItem(configItemTm);
        kieServerConfig.addConfigItem(configItemExecutor);
        Mockito.when((Object)this.kieServerRegistry.getConfig()).thenReturn((Object)kieServerConfig);
        this.serverExtension.init(this.kieServer, this.kieServerRegistry);
        ExecutorService executorService = (ExecutorService)this.serverExtension.getAppComponents(ExecutorService.class);
        Assert.assertNull((Object)executorService);
    }
}

