/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.jbpm.kie.services.impl.model.UserTaskInstanceWithPotOwnerDesc;
import org.jbpm.services.api.query.QueryMapperRegistry;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.QueryService;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieServerRegistryImpl;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;
import org.kie.server.services.jbpm.JbpmKieServerExtension;
import org.kie.server.services.jbpm.QueryDataServiceBase;
import org.mockito.Mockito;

public class QueryDataServiceBaseTest {
    @Test
    public void testLoadDefaultQueryDefinitions() {
        Date today = new Date();
        KieServerEnvironment.setServerId((String)UUID.randomUUID().toString());
        QueryService queryService = (QueryService)Mockito.mock(QueryService.class);
        KieServerRegistryImpl context = new KieServerRegistryImpl();
        context.registerStateRepository((KieServerStateRepository)new KieServerStateFileRepository(new File("target")));
        JbpmKieServerExtension extension = new JbpmKieServerExtension();
        extension.setQueryService(queryService);
        extension.setContext((KieServerRegistry)context);
        extension.registerDefaultQueryDefinitions();
        QueryDataServiceBase queryServiceBase = new QueryDataServiceBase(queryService, (KieServerRegistry)context);
        QueryResultMapper resultMapper = QueryMapperRegistry.get().mapperFor("UserTasksWithPotOwners", null);
        ArrayList<UserTaskInstanceWithPotOwnerDesc> result = new ArrayList<UserTaskInstanceWithPotOwnerDesc>();
        UserTaskInstanceWithPotOwnerDesc resultPO = new UserTaskInstanceWithPotOwnerDesc("mcivantos", "mcivantos", today, today, Long.valueOf(1L), "test-task", Integer.valueOf(0), Long.valueOf(1L), "processId", "Reserved", "salaboy", "formName", "correlation-123", "subject", "container-1", "processDescription");
        result.add(resultPO);
        Object resultQueryBase = queryServiceBase.transform(result, resultMapper);
        Assert.assertNotNull((Object)resultQueryBase);
    }
}

