/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jbpm.kie.services.impl.model.ProcessInstanceDesc;
import org.jbpm.kie.services.impl.model.UserTaskInstanceDesc;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.kie.server.services.jbpm.ProcessServiceBase;
import org.kie.server.services.jbpm.locator.ByProcessInstanceIdContainerLocator;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProcessServiceBaseTest {
    @Mock
    private ProcessService processServiceMock;
    @Mock
    private DefinitionService definitionServiceMock;
    @Mock
    private MarshallerHelper marshallerHelperMock;
    @Mock
    private KieServerRegistry contextMock;
    @Mock
    private RuntimeDataService runtimeDataServiceMock;
    ProcessServiceBase processServiceBase;

    @Before
    public void setup() {
        this.processServiceBase = new ProcessServiceBase(this.processServiceMock, this.definitionServiceMock, this.runtimeDataServiceMock, this.contextMock);
        this.processServiceBase.setMarshallerHelper(this.marshallerHelperMock);
    }

    @Test
    public void testGetProcessInstanceSetsActiveTasks() {
        String containerId = "container";
        Long processInstanceId = 1L;
        boolean withVars = true;
        String marshallingType = "xstream";
        ProcessInstanceDesc processInstanceDesc = new ProcessInstanceDesc();
        UserTaskInstanceDesc task1 = new UserTaskInstanceDesc(Long.valueOf(1L), "Ready", new Date(), "Task1_name", "Task1_desc", Integer.valueOf(1), "Task1_Owner", "Task1_Creator", "deployment", "Process", processInstanceId, new Date(), new Date());
        UserTaskInstanceDesc task2 = new UserTaskInstanceDesc(Long.valueOf(2L), "Ready", new Date(), "Task2_name", "Task2_desc", Integer.valueOf(1), "Task2_Owner", "Task2_Creator", "deployment", "Process", processInstanceId, new Date(), new Date());
        processInstanceDesc.setActiveTasks(Arrays.asList(task1, task2));
        Mockito.when((Object)this.runtimeDataServiceMock.getProcessInstanceById(processInstanceId.longValue())).thenReturn((Object)processInstanceDesc);
        Mockito.when((Object)this.contextMock.getContainerId((String)Mockito.eq((Object)containerId), (ContainerLocator)Mockito.any(ByProcessInstanceIdContainerLocator.class))).thenReturn((Object)containerId);
        this.processServiceBase.getProcessInstance(containerId, (Number)processInstanceId, withVars, marshallingType);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ProcessInstance.class);
        ((MarshallerHelper)Mockito.verify((Object)this.marshallerHelperMock)).marshal((String)Mockito.eq((Object)containerId), (String)Mockito.eq((Object)marshallingType), captor.capture(), (ContainerLocator)Mockito.any(ByProcessInstanceIdContainerLocator.class));
        ProcessInstance processInstance = (ProcessInstance)captor.getValue();
        this.verifyProcessInstanceHasActiveTasks(processInstanceDesc, processInstance);
    }

    private void verifyProcessInstanceHasActiveTasks(ProcessInstanceDesc pid, ProcessInstance pi) {
        Assert.assertNotNull((Object)pid);
        Assert.assertNotNull((Object)pi);
        Assert.assertEquals((long)pid.getActiveTasks().size(), (long)pi.getActiveUserTasks().getItems().size());
        List userTaskInstanceDescsList = pid.getActiveTasks();
        List taskSummaryArray = pi.getActiveUserTasks().getItems();
        for (int i = 0; i < pid.getActiveTasks().size(); ++i) {
            this.verifyTaskInstanceEqualsTaskSummary((org.jbpm.services.api.model.UserTaskInstanceDesc)userTaskInstanceDescsList.get(i), (TaskSummary)taskSummaryArray.get(i));
        }
    }

    private void verifyTaskInstanceEqualsTaskSummary(org.jbpm.services.api.model.UserTaskInstanceDesc taskInstance, TaskSummary taskSummary) {
        Assert.assertEquals((Object)taskInstance.getTaskId(), (Object)taskSummary.getId());
        Assert.assertEquals((Object)taskInstance.getName(), (Object)taskSummary.getName());
        Assert.assertEquals((Object)taskInstance.getDescription(), (Object)taskSummary.getDescription());
        Assert.assertEquals((Object)taskInstance.getActivationTime(), (Object)taskSummary.getActivationTime());
        Assert.assertEquals((Object)taskInstance.getActualOwner(), (Object)taskSummary.getActualOwner());
        Assert.assertEquals((Object)taskInstance.getDeploymentId(), (Object)taskSummary.getContainerId());
        Assert.assertEquals((Object)taskInstance.getCreatedBy(), (Object)taskSummary.getCreatedBy());
        Assert.assertEquals((Object)taskInstance.getCreatedOn(), (Object)taskSummary.getCreatedOn());
        Assert.assertEquals((Object)taskInstance.getPriority(), (Object)taskSummary.getPriority());
        Assert.assertEquals((Object)taskInstance.getProcessId(), (Object)taskSummary.getProcessId());
        Assert.assertEquals((Object)taskInstance.getProcessInstanceId(), (Object)taskSummary.getProcessInstanceId());
        Assert.assertEquals((Object)taskInstance.getStatus(), (Object)taskSummary.getStatus());
    }
}

