/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.util.ArrayList;
import org.jbpm.services.api.AdvanceRuntimeDataService;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.query.QueryContext;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.RuntimeDataServiceBase;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class RuntimeDataServiceBaseTest {
    private final AdvanceRuntimeDataService advanceRuntimeDataService = (AdvanceRuntimeDataService)Mockito.mock(AdvanceRuntimeDataService.class);
    private final RuntimeDataService runtimeDataService = (RuntimeDataService)Mockito.mock(RuntimeDataService.class);
    private final KieServerRegistry context = (KieServerRegistry)Mockito.mock(KieServerRegistry.class);
    private final KieServerConfig config = (KieServerConfig)Mockito.mock(KieServerConfig.class);

    public RuntimeDataServiceBaseTest() {
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
    }

    @Test
    public void testGetProcessesByDeploymentId() {
        RuntimeDataServiceBase svc = new RuntimeDataServiceBase(this.runtimeDataService, this.advanceRuntimeDataService, this.context);
        String containerId = "container_id";
        Mockito.when((Object)this.context.getContainerId(ArgumentMatchers.anyString(), (ContainerLocator)ArgumentMatchers.any(ContainerLocator.class))).thenReturn((Object)containerId);
        ArrayList<ProcessDefinition> definitions = new ArrayList<ProcessDefinition>();
        definitions.add((ProcessDefinition)Mockito.mock(ProcessDefinition.class));
        Mockito.when((Object)this.runtimeDataService.getProcessesByDeploymentId(ArgumentMatchers.anyString(), (QueryContext)ArgumentMatchers.any())).thenReturn(definitions);
        ProcessDefinitionList result = svc.getProcessesByDeploymentId(containerId, Integer.valueOf(0), Integer.valueOf(100), null, true);
        Assert.assertEquals((long)1L, (long)result.getItems().size());
    }

    @Test
    public void testGetProcessesByDeploymentId_DeploymentNotFound() {
        RuntimeDataServiceBase svc = new RuntimeDataServiceBase(this.runtimeDataService, this.advanceRuntimeDataService, this.context);
        String containerId = "container_id";
        Mockito.when((Object)this.context.getContainerId(ArgumentMatchers.anyString(), (ContainerLocator)ArgumentMatchers.any(ContainerLocator.class))).thenReturn((Object)containerId);
        ArrayList definitions = new ArrayList();
        Mockito.when((Object)this.runtimeDataService.getProcessesByDeploymentId(ArgumentMatchers.anyString(), (QueryContext)ArgumentMatchers.any())).thenThrow(new Throwable[]{new DeploymentNotFoundException("not found")});
        ProcessDefinitionList result = svc.getProcessesByDeploymentId(containerId, Integer.valueOf(0), Integer.valueOf(100), null, true);
        Assert.assertTrue((boolean)result.getItems().isEmpty());
    }

    @Test
    public void testGetProcessesByDeploymentId_IllegalArgumentException() {
        RuntimeDataServiceBase svc = new RuntimeDataServiceBase(this.runtimeDataService, this.advanceRuntimeDataService, this.context);
        String containerId = "container_id";
        Mockito.when((Object)this.context.getContainerId(ArgumentMatchers.anyString(), (ContainerLocator)ArgumentMatchers.any(ContainerLocator.class))).thenReturn((Object)containerId);
        ArrayList definitions = new ArrayList();
        Mockito.when((Object)this.runtimeDataService.getProcessesByDeploymentId(ArgumentMatchers.anyString(), (QueryContext)ArgumentMatchers.any())).thenThrow(new Throwable[]{new IllegalArgumentException("client error")});
        ProcessDefinitionList result = svc.getProcessesByDeploymentId(containerId, Integer.valueOf(0), Integer.valueOf(100), null, true);
        Assert.assertTrue((boolean)result.getItems().isEmpty());
    }
}

