/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.locator;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.jbpm.locator.ByContextMappingInfoContainerLocator;
import org.kie.server.services.jbpm.locator.ByProcessInstanceIdContainerLocator;
import org.kie.server.services.jbpm.locator.ContainerLocatorFactoryMock;
import org.kie.server.services.jbpm.locator.ProcessContainerLocatorProvider;

public class ProcessContainerLocatorProviderTest {
    @Before
    public void setUp() {
        System.clearProperty("org.kie.server.process.instance.container.locator");
    }

    @Test
    public void testShouldGetDefaultLocator() {
        ContainerLocator containerLocator = ProcessContainerLocatorProvider.get().getLocator((Number)1L);
        MatcherAssert.assertThat((Object)containerLocator, (Matcher)CoreMatchers.instanceOf(ByProcessInstanceIdContainerLocator.class));
    }

    @Test
    public void testShouldReturnLocatorSetInProperty() {
        System.setProperty("org.kie.server.process.instance.container.locator", ByContextMappingInfoContainerLocator.class.getSimpleName());
        ContainerLocator containerLocator = ProcessContainerLocatorProvider.get().getLocator((Number)1L);
        MatcherAssert.assertThat((Object)containerLocator, (Matcher)CoreMatchers.instanceOf(ByContextMappingInfoContainerLocator.class));
    }

    @Test
    public void testShouldReturnLocatorFromServices() {
        System.setProperty("org.kie.server.process.instance.container.locator", "ContainerLocatorFactoryMock");
        ContainerLocator containerLocator = ProcessContainerLocatorProvider.get().getLocator((Number)1L);
        MatcherAssert.assertThat((Object)containerLocator, (Matcher)CoreMatchers.instanceOf(ContainerLocatorFactoryMock.ContainerLocatorMock.class));
    }

    @Test(expected=IllegalStateException.class)
    public void testLocatorNotExists() {
        System.setProperty("org.kie.server.process.instance.container.locator", "NotExistsContainerLocator");
        ProcessContainerLocatorProvider.get().getLocator((Number)1L);
    }
}

