/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.openshift.impl.storage.cloud;

import com.thoughtworks.xstream.XStream;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DoneableDeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.server.mock.OpenShiftServer;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.services.impl.StartupStrategyProvider;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.openshift.impl.storage.cloud.CloudClientFactory;
import org.kie.server.services.openshift.impl.storage.cloud.KieServerStateCloudRepository;
import org.kie.server.services.openshift.impl.storage.cloud.KieServerStateOpenShiftRepository;

public class KieServerStateOpenShiftRepositoryTest {
    private static final String KIE_SERVER_STARTUP_IN_PROGRESS_KEY_PREFIX = "org.kie.server.services/";
    private static final String KIE_SERVER_STARTUP_IN_PROGRESS_VALUE = "kie.server.startup_in_progress";
    private static final String TEST_KIE_SERVER_ID = "myapp2-kieserver";
    private static XStream xs = KieServerStateCloudRepository.initializeXStream();
    private static Supplier<OpenShiftClient> clouldClientHelper = () -> new CloudClientFactory(){}.createOpenShiftClient();
    private String testNamespace = "myproject";
    private OpenShiftClient client;
    private KieServerStateOpenShiftRepository repo;
    @Rule
    public OpenShiftServer server = new OpenShiftServer(false, true);

    @Before
    public void setup() {
        if (System.getenv("KIE_SERVER_ID") != null) {
            System.setProperty("org.kie.server.startup.strategy", "OpenShiftStartupStrategy");
            this.client = clouldClientHelper.get();
        } else {
            this.client = this.server.getOpenshiftClient();
            this.testNamespace = "test";
        }
        ConfigMap cfm = (ConfigMap)((Resource)this.client.configMaps().load(KieServerStateOpenShiftRepositoryTest.class.getResourceAsStream("/test-kieserver-state-config-map.yml"))).get();
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{cfm});
        this.repo = new KieServerStateOpenShiftRepository(){

            public OpenShiftClient createOpenShiftClient() {
                return KieServerStateOpenShiftRepositoryTest.this.client;
            }

            public KubernetesClient createKubernetesClient() {
                return KieServerStateOpenShiftRepositoryTest.this.client;
            }

            public boolean isKieServerReady() {
                return true;
            }
        };
        this.repo.load(TEST_KIE_SERVER_ID);
    }

    @Test
    public void testLiteralConfigMap() throws InterruptedException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("foo", "bar");
        data.put("cheese", "gouda");
        ConcurrentHashMap<String, String> ant = new ConcurrentHashMap<String, String>();
        ant.put("services.server.kie.org/kie-server-state.changeTimestamp", ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT));
        ConcurrentHashMap<String, String> lab = new ConcurrentHashMap<String, String>();
        lab.put("startup_in_progress", "kieserverId");
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("cfg1")).endMetadata()).addToData(data)).build()});
        try {
            ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).create((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("cfg1")).withLabels(lab)).withAnnotations(ant)).endMetadata()).addToData(data)).build()});
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("cfg2")).withLabels(lab)).withAnnotations(ant)).endMetadata()).addToData(data)).build()});
        ConfigMapList cfgList = (ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withLabel("startup_in_progress", "kieserverid")).list();
        Map keys = ((ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName("cfg1")).get()).getData();
        Assert.assertEquals((Object)"gouda", keys.get("cheese"));
        Assert.assertEquals((Object)"bar", keys.get("foo"));
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).delete(cfgList.getItems());
        Assert.assertTrue((boolean)((ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withLabel("startup_in_progress", "kieserverid")).list()).getItems().isEmpty());
    }

    @Test
    public void testKieServerStateConfigMap() throws InterruptedException {
        Resource configMapResource = (Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName(TEST_KIE_SERVER_ID);
        ConfigMap configMap = (ConfigMap)configMapResource.get();
        Assert.assertEquals((Object)TEST_KIE_SERVER_ID, (Object)configMap.getMetadata().getName());
        Map data = configMap.getData();
        String srvStateInXML = (String)data.get("kie-server-state");
        KieServerState kieServerState = (KieServerState)xs.fromXML(srvStateInXML);
        Assert.assertNotNull((Object)kieServerState);
        Assert.assertEquals((Object)TEST_KIE_SERVER_ID, (Object)kieServerState.getConfiguration().getConfigItem("org.kie.server.id").getValue());
        Assert.assertTrue((boolean)(this.client instanceof AutoCloseable));
    }

    @Test
    public void testStoreAndLoad() throws InterruptedException {
        String srvStateInXML = (String)((ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName(TEST_KIE_SERVER_ID)).get()).getData().get("kie-server-state");
        KieServerState kieServerState = (KieServerState)xs.fromXML(srvStateInXML);
        Assert.assertNotNull((Object)kieServerState);
        this.createDummyDC();
        this.repo.store(TEST_KIE_SERVER_ID, kieServerState);
        Assert.assertNotNull((Object)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName(TEST_KIE_SERVER_ID)).get());
        KieServerState kssLoaded = this.repo.load(TEST_KIE_SERVER_ID);
        Assert.assertNotNull((Object)kssLoaded);
        Assert.assertEquals((Object)TEST_KIE_SERVER_ID, (Object)kssLoaded.getConfiguration().getConfigItem("org.kie.server.id").getValue());
        KieContainerResource[] kcr = kssLoaded.getContainers().toArray(new KieContainerResource[0]);
        Assert.assertEquals((long)2L, (long)kcr.length);
        Assert.assertEquals((Object)"mortgages_1.0.0-SNAPSHOT", (Object)kcr[0].getContainerId());
        Assert.assertEquals((Object)"mortgage-process_1.0.0-SNAPSHOT", (Object)kcr[1].getContainerId());
    }

    @Test
    public void testStoreAndLoadWithRolloutTrigger() throws InterruptedException {
        String srvStateInXML = (String)((ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName(TEST_KIE_SERVER_ID)).get()).getData().get("kie-server-state");
        KieServerState kieServerState = (KieServerState)xs.fromXML(srvStateInXML);
        this.repo.store(TEST_KIE_SERVER_ID, kieServerState);
        Assert.assertNotNull((Object)((ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName(TEST_KIE_SERVER_ID)).get()).getMetadata().getAnnotations().containsKey("services.server.kie.org/openshift-startup-strategy.rolloutRequired"));
    }

    @Test(expected=Exception.class)
    public void testLoadWithNullServerId() {
        this.repo.load(null);
    }

    @Test(expected=IllegalStateException.class)
    public void testLoadWithInvalidServerId() {
        this.repo.load("dummy");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStoreWithEmptyKieServerState() {
        this.repo.store("dummy", new KieServerState());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStoreWithMissMatchingServerId() {
        KieServerState kss = this.repo.load(TEST_KIE_SERVER_ID);
        this.repo.store("dummy", kss);
    }

    @Test(expected=IllegalStateException.class)
    public void testStoreWithoutPreSeededConfigMap() {
        KieServerState kss = this.repo.load(TEST_KIE_SERVER_ID);
        ((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName(TEST_KIE_SERVER_ID)).delete();
        this.repo.store(TEST_KIE_SERVER_ID, kss);
    }

    @Test
    public void testAnnotation() {
        String kieServer1 = KIE_SERVER_STARTUP_IN_PROGRESS_KEY_PREFIX + UUID.randomUUID().toString();
        String kieServer2 = KIE_SERVER_STARTUP_IN_PROGRESS_KEY_PREFIX + UUID.randomUUID().toString();
        ConfigMap cm = (ConfigMap)((Resource)this.client.configMaps().withName(TEST_KIE_SERVER_ID)).get();
        ObjectMeta md = cm.getMetadata();
        Map<String, String> ann = md.getAnnotations() == null ? new HashMap() : md.getAnnotations();
        md.setAnnotations(ann);
        ann.put(kieServer1, KIE_SERVER_STARTUP_IN_PROGRESS_VALUE);
        ann.put(kieServer2, KIE_SERVER_STARTUP_IN_PROGRESS_VALUE);
        this.client.configMaps().createOrReplace((Object[])new ConfigMap[]{cm});
        Assert.assertNotNull((Object)((ConfigMap)((Resource)this.client.configMaps().withName(TEST_KIE_SERVER_ID)).get()).getMetadata().getAnnotations());
        Assert.assertTrue((boolean)((ConfigMap)((Resource)this.client.configMaps().withName(TEST_KIE_SERVER_ID)).get()).getMetadata().getAnnotations().containsKey(kieServer1));
        Assert.assertTrue((boolean)((ConfigMap)((Resource)this.client.configMaps().withName(TEST_KIE_SERVER_ID)).get()).getMetadata().getAnnotations().containsKey(kieServer2));
        Assert.assertTrue((boolean)((ConfigMap)((Resource)this.client.configMaps().withName(TEST_KIE_SERVER_ID)).get()).getMetadata().getAnnotations().containsValue(KIE_SERVER_STARTUP_IN_PROGRESS_VALUE));
        ann.remove(kieServer1);
        this.client.configMaps().createOrReplace((Object[])new ConfigMap[]{cm});
        Assert.assertTrue((boolean)((ConfigMap)((Resource)this.client.configMaps().withName(TEST_KIE_SERVER_ID)).get()).getMetadata().getAnnotations().containsValue(KIE_SERVER_STARTUP_IN_PROGRESS_VALUE));
        ann.remove(kieServer2);
        this.client.configMaps().createOrReplace((Object[])new ConfigMap[]{cm});
        Assert.assertFalse((boolean)((ConfigMap)((Resource)this.client.configMaps().withName(TEST_KIE_SERVER_ID)).get()).getMetadata().getAnnotations().containsValue(KIE_SERVER_STARTUP_IN_PROGRESS_VALUE));
    }

    @Test
    public void testNPEWhenNoServiceProviderConfig() {
        ServiceLoader<KieServerStateRepository> serverStateRepos = ServiceLoader.load(KieServerStateRepository.class);
        Assert.assertNotNull(serverStateRepos);
        String repoType = StartupStrategyProvider.get().getStrategy().getRepositoryType();
        for (KieServerStateRepository repo : serverStateRepos) {
            Assert.assertNotNull((Object)repo);
            Assert.assertNotNull((Object)repo.getClass().getSimpleName());
            if (!repo.getClass().getSimpleName().equals(repoType)) continue;
            Assert.fail((String)("Unexpected repo type: " + repoType));
        }
    }

    @Test
    public void testCreateAndLoad() {
        String srvStateInXML = (String)((ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName(TEST_KIE_SERVER_ID)).get()).getData().get("kie-server-state");
        KieServerState kieServerState = (KieServerState)xs.fromXML(srvStateInXML);
        Assert.assertNotNull((Object)kieServerState);
        kieServerState.getConfiguration().getConfigItem("org.kie.server.id").setValue("myapp2-kieserver_NEW");
        this.repo.create(kieServerState);
        Assert.assertNotNull((Object)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName("myapp2-kieserver_NEW")).get());
        Assert.assertNotNull((Object)this.repo.load("myapp2-kieserver_NEW"));
    }

    @Test
    public void testDeleteAndExists() {
        Assert.assertTrue((boolean)this.repo.exists(TEST_KIE_SERVER_ID));
        this.repo.delete(TEST_KIE_SERVER_ID);
        Assert.assertTrue((!this.repo.exists(TEST_KIE_SERVER_ID) ? 1 : 0) != 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testDeleteAttachedKieServerStateIsNotAllowed() {
        Assert.assertTrue((boolean)this.repo.exists(TEST_KIE_SERVER_ID));
        this.createDummyDC();
        this.repo.delete(TEST_KIE_SERVER_ID);
    }

    @Test
    public void testRetrieveAllKieServerIdsAndStates() {
        KieServerState state = this.repo.load(TEST_KIE_SERVER_ID);
        state.getConfiguration().getConfigItem("org.kie.server.id").setValue("myapp2-kieserver_1");
        this.repo.create(state);
        state.getConfiguration().getConfigItem("org.kie.server.id").setValue("myapp2-kieserver_2");
        this.repo.create(state);
        List kIds = this.repo.retrieveAllKieServerIds();
        Assert.assertEquals((long)3L, (long)kIds.size());
        Assert.assertTrue((boolean)kIds.contains(TEST_KIE_SERVER_ID));
        Assert.assertTrue((boolean)kIds.contains("myapp2-kieserver_1"));
        Assert.assertTrue((boolean)kIds.contains("myapp2-kieserver_2"));
        List kStates = this.repo.retrieveAllKieServerStates();
        Assert.assertEquals((long)3L, (long)kStates.size());
        this.repo.delete(TEST_KIE_SERVER_ID);
        this.repo.delete("myapp2-kieserver_1");
        this.repo.delete("myapp2-kieserver_2");
        Assert.assertEquals((long)0L, (long)this.repo.retrieveAllKieServerIds().size());
        Assert.assertEquals((long)0L, (long)this.repo.retrieveAllKieServerStates().size());
    }

    @Test
    public void testRetrieveAllKieServerIdsAndStatesWithContaminatedCF() {
        ConfigMap cfm = (ConfigMap)((Resource)this.client.configMaps().load(KieServerStateOpenShiftRepositoryTest.class.getResourceAsStream("/test-kieserver-state-config-map-without-label.yml"))).get();
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{cfm});
        Assert.assertEquals((long)2L, (long)((ConfigMapList)this.client.configMaps().list()).getItems().size());
        List kIds = this.repo.retrieveAllKieServerIds();
        Assert.assertEquals((long)1L, (long)kIds.size());
        List kStates = this.repo.retrieveAllKieServerStates();
        Assert.assertEquals((long)1L, (long)kStates.size());
    }

    @After
    public void tearDown() {
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).delete();
        this.client.close();
    }

    protected void createDummyDC() {
        ((DoneableDeploymentConfig)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DoneableDeploymentConfig)((DeploymentConfigFluent.MetadataNested)((DoneableDeploymentConfig)((NonNamespaceOperation)this.client.deploymentConfigs().inNamespace(this.testNamespace)).createOrReplaceWithNew()).withNewMetadata().withName(TEST_KIE_SERVER_ID)).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(0))).addNewTrigger().withType("ConfigChange")).endTrigger()).withNewTemplate().withNewMetadata().addToLabels("app", "kieserver")).endMetadata()).withNewSpec().addNewContainer().withName("kieserver")).withImage("kiserver")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).endTemplate()).endSpec()).done();
    }
}

