/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.openshift.impl.storage.cloud;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.services.impl.KieServerLocator;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepositoryUtils;
import org.kie.server.services.openshift.impl.storage.cloud.KieServerStateCloudRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerStateOpenShiftRepository
extends KieServerStateCloudRepository {
    private static final Logger logger = LoggerFactory.getLogger(KieServerStateOpenShiftRepository.class);

    public synchronized void create(@NotNull KieServerState kieServerState) {
        String serverId = this.retrieveKieServerId(kieServerState);
        this.processKieServerStateByOpenShift(client -> {
            ConfigMap cm = (ConfigMap)((Resource)client.configMaps().withName(serverId)).get();
            if (cm != null) {
                logger.info("Create new ConfigMap action ignored. ConfigMap for KieServer [{}] exists.", (Object)serverId);
                return null;
            }
            this.createNewKieServerStateCM(kieServerState, serverId, (OpenShiftClient)client);
            return null;
        });
    }

    public List<String> retrieveAllKieServerIds() {
        return this.processKieServerStateByOpenShift(client -> ((ConfigMapList)((FilterWatchListDeletable)client.configMaps().withLabel("services.server.kie.org/kie-server-state", "USED")).list()).getItems().stream().map(cfg -> cfg.getMetadata().getName()).collect(Collectors.toList()));
    }

    public List<KieServerState> retrieveAllKieServerStates() {
        return this.processKieServerStateByOpenShift(client -> ((ConfigMapList)((FilterWatchListDeletable)client.configMaps().withLabel("services.server.kie.org/kie-server-state", "USED")).list()).getItems().stream().map(cfg -> (KieServerState)this.xs.fromXML((String)cfg.getData().get("kie-server-state"))).collect(Collectors.toList()));
    }

    public boolean exists(String id) {
        return this.processKieServerStateByOpenShift(client -> ((Resource)client.configMaps().withName(id)).get() != null);
    }

    public KieServerState delete(String id) {
        KieServerState state = this.load(id);
        boolean isUnsupported = this.processKieServerStateByOpenShift(client -> {
            if (((DeployableScalableResource)client.deploymentConfigs().withName(id)).get() != null) {
                return true;
            }
            ((Resource)client.configMaps().withName(id)).delete();
            return false;
        });
        if (isUnsupported) {
            logger.error("Can not delete attached KieServerState with id [{}].", (Object)id);
            throw new UnsupportedOperationException("Can not delete attached KieServerState with id [" + id + "]");
        }
        return state;
    }

    public synchronized void store(@NotNull String serverId, @NotNull KieServerState kieServerState) {
        if (!this.retrieveKieServerId(kieServerState).equals(serverId)) {
            throw new IllegalArgumentException("Invalid KieServerId: Id does not match with KieServerState.");
        }
        this.processKieServerStateByOpenShift(client -> {
            DeploymentConfig dc = (DeploymentConfig)((DeployableScalableResource)client.deploymentConfigs().withName(serverId)).get();
            ConfigMap cm = (ConfigMap)((Resource)client.configMaps().withName(serverId)).get();
            String stateXML = this.xs.toXML((Object)kieServerState);
            if (cm == null) {
                throw new IllegalStateException("KieServerState ConfigMap must exist before update.");
            }
            cm.setData(Collections.singletonMap("kie-server-state", stateXML));
            ObjectMeta md = cm.getMetadata();
            Map<String, String> ann = md.getAnnotations() == null ? new ConcurrentHashMap() : md.getAnnotations();
            md.setAnnotations(ann);
            ann.put("services.server.kie.org/kie-server-state.changeTimestamp", ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT));
            if (this.isKieServerReady()) {
                if (this.isKieServerRuntime() && !this.isDCStable(dc)) {
                    logger.warn("Updating KieServerState is not supported if there are in-progress DeploymentConfig activities.");
                } else {
                    ann.put("services.server.kie.org/openshift-startup-strategy.rolloutRequired", "true");
                    client.configMaps().createOrReplace((Object[])new ConfigMap[]{cm});
                }
            }
            return null;
        });
    }

    public KieServerState load(@NotNull String serverId) {
        KieServerState kieServerState = this.processKieServerStateByOpenShift(client -> {
            ConfigMap cm = (ConfigMap)((Resource)client.configMaps().withName(serverId)).get();
            if (cm == null) {
                if (this.isKieServerRuntime()) {
                    KieServerState initkieServerState = new KieServerState();
                    KieServerConfig config = new KieServerConfig();
                    KieServerStateRepositoryUtils.populateWithSystemProperties((KieServerConfig)config);
                    initkieServerState.setConfiguration(config);
                    if (config.getConfigItemValue("org.kie.server.id") == null || !config.getConfigItemValue("org.kie.server.id").equals(serverId)) {
                        throw new IllegalStateException("KieServerId: [" + serverId + "], must NOT be null and be set by system property or environment varible.");
                    }
                    cm = this.createNewKieServerStateCM(initkieServerState, serverId, (OpenShiftClient)client);
                } else {
                    return null;
                }
            }
            return (KieServerState)this.xs.fromXML((String)cm.getData().get("kie-server-state"));
        });
        if (kieServerState == null) {
            if (this.isKieServerRuntime()) {
                throw new IllegalStateException("Invalid KieServerId: [" + serverId + "], load kie server state failed.");
            }
            return null;
        }
        if (!this.retrieveKieServerId(kieServerState).equals(serverId)) {
            throw new IllegalStateException("Inconsistent kie server state data, requested KieServerId: [" + serverId + "], whereas loaded KieServerId: [" + this.retrieveKieServerId(kieServerState) + "],from kie server state.");
        }
        return kieServerState;
    }

    @Override
    public boolean isKieServerReady() {
        if (this.isKieServerRuntime()) {
            return KieServerLocator.getInstance().isKieServerReady();
        }
        return true;
    }

    private boolean isKieServerRuntime() {
        return System.getProperty("org.kie.server.id") != null;
    }

    protected ConfigMap createNewKieServerStateCM(KieServerState kieServerState, String serverId, OpenShiftClient client) {
        String stateXML = this.xs.toXML((Object)kieServerState);
        return (ConfigMap)client.configMaps().create((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(serverId)).withLabels(Collections.singletonMap("services.server.kie.org/kie-server-state", "USED"))).endMetadata()).withData(Collections.singletonMap("kie-server-state", stateXML))).build()});
    }

    private <R> R processKieServerStateByOpenShift(Function<OpenShiftClient, R> func) {
        R result = null;
        try (OpenShiftClient client = this.createOpenShiftClient();){
            result = func.apply(client);
        }
        catch (UnsupportedOperationException uoe) {
            logger.error("Processing KieServerState failed - Unsupported", (Throwable)uoe);
            throw uoe;
        }
        catch (IllegalStateException ise) {
            logger.error("Processing KieServerState failed - Missing required configuration", (Throwable)ise);
            throw ise;
        }
        catch (Exception e) {
            logger.error("Processing KieServerState failed.", (Throwable)e);
        }
        return result;
    }
}

