/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.openshift.impl.storage.cloud;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.services.impl.StartupStrategyProvider;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.openshift.impl.storage.cloud.KieServerStateOpenShiftRepositoryTest;

public class KieServerStateOpenShiftRepositoryRegularTest
extends KieServerStateOpenShiftRepositoryTest {
    @Test
    public void testLiteralConfigMap() throws InterruptedException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("foo", "bar");
        data.put("cheese", "gouda");
        ConcurrentHashMap<String, String> ant = new ConcurrentHashMap<String, String>();
        ant.put("services.server.kie.org/kie-server-state.changeTimestamp", ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT));
        ConcurrentHashMap<String, String> lab = new ConcurrentHashMap<String, String>();
        lab.put("startup_in_progress", "kieserverId");
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("cfg1")).endMetadata()).addToData(data)).build()});
        try {
            ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).create((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("cfg1")).withLabels(lab)).withAnnotations(ant)).endMetadata()).addToData(data)).build()});
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("cfg2")).withLabels(lab)).withAnnotations(ant)).endMetadata()).addToData(data)).build()});
        ConfigMapList cfgList = (ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withLabel("startup_in_progress", "kieserverid")).list();
        Map keys = ((ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName("cfg1")).get()).getData();
        Assert.assertEquals((Object)"gouda", keys.get("cheese"));
        Assert.assertEquals((Object)"bar", keys.get("foo"));
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).delete(cfgList.getItems());
        Assert.assertTrue((boolean)((ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withLabel("startup_in_progress", "kieserverid")).list()).getItems().isEmpty());
    }

    @Test
    public void testKieServerStateConfigMap() throws InterruptedException {
        Resource configMapResource = (Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName("myapp2-kieserver");
        ConfigMap configMap = (ConfigMap)configMapResource.get();
        Assert.assertEquals((Object)"myapp2-kieserver", (Object)configMap.getMetadata().getName());
        Map data = configMap.getData();
        String srvStateInXML = (String)data.get("kie-server-state");
        KieServerState kieServerState = (KieServerState)xs.fromXML(srvStateInXML);
        Assert.assertNotNull((Object)kieServerState);
        Assert.assertEquals((Object)"myapp2-kieserver", (Object)kieServerState.getConfiguration().getConfigItem("org.kie.server.id").getValue());
    }

    @Test
    public void testStoreAndLoad() throws InterruptedException {
        String srvStateInXML = (String)((ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName("myapp2-kieserver")).get()).getData().get("kie-server-state");
        KieServerState kieServerState = (KieServerState)xs.fromXML(srvStateInXML);
        Assert.assertNotNull((Object)kieServerState);
        this.createDummyDC();
        this.repo.store("myapp2-kieserver", kieServerState);
        Assert.assertNotNull((Object)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName("myapp2-kieserver")).get());
        KieServerState kssLoaded = this.repo.load("myapp2-kieserver");
        Assert.assertNotNull((Object)kssLoaded);
        Assert.assertEquals((Object)"myapp2-kieserver", (Object)kssLoaded.getConfiguration().getConfigItem("org.kie.server.id").getValue());
        KieContainerResource[] kcr = kssLoaded.getContainers().toArray(new KieContainerResource[0]);
        Assert.assertEquals((long)2L, (long)kcr.length);
        Assert.assertEquals((Object)"mortgages_1.0.0-SNAPSHOT", (Object)kcr[0].getContainerId());
        Assert.assertEquals((Object)"mortgage-process_1.0.0-SNAPSHOT", (Object)kcr[1].getContainerId());
    }

    @Test
    public void testStoreAndLoadWithRolloutTrigger() throws InterruptedException {
        String srvStateInXML = (String)((ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName("myapp2-kieserver")).get()).getData().get("kie-server-state");
        KieServerState kieServerState = (KieServerState)xs.fromXML(srvStateInXML);
        this.repo.store("myapp2-kieserver", kieServerState);
        Assert.assertTrue((boolean)((ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName("myapp2-kieserver")).get()).getMetadata().getAnnotations().containsKey("services.server.kie.org/openshift-startup-strategy.rolloutRequired"));
    }

    @Test
    public void testLoadWithNullServerId() {
        Assert.assertNull((Object)this.repo.load(null));
    }

    @Test
    public void testLoadWithInvalidServerId() {
        Assert.assertNull((Object)this.repo.load("dummy"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStoreWithEmptyKieServerState() {
        this.repo.store("dummy", new KieServerState());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStoreWithMissMatchingServerId() {
        KieServerState kss = this.repo.load("myapp2-kieserver");
        this.repo.store("dummy", kss);
    }

    @Test(expected=IllegalStateException.class)
    public void testStoreWithoutPreSeededConfigMap() {
        KieServerState kss = this.repo.load("myapp2-kieserver");
        ((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName("myapp2-kieserver")).delete();
        this.repo.store("myapp2-kieserver", kss);
    }

    @Test
    public void testAnnotation() {
        String kieServer1 = "org.kie.server.services/" + UUID.randomUUID().toString();
        String kieServer2 = "org.kie.server.services/" + UUID.randomUUID().toString();
        ConfigMap cm = (ConfigMap)((Resource)this.client.configMaps().withName("myapp2-kieserver")).get();
        ObjectMeta md = cm.getMetadata();
        Map<String, String> ann = md.getAnnotations() == null ? new HashMap() : md.getAnnotations();
        md.setAnnotations(ann);
        ann.put(kieServer1, "kie.server.startup_in_progress");
        ann.put(kieServer2, "kie.server.startup_in_progress");
        this.client.configMaps().createOrReplace((Object[])new ConfigMap[]{cm});
        Assert.assertNotNull((Object)((ConfigMap)((Resource)this.client.configMaps().withName("myapp2-kieserver")).get()).getMetadata().getAnnotations());
        Assert.assertTrue((boolean)((ConfigMap)((Resource)this.client.configMaps().withName("myapp2-kieserver")).get()).getMetadata().getAnnotations().containsKey(kieServer1));
        Assert.assertTrue((boolean)((ConfigMap)((Resource)this.client.configMaps().withName("myapp2-kieserver")).get()).getMetadata().getAnnotations().containsKey(kieServer2));
        Assert.assertTrue((boolean)((ConfigMap)((Resource)this.client.configMaps().withName("myapp2-kieserver")).get()).getMetadata().getAnnotations().containsValue("kie.server.startup_in_progress"));
        ann.remove(kieServer1);
        this.client.configMaps().createOrReplace((Object[])new ConfigMap[]{cm});
        Assert.assertTrue((boolean)((ConfigMap)((Resource)this.client.configMaps().withName("myapp2-kieserver")).get()).getMetadata().getAnnotations().containsValue("kie.server.startup_in_progress"));
        ann.remove(kieServer2);
        this.client.configMaps().createOrReplace((Object[])new ConfigMap[]{cm});
        Assert.assertFalse((boolean)((ConfigMap)((Resource)this.client.configMaps().withName("myapp2-kieserver")).get()).getMetadata().getAnnotations().containsValue("kie.server.startup_in_progress"));
    }

    @Test
    public void testNPEWhenNoServiceProviderConfig() {
        ServiceLoader<KieServerStateRepository> serverStateRepos = ServiceLoader.load(KieServerStateRepository.class);
        Assert.assertNotNull(serverStateRepos);
        String repoType = StartupStrategyProvider.get().getStrategy().getRepositoryType();
        for (KieServerStateRepository repo : serverStateRepos) {
            Assert.assertNotNull((Object)repo);
            Assert.assertNotNull((Object)repo.getClass().getSimpleName());
            if (!repo.getClass().getSimpleName().equals(repoType)) continue;
            Assert.fail((String)("Unexpected repo type: " + repoType));
        }
    }

    @Test
    public void testCreateAndLoad() {
        String srvStateInXML = (String)((ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName("myapp2-kieserver")).get()).getData().get("kie-server-state");
        KieServerState kieServerState = (KieServerState)xs.fromXML(srvStateInXML);
        Assert.assertNotNull((Object)kieServerState);
        kieServerState.getConfiguration().getConfigItem("org.kie.server.id").setValue("myapp2-kieserver_NEW");
        this.repo.create(kieServerState);
        Assert.assertNotNull((Object)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).withName("myapp2-kieserver_NEW")).get());
        Assert.assertNotNull((Object)this.repo.load("myapp2-kieserver_NEW"));
    }

    @Test
    public void testDeleteAndExists() {
        Assert.assertTrue((boolean)this.repo.exists("myapp2-kieserver"));
        this.repo.delete("myapp2-kieserver");
        Assert.assertTrue((!this.repo.exists("myapp2-kieserver") ? 1 : 0) != 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testDeleteAttachedKieServerStateIsNotAllowed() {
        Assert.assertTrue((boolean)this.repo.exists("myapp2-kieserver"));
        this.createDummyDC();
        this.repo.delete("myapp2-kieserver");
    }

    @Test
    public void testRetrieveAllKieServerIdsAndStates() {
        KieServerState state = this.repo.load("myapp2-kieserver");
        state.getConfiguration().getConfigItem("org.kie.server.id").setValue("myapp2-kieserver_1");
        this.repo.create(state);
        state.getConfiguration().getConfigItem("org.kie.server.id").setValue("myapp2-kieserver_2");
        this.repo.create(state);
        List kIds = this.repo.retrieveAllKieServerIds();
        Assert.assertEquals((long)3L, (long)kIds.size());
        Assert.assertTrue((boolean)kIds.contains("myapp2-kieserver"));
        Assert.assertTrue((boolean)kIds.contains("myapp2-kieserver_1"));
        Assert.assertTrue((boolean)kIds.contains("myapp2-kieserver_2"));
        List kStates = this.repo.retrieveAllKieServerStates();
        Assert.assertEquals((long)3L, (long)kStates.size());
        this.repo.delete("myapp2-kieserver");
        this.repo.delete("myapp2-kieserver_1");
        this.repo.delete("myapp2-kieserver_2");
        Assert.assertEquals((long)0L, (long)this.repo.retrieveAllKieServerIds().size());
        Assert.assertEquals((long)0L, (long)this.repo.retrieveAllKieServerStates().size());
    }

    @Test
    @Ignore(value="Ignored due to unsupport API method, withLabelIn, by Mock OpenShiftServer.")
    public void testRetrieveAllKieServerIdsAndStatesWithContaminatedCF() {
        ConfigMap cfm = (ConfigMap)((Resource)this.client.configMaps().load(KieServerStateOpenShiftRepositoryTest.class.getResourceAsStream("/test-kieserver-state-config-map-without-label.yml"))).get();
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{cfm});
        Assert.assertEquals((long)2L, (long)((ConfigMapList)this.client.configMaps().list()).getItems().size());
        List kIds = this.repo.retrieveAllKieServerIds();
        Assert.assertEquals((long)1L, (long)kIds.size());
        List kStates = this.repo.retrieveAllKieServerStates();
        Assert.assertEquals((long)1L, (long)kStates.size());
    }

    @Test
    public void testKieContainerRemoval() {
        ConfigMap cfmContainer = (ConfigMap)((Resource)this.client.configMaps().load(KieServerStateOpenShiftRepositoryTest.class.getResourceAsStream("/test-kieserver-state-config-map-used-without-container.yml"))).get();
        ConfigMap cfmStopped = (ConfigMap)((Resource)this.client.configMaps().load(KieServerStateOpenShiftRepositoryTest.class.getResourceAsStream("/test-kieserver-state-config-map-used-with-stopped-container.yml"))).get();
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{cfmContainer});
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{cfmStopped});
        KieServerState stateWithoutContainer = (KieServerState)xs.fromXML((String)cfmContainer.getData().get("kie-server-state"));
        KieServerState stateWithStopped = (KieServerState)xs.fromXML((String)cfmStopped.getData().get("kie-server-state"));
        Assert.assertFalse((boolean)this.repo.isKieContainerRemovalAllowed(cfmStopped, stateWithoutContainer));
        Assert.assertTrue((boolean)this.repo.isKieContainerRemovalAllowed(cfmContainer, stateWithStopped));
    }

    @Test
    public void testKieContainerUpdateDuringRolloutAllowed() {
        ConfigMap cfmContainer = (ConfigMap)((Resource)this.client.configMaps().load(KieServerStateOpenShiftRepositoryTest.class.getResourceAsStream("/test-kieserver-state-config-map-used-with-container.yml"))).get();
        ConfigMap cfmStopped = (ConfigMap)((Resource)this.client.configMaps().load(KieServerStateOpenShiftRepositoryTest.class.getResourceAsStream("/test-kieserver-state-config-map-used-with-stopped-container.yml"))).get();
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{cfmContainer});
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{cfmStopped});
        KieServerState state = (KieServerState)xs.fromXML((String)cfmContainer.getData().get("kie-server-state"));
        KieServerState stateWithStopped = (KieServerState)xs.fromXML((String)cfmStopped.getData().get("kie-server-state"));
        Assert.assertTrue((boolean)this.repo.isKieContainerUpdateDuringRolloutAllowed(cfmContainer, stateWithStopped));
        Assert.assertFalse((boolean)this.repo.isKieContainerUpdateDuringRolloutAllowed(cfmStopped, state));
    }
}

