/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.openshift.impl.storage.cloud;

import com.thoughtworks.xstream.XStream;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DoneableDeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.server.mock.OpenShiftServer;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.kie.server.services.openshift.impl.storage.cloud.CloudClientFactory;
import org.kie.server.services.openshift.impl.storage.cloud.KieServerStateCloudRepository;
import org.kie.server.services.openshift.impl.storage.cloud.KieServerStateOpenShiftRepository;

public class KieServerStateOpenShiftRepositoryTest {
    protected static final String KIE_SERVER_STARTUP_IN_PROGRESS_KEY_PREFIX = "org.kie.server.services/";
    protected static final String KIE_SERVER_STARTUP_IN_PROGRESS_VALUE = "kie.server.startup_in_progress";
    protected static final String TEST_KIE_SERVER_ID = "myapp2-kieserver";
    protected static final String TEST_APP_NAME = "myapp2";
    protected static XStream xs = KieServerStateCloudRepository.initializeXStream();
    protected static Supplier<OpenShiftClient> clouldClientHelper = () -> new CloudClientFactory(){}.createOpenShiftClient();
    protected String testNamespace = "myproject";
    protected OpenShiftClient client;
    protected KieServerStateOpenShiftRepository repo;
    @Rule
    public OpenShiftServer server = new OpenShiftServer(false, true);

    @Before
    public void setup() {
        if (System.getenv("KIE_SERVER_ID") != null) {
            System.setProperty("org.kie.server.startup.strategy", "OpenShiftStartupStrategy");
            this.client = clouldClientHelper.get();
        } else {
            this.client = this.server.getOpenshiftClient();
            this.testNamespace = "test";
        }
        ConfigMap cfm = (ConfigMap)((Resource)this.client.configMaps().load(KieServerStateOpenShiftRepositoryTest.class.getResourceAsStream("/test-kieserver-state-config-map-used.yml"))).get();
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{cfm});
        this.repo = new KieServerStateOpenShiftRepository(){

            public OpenShiftClient createOpenShiftClient() {
                return KieServerStateOpenShiftRepositoryTest.this.client;
            }

            public KubernetesClient createKubernetesClient() {
                return KieServerStateOpenShiftRepositoryTest.this.client;
            }

            public boolean isKieServerReady() {
                return true;
            }

            public boolean isDCStable(DeploymentConfig dc) {
                return true;
            }

            public Optional<String> getAppNameFromPod(OpenShiftClient client) {
                return Optional.of(KieServerStateOpenShiftRepositoryTest.TEST_APP_NAME);
            }
        };
        this.repo.load(TEST_KIE_SERVER_ID);
    }

    @After
    public void tearDown() {
        System.clearProperty("org.kie.server.id");
        System.clearProperty("org.kie.server.controller.openshift.global.discovery.enabled");
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).delete();
        ((NonNamespaceOperation)this.client.deploymentConfigs().inNamespace(this.testNamespace)).delete();
        this.client.close();
    }

    protected void createDummyDC() {
        this.createDummyDC(TEST_KIE_SERVER_ID, UUID.randomUUID().toString());
    }

    protected void createDummyDC(String kieServerID, String kieServerDCUID) {
        ((DoneableDeploymentConfig)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DoneableDeploymentConfig)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)((DoneableDeploymentConfig)((NonNamespaceOperation)this.client.deploymentConfigs().inNamespace(this.testNamespace)).createOrReplaceWithNew()).withNewMetadata().withName(kieServerID)).withLabels(Collections.singletonMap("application", TEST_APP_NAME))).withUid(kieServerDCUID)).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(0))).addNewTrigger().withType("ConfigChange")).endTrigger()).addToSelector("app", "kieserver")).withNewTemplate().withNewMetadata().addToLabels("app", "kieserver")).endMetadata()).withNewSpec().addNewContainer().withName("kieserver")).withImage("kieserver")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).endTemplate()).endSpec()).done();
    }
}

