/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.openshift.api;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DeploymentCondition;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.util.Optional;
import org.kie.server.services.impl.KieServerLocator;

public interface KieServerOpenShift {
    default public boolean isKieServerReady() {
        return KieServerLocator.getInstance().isKieServerReady();
    }

    default public boolean isDCStable(DeploymentConfig dc) {
        return "True".equals(((DeploymentCondition)dc.getStatus().getConditions().get(0)).getStatus()) && dc.getStatus().getUnavailableReplicas() == 0;
    }

    default public Optional<DeploymentConfig> getKieServerDC(OpenShiftClient client, String serverId) {
        return Optional.ofNullable(((DeployableScalableResource)client.deploymentConfigs().withName(serverId)).get());
    }

    default public Optional<ConfigMap> getKieServerCM(OpenShiftClient client, String serverId) {
        return Optional.ofNullable(((Resource)client.configMaps().withName(serverId)).get());
    }
}

