/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.optaplanner;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.InternalKieContainer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.instance.SolverInstance;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.optaplanner.SolverServiceBase;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.domain.ScanAnnotatedClassesConfig;

@RunWith(value=MockitoJUnitRunner.class)
public class SolverServiceBaseTest {
    private static final String CONTAINER_ID = "CONTAINER_ID";
    private static final String SOLVER_ID = "SOLVER_ID";
    private static final String SOLVER_CONFIG = "org/kie/server/services/optaplanner/SolverConfig.xml";
    private static final String SOLVER_CONFIG_WRONG = "org/kie/server/services/optaplanner/SolverConfigWrong.xml";
    private static final String SOLVER_CONFIG_GLOBAL_SCAN_SET = "org/kie/server/services/optaplanner/SolverConfigGlobalScanSet.xml";
    private static final String SOLVER_CONFIG_FILTERED_SCAN_SET = "org/kie/server/services/optaplanner/SolverConfigFilteredScanSet.xml";
    private static final String PRE_CONFIGURED_PACKAGE_INCLUDE = "pre.configured.package.include";
    private static final String PRE_CONFIGURED_PACKAGE_EXCLUDE = "pre.configured.package.exclude";
    private static final String CREATE_SOLVER_FOR_CONTAINER_ERROR = "Failed to create solver for container %s";
    private static final String CREATE_SOLVER_CONTAINER_NOT_EXISTS_ERROR = "Failed to create solver. Container does not exist: %s";
    private static final String CREATING_SOLVER_FACTORY_ERROR = "Error creating solver factory for solver: %s";
    private static final String SOLVER_ALREADY_EXISTS_ERROR = "Failed to create solver. Solver '%s' already exists for container '%s'.";
    private static final String SOLVER_CREATED_SUCCESSFULLY_MESSAGE = "Solver '%s' successfully created in container '%s'";
    @Mock
    private KieServerRegistry context;
    @Mock
    private ExecutorService executorService;
    @Mock
    private SolverInstance solverInstance;
    @Mock
    private KieContainerInstanceImpl containerInstance;
    @Mock
    private InternalKieContainer internalKieContainer;
    @Captor
    private ArgumentCaptor<SolverFactory<Object>> solverFactory;
    @Mock
    private Solver<Object> solver;
    private SolverServiceBase serviceBase;

    @Before
    public void setUp() {
        this.solverInstance = new SolverInstance();
        this.solverInstance.setContainerId(CONTAINER_ID);
        this.solverInstance.setSolverId(SOLVER_ID);
        this.solverInstance.setSolverConfigFile(SOLVER_CONFIG);
        ((KieContainerInstanceImpl)Mockito.doReturn((Object)this.internalKieContainer).when((Object)this.containerInstance)).getKieContainer();
        ((InternalKieContainer)Mockito.doReturn((Object)this.getClass().getClassLoader()).when((Object)this.internalKieContainer)).getClassLoader();
        ((KieServerRegistry)Mockito.doReturn((Object)this.containerInstance).when((Object)this.context)).getContainer(CONTAINER_ID);
        this.serviceBase = (SolverServiceBase)Mockito.spy((Object)new SolverServiceBase(this.context, this.executorService));
    }

    @Test
    public void createSolverWithInstanceNullFailure() {
        ServiceResponse response = this.serviceBase.createSolver(CONTAINER_ID, SOLVER_ID, null);
        this.assertFailure((ServiceResponse<SolverInstance>)response, String.format(CREATE_SOLVER_FOR_CONTAINER_ERROR, CONTAINER_ID));
    }

    @Test
    public void createSolverWithConfigFileNullFailure() {
        this.solverInstance.setSolverConfigFile(null);
        ServiceResponse response = this.serviceBase.createSolver(CONTAINER_ID, SOLVER_ID, this.solverInstance);
        this.assertFailure((ServiceResponse<SolverInstance>)response, String.format(CREATE_SOLVER_FOR_CONTAINER_ERROR, CONTAINER_ID));
    }

    @Test
    public void createSolverWithContainerNotExistsFailure() {
        Mockito.when((Object)this.context.getContainer(CONTAINER_ID)).thenReturn(null);
        ServiceResponse response = this.serviceBase.createSolver(CONTAINER_ID, SOLVER_ID, this.solverInstance);
        this.assertFailure((ServiceResponse<SolverInstance>)response, String.format(CREATE_SOLVER_CONTAINER_NOT_EXISTS_ERROR, CONTAINER_ID));
    }

    @Test
    public void createSolverWithSolverConfigurationFileWrongFailure() {
        this.solverInstance.setSolverConfigFile(SOLVER_CONFIG_WRONG);
        ServiceResponse response = this.serviceBase.createSolver(CONTAINER_ID, SOLVER_ID, this.solverInstance);
        this.assertFailure((ServiceResponse<SolverInstance>)response, String.format(CREATING_SOLVER_FACTORY_ERROR, ""));
    }

    @Test
    public void createSolverWithErrorCreatingSolverFailure() {
        String internalError = "An error was produced";
        ((SolverServiceBase)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(internalError)}).when((Object)this.serviceBase)).newSolver((SolverFactory)Matchers.any(SolverFactory.class));
        ServiceResponse response = this.serviceBase.createSolver(CONTAINER_ID, SOLVER_ID, this.solverInstance);
        this.assertBuildFactoryWasInvoked(null);
        this.assertFailure((ServiceResponse<SolverInstance>)response, String.format(CREATING_SOLVER_FACTORY_ERROR, internalError));
    }

    @Test
    public void createSolverWithSolverAlreadyExistsFailure() {
        ((SolverServiceBase)Mockito.doReturn(this.solver).when((Object)this.serviceBase)).newSolver((SolverFactory)Matchers.any(SolverFactory.class));
        this.serviceBase.createSolver(CONTAINER_ID, SOLVER_ID, this.solverInstance);
        this.assertBuildFactoryWasInvoked(null);
        ServiceResponse response = this.serviceBase.createSolver(CONTAINER_ID, SOLVER_ID, this.solverInstance);
        this.assertFailure((ServiceResponse<SolverInstance>)response, String.format(SOLVER_ALREADY_EXISTS_ERROR, SOLVER_ID, CONTAINER_ID));
    }

    @Test
    public void createSolverWithNoScanSetSuccessful() {
        ((SolverServiceBase)Mockito.doReturn(this.solver).when((Object)this.serviceBase)).newSolver((SolverFactory)Matchers.any(SolverFactory.class));
        ServiceResponse response = this.serviceBase.createSolver(CONTAINER_ID, SOLVER_ID, this.solverInstance);
        this.assertBuildFactoryWasInvoked(null);
        this.assertSuccess((ServiceResponse<SolverInstance>)response, String.format(SOLVER_CREATED_SUCCESSFULLY_MESSAGE, SOLVER_ID, CONTAINER_ID));
    }

    @Test
    public void createSolverWithGlobalScanSetSuccessful() {
        this.solverInstance.setSolverConfigFile(SOLVER_CONFIG_GLOBAL_SCAN_SET);
        ((SolverServiceBase)Mockito.doReturn(this.solver).when((Object)this.serviceBase)).newSolver((SolverFactory)Matchers.any(SolverFactory.class));
        ServiceResponse response = this.serviceBase.createSolver(CONTAINER_ID, SOLVER_ID, this.solverInstance);
        this.assertBuildFactoryWasInvoked(Arrays.asList("TestConfigProvider1.PACKAGE1", "TestConfigProvider1.PACKAGE2", "TestConfigProvider1.PACKAGE3", "TestConfigProvider2.PACKAGE1"));
        this.assertSuccess((ServiceResponse<SolverInstance>)response, String.format(SOLVER_CREATED_SUCCESSFULLY_MESSAGE, SOLVER_ID, CONTAINER_ID));
    }

    @Test
    public void createSolverWithFilteredScanSetSuccessful() {
        this.solverInstance.setSolverConfigFile(SOLVER_CONFIG_FILTERED_SCAN_SET);
        ((SolverServiceBase)Mockito.doReturn(this.solver).when((Object)this.serviceBase)).newSolver((SolverFactory)Matchers.any(SolverFactory.class));
        ServiceResponse response = this.serviceBase.createSolver(CONTAINER_ID, SOLVER_ID, this.solverInstance);
        this.assertBuildFactoryWasInvoked(Collections.singletonList(PRE_CONFIGURED_PACKAGE_INCLUDE), Arrays.asList("TestConfigProvider1.PACKAGE1", "TestConfigProvider1.PACKAGE2", "TestConfigProvider1.PACKAGE3", "TestConfigProvider2.PACKAGE1", PRE_CONFIGURED_PACKAGE_EXCLUDE));
        this.assertSuccess((ServiceResponse<SolverInstance>)response, String.format(SOLVER_CREATED_SUCCESSFULLY_MESSAGE, SOLVER_ID, CONTAINER_ID));
    }

    private void assertFailure(ServiceResponse<SolverInstance> response, String messagePrefix) {
        Assertions.assertThat((Comparable)response.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.FAILURE);
        Assertions.assertThat((String)response.getMsg()).startsWith((CharSequence)messagePrefix);
    }

    private void assertSuccess(ServiceResponse<SolverInstance> response, String messagePrefix) {
        Assertions.assertThat((Comparable)response.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.SUCCESS);
        Assertions.assertThat((String)response.getMsg()).startsWith((CharSequence)messagePrefix);
    }

    private void assertBuildFactoryWasInvoked(List<String> expectedExcludedPackages) {
        this.assertBuildFactoryWasInvoked(null, expectedExcludedPackages);
    }

    private void assertBuildFactoryWasInvoked(List<String> expectedIncludedPackages, List<String> expectedExcludedPackages) {
        ((SolverServiceBase)Mockito.verify((Object)this.serviceBase)).newSolver((SolverFactory)this.solverFactory.capture());
        ScanAnnotatedClassesConfig config = ((SolverFactory)this.solverFactory.getValue()).getSolverConfig().getScanAnnotatedClassesConfig();
        if (expectedExcludedPackages != null) {
            Assertions.assertThat((Object)config).isNotNull();
            Assertions.assertThat((List)config.getPackageExcludeList()).containsExactlyInAnyOrder((Object[])expectedExcludedPackages.toArray(new String[0]));
        } else {
            Assertions.assertThat((Object)config).isNull();
        }
        if (expectedIncludedPackages != null) {
            Assertions.assertThat((Object)config).isNotNull();
            Assertions.assertThat((List)config.getPackageIncludeList()).containsExactlyInAnyOrder((Object[])expectedIncludedPackages.toArray(new String[0]));
        }
    }
}

