/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.scenariosimulation;

import java.util.Optional;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.backend.runner.AbstractScenarioRunner;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerDTO;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationXMLPersistence;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.kie.api.runtime.KieContainer;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.scenariosimulation.ScenarioSimulationFailure;
import org.kie.server.api.model.scenariosimulation.ScenarioSimulationResult;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;

public class ScenarioSimulationService {
    private KieServerRegistry kieServerRegistry;

    public ScenarioSimulationService(KieServerRegistry kieServerRegistry) {
        this.kieServerRegistry = kieServerRegistry;
    }

    public ServiceResponse<ScenarioSimulationResult> executeScenario(KieContainer kieContainer, ScenarioSimulationModel scenarioSimulationModel) {
        JUnitCore jUnitCore = new JUnitCore();
        AbstractScenarioRunner runner = this.newRunner(kieContainer, scenarioSimulationModel);
        Result result = jUnitCore.run((Runner)runner);
        if (result.wasSuccessful()) {
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Test Scenario successfully executed", (Object)this.convertResult(result));
        }
        return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Test Scenario execution failed", (Object)this.convertResult(result));
    }

    public KieServerRegistry getKieServerRegistry() {
        return this.kieServerRegistry;
    }

    public ScenarioSimulationModel parseModel(String rawContent) throws Exception {
        return ScenarioSimulationXMLPersistence.getInstance().unmarshal(rawContent);
    }

    public KieContainer getKieContainerById(String containerId) {
        ContainerLocator locator = ContainerLocatorProvider.get().getLocator();
        return Optional.ofNullable(this.kieServerRegistry).map(elem -> elem.getContainer(containerId, locator)).map(KieContainerInstance::getKieContainer).orElseThrow(() -> new IllegalStateException("Impossible to retrieve kieContainer with id " + containerId));
    }

    protected AbstractScenarioRunner newRunner(KieContainer kieContainer, ScenarioSimulationModel scenarioSimulationModel) {
        ScenarioRunnerDTO scenarioRunnerDTO = new ScenarioRunnerDTO(scenarioSimulationModel, null);
        Settings settings = scenarioSimulationModel.getSettings();
        return AbstractScenarioRunner.getSpecificRunnerProvider((ScenarioSimulationModel.Type)settings.getType()).create(kieContainer, scenarioRunnerDTO);
    }

    protected ScenarioSimulationResult convertResult(Result result) {
        ScenarioSimulationResult scenarioSimulationResult = new ScenarioSimulationResult();
        scenarioSimulationResult.setRunCount(result.getRunCount());
        scenarioSimulationResult.setIgnoreCount(result.getIgnoreCount());
        scenarioSimulationResult.setRunTime(result.getRunTime());
        for (Failure failure : result.getFailures()) {
            scenarioSimulationResult.getFailures().add(this.convertFailure(failure));
        }
        return scenarioSimulationResult;
    }

    protected ScenarioSimulationFailure convertFailure(Failure failure) {
        ScenarioSimulationFailure scenarioSimulationFailure = new ScenarioSimulationFailure();
        scenarioSimulationFailure.setErrorMessage(failure.getMessage());
        scenarioSimulationFailure.setDescription(failure.getDescription().getDisplayName());
        return scenarioSimulationFailure;
    }
}

