/*
 * Decompiled with CFR 0.152.
 */
package com.jboss.soap.service.acmedemo.impl;

import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class HeaderInInterceptor
extends AbstractSoapInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(HeaderInInterceptor.class);

    public HeaderInInterceptor() {
        super("user-protocol");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        Header header = message.getHeader(new QName("http://acme-travel.com", "Coupon"));
        if (header == null) {
            logger.info("No intercepted headers");
            return;
        }
        String headerContent = ((Element)header.getObject()).getTextContent();
        logger.info("headerContent is {}", (Object)headerContent);
        if ("Espa&#241;a".equals(headerContent) || "AT&T".equals(headerContent)) {
            message.getExchange().put((Object)"discount", (Object)true);
            return;
        }
        logger.info("No discount with coupon {}", (Object)headerContent);
    }
}

