/*
 * Decompiled with CFR 0.152.
 */
package com.jboss.soap.service.acmedemo.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveInInterceptor
extends AbstractSoapInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ReceiveInInterceptor.class);
    private String receivedMsg;

    public ReceiveInInterceptor() {
        super("receive");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        try {
            this.receivedMsg = this.getMessage(message, (InputStream)message.getContent(InputStream.class));
        }
        catch (IOException e) {
            logger.error("IOException", (Throwable)e);
        }
        logger.debug("Received message: {}", (Object)this.receivedMsg);
        if (!this.receivedMsg.contains("Coupon")) {
            return;
        }
        if (this.receivedMsg.contains("&lt;")) {
            throw new Fault((Throwable)new Exception("Incorrect unescaped chars"));
        }
    }

    private String getMessage(SoapMessage message, InputStream is) throws IOException {
        try (CachedOutputStream cos = new CachedOutputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)cos);
            message.setContent(InputStream.class, (Object)cos.getInputStream());
            String string = IOUtils.toString((InputStream)cos.getInputStream());
            return string;
        }
    }
}

