/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.kie.drools.wb.base.methods;

import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.guvnor.rest.client.AddRepositoryToOrganizationalUnitRequest;
import org.guvnor.rest.client.CompileProjectRequest;
import org.guvnor.rest.client.CreateOrCloneRepositoryRequest;
import org.guvnor.rest.client.CreateOrganizationalUnitRequest;
import org.guvnor.rest.client.CreateProjectRequest;
import org.guvnor.rest.client.Entity;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.OrganizationalUnit;
import org.guvnor.rest.client.RemoveRepositoryFromOrganizationalUnitRequest;
import org.guvnor.rest.client.RepositoryRequest;
import org.jboss.resteasy.client.ClientRequest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.services.client.api.RestRequestHelper;
import org.kie.smoke.tests.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieDroolsWbRestSmokeIntegrationTestMethods {
    private static Logger logger = LoggerFactory.getLogger(KieDroolsWbRestSmokeIntegrationTestMethods.class);
    private final int maxTries = 10;
    private final MediaType mediaType = MediaType.APPLICATION_JSON_TYPE;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
    private static ObjectMapper mapper = new ObjectMapper();

    protected static void addToRequestBody(ClientRequest restRequest, Object obj) throws Exception {
        String body = KieDroolsWbRestSmokeIntegrationTestMethods.convertObjectToJsonString(obj);
        logger.debug("]] " + body);
        restRequest.body(MediaType.APPLICATION_JSON_TYPE, (Object)body);
    }

    protected static String convertObjectToJsonString(Object object) throws JsonGenerationException, JsonMappingException, IOException {
        return mapper.writeValueAsString(object);
    }

    protected static Object convertJsonStringToObject(String jsonStr, Class<?> type) throws JsonParseException, JsonMappingException, IOException {
        return mapper.readValue(jsonStr, type);
    }

    private RestRequestHelper getRestRequestHelper(URL deploymentUrl) {
        return RestRequestHelper.newInstance((URL)deploymentUrl, (String)"mary", (String)"mary123@", (int)500, (MediaType)MediaType.APPLICATION_JSON_TYPE);
    }

    public void manipulatingRepositories(URL deploymentUrl) throws Exception {
        RestRequestHelper requestHelper = this.getRestRequestHelper(deploymentUrl);
        ClientRequest restRequest = requestHelper.createRequest("repositories");
        Collection repoResponses = (Collection)RestUtil.get((ClientRequest)restRequest, (MediaType)this.mediaType, Collection.class);
        Assert.assertTrue((repoResponses.size() > 0 ? 1 : 0) != 0);
        String ufPlaygroundUrl = null;
        for (Map repoRespMap : repoResponses) {
            if (!"uf-playground".equals(repoRespMap.get("name"))) continue;
            ufPlaygroundUrl = (String)repoRespMap.get("gitURL");
        }
        Assert.assertEquals((String)"UF-Playground Git URL", (Object)"git://uf-playground", ufPlaygroundUrl);
        restRequest = requestHelper.createRequest("repositories");
        RepositoryRequest newRepo = new RepositoryRequest();
        String repoName = UUID.randomUUID().toString();
        newRepo.setName(repoName);
        newRepo.setDescription("repo for testing rest services");
        newRepo.setRequestType("new");
        KieDroolsWbRestSmokeIntegrationTestMethods.addToRequestBody(restRequest, newRepo);
        CreateOrCloneRepositoryRequest createJobRequest = (CreateOrCloneRepositoryRequest)RestUtil.post((ClientRequest)restRequest, (MediaType)this.mediaType, (int)202, CreateOrCloneRepositoryRequest.class);
        logger.debug("]] " + KieDroolsWbRestSmokeIntegrationTestMethods.convertObjectToJsonString(createJobRequest));
        Assert.assertNotNull((String)"create repo job request", (Object)createJobRequest);
        Assert.assertEquals((String)"job request status", (Object)JobStatus.ACCEPTED, (Object)createJobRequest.getStatus());
        String jobId = createJobRequest.getJobId();
        this.waitForJobToComplete(deploymentUrl, jobId, createJobRequest.getStatus(), requestHelper);
        restRequest = requestHelper.createRequest("repositories/" + repoName + "/projects");
        Entity project = new Entity();
        project.setDescription("test project");
        String testProjectName = "test-project";
        project.setName(testProjectName);
        KieDroolsWbRestSmokeIntegrationTestMethods.addToRequestBody(restRequest, project);
        CreateProjectRequest createProjectRequest = (CreateProjectRequest)RestUtil.post((ClientRequest)restRequest, (MediaType)this.mediaType, (int)202, CreateProjectRequest.class);
        logger.debug("]] " + KieDroolsWbRestSmokeIntegrationTestMethods.convertObjectToJsonString(createProjectRequest));
        this.waitForJobToComplete(deploymentUrl, jobId, createProjectRequest.getStatus(), requestHelper);
    }

    @Test
    public void mavenOperations(URL deploymentUrl) throws Exception {
        RestRequestHelper requestHelper = this.getRestRequestHelper(deploymentUrl);
        ClientRequest restRequest = requestHelper.createRequest("repositories");
        Collection repoResponses = (Collection)RestUtil.get((ClientRequest)restRequest, (MediaType)this.mediaType, Collection.class);
        Assert.assertTrue((repoResponses.size() > 0 ? 1 : 0) != 0);
        String repoName = (String)((Map)repoResponses.iterator().next()).get("name");
        restRequest = requestHelper.createRequest("repositories/" + repoName + "/projects");
        Entity project = new Entity();
        project.setDescription("test project");
        String projectName = UUID.randomUUID().toString();
        project.setName(projectName);
        KieDroolsWbRestSmokeIntegrationTestMethods.addToRequestBody(restRequest, project);
        CreateProjectRequest createProjectRequest = (CreateProjectRequest)RestUtil.post((ClientRequest)restRequest, (MediaType)this.mediaType, (int)202, CreateProjectRequest.class);
        logger.debug("]] " + KieDroolsWbRestSmokeIntegrationTestMethods.convertObjectToJsonString(createProjectRequest));
        this.waitForJobToComplete(deploymentUrl, createProjectRequest.getJobId(), createProjectRequest.getStatus(), requestHelper);
        restRequest = requestHelper.createRequest("repositories/" + repoName + "/projects/" + projectName + "/maven/compile");
        CompileProjectRequest compileRequest = (CompileProjectRequest)RestUtil.post((ClientRequest)restRequest, (MediaType)this.mediaType, (int)202, CompileProjectRequest.class);
        logger.debug("]] " + KieDroolsWbRestSmokeIntegrationTestMethods.convertObjectToJsonString(compileRequest));
        this.waitForJobToComplete(deploymentUrl, createProjectRequest.getJobId(), createProjectRequest.getStatus(), requestHelper);
    }

    private void waitForJobToComplete(URL deploymentUrl, String jobId, JobStatus jobStatus, RestRequestHelper requestHelper) throws Exception {
        int wait;
        Assert.assertEquals((String)"Initial status of request should be ACCEPTED", (Object)JobStatus.ACCEPTED, (Object)jobStatus);
        for (wait = 0; jobStatus.equals((Object)JobStatus.ACCEPTED) && wait < 10; ++wait) {
            ClientRequest restRequest = requestHelper.createRequest("jobs/" + jobId);
            JobResult jobResult = (JobResult)RestUtil.get((ClientRequest)restRequest, (MediaType)this.mediaType, JobResult.class);
            logger.debug("]] " + KieDroolsWbRestSmokeIntegrationTestMethods.convertObjectToJsonString(jobResult));
            Assert.assertEquals((Object)jobResult.getJobId(), (Object)jobId);
            jobStatus = jobResult.getStatus();
            Thread.sleep(3000L);
        }
        Assert.assertTrue((String)"Too many tries!", (wait < 10 ? 1 : 0) != 0);
    }

    @Test
    public void manipulatingOUs(URL deploymentUrl) throws Exception {
        RestRequestHelper requestHelper = this.getRestRequestHelper(deploymentUrl);
        ClientRequest restRequest = requestHelper.createRequest("organizationalunits");
        Collection orgUnits = (Collection)RestUtil.get((ClientRequest)restRequest, (MediaType)this.mediaType, Collection.class);
        int origUnitsSize = orgUnits.size();
        restRequest = requestHelper.createRequest("organizationalunits");
        OrganizationalUnit orgUnit = new OrganizationalUnit();
        orgUnit.setDescription("Test OU");
        orgUnit.setName(UUID.randomUUID().toString());
        orgUnit.setOwner(this.getClass().getSimpleName());
        KieDroolsWbRestSmokeIntegrationTestMethods.addToRequestBody(restRequest, orgUnit);
        CreateOrganizationalUnitRequest createOURequest = (CreateOrganizationalUnitRequest)RestUtil.post((ClientRequest)restRequest, (MediaType)this.mediaType, (int)202, CreateOrganizationalUnitRequest.class);
        this.waitForJobToComplete(deploymentUrl, createOURequest.getJobId(), createOURequest.getStatus(), requestHelper);
        restRequest = requestHelper.createRequest("organizationalunits");
        orgUnits = (Collection)RestUtil.get((ClientRequest)restRequest, (MediaType)this.mediaType, Collection.class);
        Assert.assertEquals((String)"Exepcted an OU to be added.", (long)(origUnitsSize + 1), (long)orgUnits.size());
        restRequest = requestHelper.createRequest("repositories");
        RepositoryRequest newRepo = new RepositoryRequest();
        String repoName = UUID.randomUUID().toString();
        newRepo.setName(repoName);
        newRepo.setDescription("repo for testing rest services");
        newRepo.setRequestType("new");
        KieDroolsWbRestSmokeIntegrationTestMethods.addToRequestBody(restRequest, newRepo);
        CreateOrCloneRepositoryRequest createRepoRequest = (CreateOrCloneRepositoryRequest)RestUtil.post((ClientRequest)restRequest, (MediaType)this.mediaType, (int)202, CreateOrCloneRepositoryRequest.class);
        logger.debug("]] " + KieDroolsWbRestSmokeIntegrationTestMethods.convertObjectToJsonString(createRepoRequest));
        Assert.assertNotNull((String)"create repo job request", (Object)createRepoRequest);
        Assert.assertEquals((String)"job request status", (Object)JobStatus.ACCEPTED, (Object)createRepoRequest.getStatus());
        this.waitForJobToComplete(deploymentUrl, createRepoRequest.getJobId(), createRepoRequest.getStatus(), requestHelper);
        restRequest = requestHelper.createRequest("organizationalunits/" + orgUnit.getName() + "/repositories/" + repoName);
        AddRepositoryToOrganizationalUnitRequest addRepoToOuRequest = (AddRepositoryToOrganizationalUnitRequest)RestUtil.post((ClientRequest)restRequest, (MediaType)this.mediaType, (int)202, AddRepositoryToOrganizationalUnitRequest.class);
        logger.debug("]] " + KieDroolsWbRestSmokeIntegrationTestMethods.convertObjectToJsonString(addRepoToOuRequest));
        Assert.assertNotNull((String)"add repo to ou job request", (Object)addRepoToOuRequest);
        Assert.assertEquals((String)"job request status", (Object)JobStatus.ACCEPTED, (Object)addRepoToOuRequest.getStatus());
        this.waitForJobToComplete(deploymentUrl, addRepoToOuRequest.getJobId(), addRepoToOuRequest.getStatus(), requestHelper);
        restRequest = requestHelper.createRequest("organizationalunits/" + orgUnit.getName());
        OrganizationalUnit orgUnitRequest = (OrganizationalUnit)RestUtil.get((ClientRequest)restRequest, (MediaType)this.mediaType, OrganizationalUnit.class);
        logger.debug("]] " + KieDroolsWbRestSmokeIntegrationTestMethods.convertObjectToJsonString(orgUnitRequest));
        Assert.assertNotNull((String)"organizational unit request", (Object)orgUnitRequest);
        Assert.assertTrue((String)"repository has not been added to organizational unit", (boolean)orgUnitRequest.getRepositories().contains(repoName));
        restRequest = requestHelper.createRequest("organizationalunits/" + orgUnit.getName() + "/repositories/" + repoName);
        RemoveRepositoryFromOrganizationalUnitRequest remRepoFromOuRquest = (RemoveRepositoryFromOrganizationalUnitRequest)RestUtil.delete((ClientRequest)restRequest, (MediaType)this.mediaType, (int)202, RemoveRepositoryFromOrganizationalUnitRequest.class);
        logger.debug("]] " + KieDroolsWbRestSmokeIntegrationTestMethods.convertObjectToJsonString(remRepoFromOuRquest));
        Assert.assertNotNull((String)"add repo to ou job request", (Object)remRepoFromOuRquest);
        Assert.assertEquals((String)"job request status", (Object)JobStatus.ACCEPTED, (Object)remRepoFromOuRquest.getStatus());
        this.waitForJobToComplete(deploymentUrl, remRepoFromOuRquest.getJobId(), remRepoFromOuRquest.getStatus(), requestHelper);
        restRequest = requestHelper.createRequest("organizationalunits/" + orgUnit.getName());
        orgUnitRequest = (OrganizationalUnit)RestUtil.get((ClientRequest)restRequest, (MediaType)this.mediaType, OrganizationalUnit.class);
        logger.debug("]] " + KieDroolsWbRestSmokeIntegrationTestMethods.convertObjectToJsonString(orgUnitRequest));
        Assert.assertNotNull((String)"organizational unit request", (Object)orgUnitRequest);
        Assert.assertFalse((String)"repository should have been deleted from organizational unit", (boolean)orgUnitRequest.getRepositories().contains(repoName));
    }

    static {
        mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_CONCRETE_AND_ARRAYS);
    }
}

