/*
 * JBoss, Home of Professional Open Source
 * 
 * Copyright 2012, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.smoke.kie.drools.wb.wildfly;

import static org.kie.smoke.kie.drools.wb.base.util.TestConstants.PROJECT_VERSION;
import static org.kie.smoke.tests.util.DeployUtil.getWebArchive;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.runner.RunWith;
import org.kie.smoke.kie.drools.wb.base.AbstractKieDroolsWbSmokeIntegrationTest;

@RunAsClient
@RunWith(Arquillian.class)
public class WildflyKieWbSmokeIntegrationTest extends AbstractKieDroolsWbSmokeIntegrationTest {

    @Deployment(testable = false, name = "kie-drools-wb-wildfly")
    public static Archive<?> createWar() {
        logger.debug("Retrieving kie-drools-wb wildfly8 war");
        WebArchive war = getWebArchive("org.kie", "kie-drools-wb-distribution-wars", "wildfly8", PROJECT_VERSION);
        return war;
    }
    
}