/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.util.unit;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.conn.HttpHostConnectException;
import org.junit.Assume;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class GetIgnoreRule
implements MethodRule {
    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        Statement result = base;
        if (this.hasConditionalIgnoreAnnotation(method)) {
            String urlString = this.getGetUrl(target, method);
            String message = "Ignored because [GET] " + urlString + " failed.";
            boolean liveServer = false;
            try {
                new URL(urlString);
                liveServer = true;
            }
            catch (MalformedURLException e) {
                liveServer = false;
                message = "Ignored because [" + urlString + "] is not a valid URL.";
            }
            if (liveServer) {
                try {
                    Response response = Request.Get((String)urlString).execute();
                    int code = response.returnResponse().getStatusLine().getStatusCode();
                    if (code > 401) {
                        liveServer = false;
                        message = "Ignored because [GET] " + urlString + " returned " + code;
                    }
                }
                catch (HttpHostConnectException hhce) {
                    liveServer = false;
                    message = "Ignored because server is not available: " + hhce.getMessage();
                }
                catch (Exception e) {
                    liveServer = false;
                    message = "Ignored because [GET] " + urlString + " threw: " + e.getMessage();
                }
            }
            if (!liveServer) {
                result = new IgnoreStatement(message);
            }
        }
        return result;
    }

    private boolean hasConditionalIgnoreAnnotation(FrameworkMethod method) {
        return method.getAnnotation(IgnoreIfGetFails.class) != null;
    }

    private String getGetUrl(Object instance, FrameworkMethod method) {
        IgnoreIfGetFails annotation = (IgnoreIfGetFails)method.getAnnotation(IgnoreIfGetFails.class);
        return annotation.getUrl();
    }

    private static class IgnoreStatement
    extends Statement {
        private final String message;

        IgnoreStatement(String host) {
            this.message = host;
        }

        public void evaluate() {
            Assume.assumeTrue((String)this.message, (boolean)false);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface IgnoreIfGetFails {
        public String getUrl() default "";
    }
}

