/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.selenium.model;

import org.kie.smoke.wb.selenium.model.PageObject;
import org.kie.smoke.wb.selenium.model.persps.HomePerspective;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginPage
extends PageObject {
    @FindBy(name="j_username")
    private WebElement usernameInput;
    @FindBy(name="j_password")
    private WebElement passwordInput;
    @FindBy(className="button")
    private WebElement loginButton;
    public static final String BASE_URL = System.getProperty("deployable.base.uri");

    public LoginPage(WebDriver driver) {
        super(driver);
    }

    public HomePerspective loginAs(String username, String password) {
        this.driver.get(BASE_URL);
        this.submitCredentials(username, password);
        HomePerspective hp = new HomePerspective(this.driver);
        hp.waitForLoaded();
        return hp;
    }

    private void submitCredentials(String username, String password) {
        this.usernameInput.sendKeys(new CharSequence[]{username});
        this.passwordInput.sendKeys(new CharSequence[]{password});
        this.loginButton.submit();
    }

    public boolean isDisplayed() {
        return this.usernameInput.isDisplayed();
    }
}

