/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.util.handler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.http.entity.ContentType;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.junit.Assert;
import org.kie.smoke.wb.util.handler.AbstractResponseHandler;

public class XmlResponseHandler<T, P>
extends AbstractResponseHandler<T, P> {
    private JAXBContext jaxbContext = null;
    private List<Class> extraJaxbClasses = new ArrayList<Class>(0);

    public XmlResponseHandler(int status, Class<T> ... returnTypes) {
        super(ContentType.APPLICATION_XML, status, returnTypes);
    }

    public XmlResponseHandler(Class<T> ... returnTypes) {
        super(ContentType.APPLICATION_XML, returnTypes);
    }

    public void addExtraJaxbClasses(Class ... extraClass) {
        this.extraJaxbClasses.addAll(Arrays.asList(extraClass));
    }

    @Override
    protected T deserialize(String content) {
        if (logger.isTraceEnabled()) {
            try {
                Document doc = DocumentHelper.parseText((String)content);
                StringWriter sw = new StringWriter();
                OutputFormat format = OutputFormat.createPrettyPrint();
                XMLWriter xw = new XMLWriter((Writer)sw, format);
                xw.write(doc);
                String prettyContent = sw.toString();
                logger.trace("XML  < |\n{}", (Object)prettyContent);
            }
            catch (IOException ioe) {
                logger.error("Unabel to write XML document: " + ioe.getMessage(), (Throwable)ioe);
            }
            catch (DocumentException de) {
                logger.error("Unabel to parse text: " + de.getMessage(), (Throwable)de);
            }
        }
        JAXBContext jaxbContext = this.getJaxbContext();
        Unmarshaller unmarshaller = null;
        try {
            unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException jaxbe) {
            throw new IllegalStateException("Unable to create unmarshaller", jaxbe);
        }
        ByteArrayInputStream contentStream = new ByteArrayInputStream(content.getBytes());
        Object jaxbObj = null;
        try {
            jaxbObj = unmarshaller.unmarshal((InputStream)contentStream);
        }
        catch (JAXBException jaxbe) {
            throw new IllegalStateException("Unable to unmarshal reader", jaxbe);
        }
        Class<?> returnedClass = jaxbObj.getClass();
        Assert.assertTrue((String)(returnedClass.getSimpleName() + " received instead of " + this.returnType.getSimpleName()), (boolean)this.returnType.isAssignableFrom(returnedClass));
        return (T)jaxbObj;
    }

    private JAXBContext getJaxbContext() {
        if (this.jaxbContext == null) {
            HashSet<Class> types = new HashSet<Class>(2);
            types.add(this.returnType);
            if (this.parameterType != null) {
                types.add(this.parameterType);
            }
            if (!this.extraJaxbClasses.isEmpty()) {
                types.addAll(this.extraJaxbClasses);
            }
            try {
                this.jaxbContext = JAXBContext.newInstance((Class[])types.toArray(new Class[types.size()]));
            }
            catch (JAXBException jaxbe) {
                throw new IllegalStateException("Unable to create JAXBContext", jaxbe);
            }
        }
        return this.jaxbContext;
    }

    @Override
    public String serialize(Object entity) {
        JAXBContext jaxbContext;
        ArrayList<Class> typeList = new ArrayList<Class>();
        typeList.add(entity.getClass());
        if (!this.extraJaxbClasses.isEmpty()) {
            typeList.addAll(this.extraJaxbClasses);
        }
        try {
            jaxbContext = JAXBContext.newInstance((Class[])typeList.toArray(new Class[typeList.size()]));
        }
        catch (JAXBException jaxbe) {
            throw new IllegalStateException("Unable to create JAXBContext", jaxbe);
        }
        return this.serialize(entity, jaxbContext);
    }

    public String serialize(Object entity, JAXBContext jaxbContext) {
        Marshaller marshaller = null;
        try {
            marshaller = jaxbContext.createMarshaller();
            if (logger.isTraceEnabled()) {
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
            }
        }
        catch (JAXBException jaxbe) {
            throw new IllegalStateException("Unable to create unmarshaller", jaxbe);
        }
        StringWriter xmlStrWriter = new StringWriter();
        try {
            marshaller.marshal(entity, (Writer)xmlStrWriter);
        }
        catch (JAXBException jaxbe) {
            throw new IllegalStateException("Unable to marshal " + entity.getClass().getSimpleName() + " instance", jaxbe);
        }
        String out = xmlStrWriter.toString();
        logger.trace("XML  > |\n{}", (Object)out);
        return out;
    }
}

