/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb;

import java.net.MalformedURLException;
import java.net.URL;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.smoke.wb.util.RestRepositoryDeploymentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorkbenchIntegrationTest {
    private static Logger logger = LoggerFactory.getLogger(AbstractWorkbenchIntegrationTest.class);
    public static URL deploymentUrl;
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            System.out.println("Starting test: " + description.getMethodName());
        }
    };

    protected static void deployJbpmPlayGroundIntegrationTests(URL deploymentUrl, RuntimeStrategy strategy) {
        int sleepSecs = 5;
        RestRepositoryDeploymentUtil deployUtil = new RestRepositoryDeploymentUtil(deploymentUrl, "mary", "mary123@", sleepSecs, strategy);
        deployUtil.setTotalTries(6);
        String repoUrl = "https://github.com/droolsjbpm/jbpm-playground.git";
        String repositoryName = "playground";
        String project = "integration-tests";
        String deploymentId = "org.test:kjar:1.0";
        String orgUnitName = "integTestUser";
        deployUtil.createRepositoryAndDeployProject(repoUrl, repositoryName, project, deploymentId, orgUnitName, "mary");
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        String baseUriPropValue = System.getProperty("deployable.base.uri");
        if (baseUriPropValue == null) {
            logger.info("No deployable base URI specified. Assuming it will be set for each test individually.");
        } else {
            try {
                deploymentUrl = new URL(baseUriPropValue);
                logger.info("deployable.base.uri=" + deploymentUrl.toExternalForm());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Malformed deployment URL '" + baseUriPropValue + "'!", e);
            }
        }
    }
}

