/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.rest;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import org.guvnor.rest.client.AddRepositoryToOrganizationalUnitRequest;
import org.guvnor.rest.client.CompileProjectRequest;
import org.guvnor.rest.client.CreateOrCloneRepositoryRequest;
import org.guvnor.rest.client.CreateOrganizationalUnitRequest;
import org.guvnor.rest.client.CreateProjectRequest;
import org.guvnor.rest.client.DeleteProjectRequest;
import org.guvnor.rest.client.Entity;
import org.guvnor.rest.client.InstallProjectRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.OrganizationalUnit;
import org.guvnor.rest.client.ProjectRequest;
import org.guvnor.rest.client.ProjectResponse;
import org.guvnor.rest.client.RemoveOrganizationalUnitRequest;
import org.guvnor.rest.client.RemoveRepositoryFromOrganizationalUnitRequest;
import org.guvnor.rest.client.RemoveRepositoryRequest;
import org.guvnor.rest.client.RepositoryRequest;
import org.guvnor.rest.client.RepositoryResponse;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.smoke.wb.AbstractWorkbenchIntegrationTest;
import org.kie.smoke.wb.category.KieDroolsWbSmoke;
import org.kie.smoke.wb.category.KieWbSmoke;
import org.kie.smoke.wb.util.RestUtil;

@Category(value={KieWbSmoke.class, KieDroolsWbSmoke.class})
public class GuvnorRestSmokeIntegrationTest
extends AbstractWorkbenchIntegrationTest {
    private final int maxTries = 60;
    private static final String mediaType = "application/json";
    private static final String user = "mary";
    private static final String password = "mary123@";
    private static final SimpleDateFormat ouSdf = new SimpleDateFormat("yy-MM-dd_HH:mm:ss");
    private static final Random random = new Random();

    @Test
    public void testManipulatingRepositoriesAndProjects() throws Exception {
        String orgUnitName = "repo-user-" + ouSdf.format(new Date());
        OrganizationalUnit orgUnit = new OrganizationalUnit();
        orgUnit.setName(orgUnitName);
        orgUnit.setDefaultGroupId("org.kie.smoke");
        orgUnit.setDescription("Test user for the Kie Workbench smoke tests");
        orgUnit.setOwner(this.getClass().getName());
        CreateOrganizationalUnitRequest createOuRequest = (CreateOrganizationalUnitRequest)RestUtil.postEntity((URL)deploymentUrl, (String)"rest/organizationalunits", (String)mediaType, (int)202, (String)user, (String)password, (Object)orgUnit, (Class[])new Class[]{CreateOrganizationalUnitRequest.class});
        Assert.assertNotNull((String)"create org unit request", (Object)createOuRequest);
        Assert.assertEquals((String)"job request status", (Object)JobStatus.APPROVED, (Object)createOuRequest.getStatus());
        String jobId = createOuRequest.getJobId();
        this.waitForJobToComplete(deploymentUrl, jobId, createOuRequest.getStatus());
        String repoName = UUID.randomUUID().toString();
        RepositoryRequest newRepo = new RepositoryRequest();
        newRepo.setName(repoName);
        newRepo.setDescription("repo for rest services smoke tests");
        newRepo.setRequestType("new");
        newRepo.setOrganizationalUnitName(orgUnitName);
        CreateOrCloneRepositoryRequest createJobRequest = (CreateOrCloneRepositoryRequest)RestUtil.postEntity((URL)deploymentUrl, (String)"rest/repositories", (String)mediaType, (int)202, (String)user, (String)password, (double)1.0, (Object)newRepo, (Class[])new Class[]{CreateOrCloneRepositoryRequest.class});
        Assert.assertNotNull((String)"create repo job request", (Object)createJobRequest);
        JobStatus requestStatus = createJobRequest.getStatus();
        Assert.assertTrue((String)("job request status: " + requestStatus), (JobStatus.ACCEPTED.equals((Object)requestStatus) || JobStatus.APPROVED.equals((Object)requestStatus) ? 1 : 0) != 0);
        this.waitForJobToComplete(deploymentUrl, createJobRequest.getJobId(), createJobRequest.getStatus());
        Entity project = new Entity();
        project.setDescription("random project");
        String testProjectName = UUID.randomUUID().toString();
        project.setName(testProjectName);
        CreateProjectRequest createProjectRequest = (CreateProjectRequest)RestUtil.postEntity((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects"), (String)mediaType, (int)202, (String)user, (String)password, (double)0.5, (Object)project, (Class[])new Class[]{CreateProjectRequest.class});
        this.waitForJobToComplete(deploymentUrl, createProjectRequest.getJobId(), createProjectRequest.getStatus());
        String testProjectName2 = UUID.randomUUID().toString();
        ProjectRequest newProject = new ProjectRequest();
        newProject.setDescription("test get/del project");
        newProject.setName(testProjectName2);
        String testProjectGroupid = UUID.randomUUID().toString();
        newProject.setGroupId(testProjectGroupid);
        String testVersion = "1.0";
        newProject.setVersion(testVersion);
        CreateProjectRequest createProjectRequest2 = (CreateProjectRequest)RestUtil.postEntity((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects"), (String)mediaType, (int)202, (String)user, (String)password, (double)0.5, (Object)newProject, (Class[])new Class[]{CreateProjectRequest.class});
        this.waitForJobToComplete(deploymentUrl, createProjectRequest2.getJobId(), createProjectRequest2.getStatus());
        Collection projectResponses = (Collection)RestUtil.get((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects"), (String)mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{Collection.class, ProjectResponse.class});
        Assert.assertNotNull((String)"Null project request list", (Object)projectResponses);
        Assert.assertFalse((String)"Empty project request list", (boolean)projectResponses.isEmpty());
        ProjectRequest foundProjReq = null;
        for (ProjectRequest projReq : projectResponses) {
            if (!testProjectName2.equals(projReq.getName())) continue;
            foundProjReq = projReq;
            break;
        }
        Assert.assertNotNull((String)"Could not find project", foundProjReq);
        Assert.assertEquals((String)"Project group id", (Object)newProject.getGroupId(), (Object)foundProjReq.getGroupId());
        Assert.assertEquals((String)"Project version", (Object)newProject.getVersion(), (Object)foundProjReq.getVersion());
        DeleteProjectRequest delProjectRequest = (DeleteProjectRequest)RestUtil.delete((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects/" + testProjectName2), (String)mediaType, (int)202, (String)user, (String)password, (Class[])new Class[]{DeleteProjectRequest.class});
        String jobId2 = delProjectRequest.getJobId();
        this.waitForJobToComplete(deploymentUrl, jobId2, delProjectRequest.getStatus());
        Collection projectList = (Collection)RestUtil.get((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects"), (String)mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{Collection.class, ProjectResponse.class});
        Assert.assertNotNull((String)"Null project list", (Object)projectList);
        for (ProjectResponse project2 : projectList) {
            Assert.assertNotEquals((String)"Test project should have been deleted", (Object)testProjectName2, (Object)project2.getName());
        }
        RemoveRepositoryFromOrganizationalUnitRequest remRepoFromOuRequest = (RemoveRepositoryFromOrganizationalUnitRequest)RestUtil.delete((URL)deploymentUrl, (String)("rest/organizationalunits/" + orgUnitName + "/repositories/" + repoName), (String)mediaType, (int)202, (String)user, (String)password, (Class[])new Class[]{RemoveRepositoryFromOrganizationalUnitRequest.class});
        jobId2 = remRepoFromOuRequest.getJobId();
        this.waitForJobToComplete(deploymentUrl, jobId2, remRepoFromOuRequest.getStatus());
        Collection repoList = (Collection)RestUtil.get((URL)deploymentUrl, (String)"rest/repositories/", (String)mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{Collection.class, RepositoryResponse.class});
        Assert.assertNotNull((String)"Null repo list", (Object)repoList);
        Assert.assertFalse((String)"Empty repo list", (boolean)repoList.isEmpty());
        boolean repoFound = false;
        for (RepositoryResponse repo : repoList) {
            if (!repoName.equals(repo.getName())) continue;
            repoFound = true;
            Assert.assertTrue((String)("Empty URL for repo '" + repoName + "'"), (repo.getGitURL() != null && !repo.getGitURL().isEmpty() ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)("Could not find repo '" + repoName + "'"), (boolean)repoFound);
        RemoveRepositoryRequest delRepoRequest = (RemoveRepositoryRequest)RestUtil.delete((URL)deploymentUrl, (String)("rest/repositories/" + repoName), (String)mediaType, (int)202, (String)user, (String)password, (Class[])new Class[]{RemoveRepositoryRequest.class});
        jobId = delRepoRequest.getJobId();
        this.waitForJobToComplete(deploymentUrl, jobId, delRepoRequest.getStatus());
        repoList = (Collection)RestUtil.get((URL)deploymentUrl, (String)"rest/repositories/", (String)mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{Collection.class, RepositoryResponse.class});
        Assert.assertNotNull((String)"Null repo list", (Object)repoList);
        Assert.assertFalse((String)"Empty repo list", (boolean)repoList.isEmpty());
        for (RepositoryResponse repo : repoList) {
            Assert.assertNotEquals((String)"Repository should have been deleted", (Object)repoName, (Object)repo.getName());
        }
    }

    @Test
    public void testMavenOperationsCompile() throws Exception {
        Collection repoResponses = (Collection)RestUtil.get((URL)deploymentUrl, (String)"rest/repositories", (String)mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{Collection.class, RepositoryResponse.class});
        Assert.assertTrue((repoResponses.size() > 0 ? 1 : 0) != 0);
        String repoName = ((RepositoryResponse)repoResponses.iterator().next()).getName();
        String projectName = UUID.randomUUID().toString();
        ProjectRequest project = new ProjectRequest();
        project.setDescription("test project");
        String groupId = UUID.randomUUID().toString();
        String version = random.nextInt(1000) + ".0";
        project.setName(projectName);
        project.setGroupId(groupId);
        project.setVersion(version);
        CreateProjectRequest createProjectRequest = (CreateProjectRequest)RestUtil.postEntity((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects"), (String)mediaType, (int)202, (String)user, (String)password, (Object)project, (Class[])new Class[]{CreateProjectRequest.class});
        this.waitForJobToComplete(deploymentUrl, createProjectRequest.getJobId(), createProjectRequest.getStatus());
        CompileProjectRequest compileRequest = (CompileProjectRequest)RestUtil.post((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects/" + projectName + "/maven/compile"), (String)mediaType, (int)202, (String)user, (String)password, (Class[])new Class[]{CompileProjectRequest.class});
        this.waitForJobToComplete(deploymentUrl, compileRequest.getJobId(), compileRequest.getStatus());
    }

    @Test
    public void testMavenOperationsInstall() throws Exception {
        Collection repoResponses = (Collection)RestUtil.get((URL)deploymentUrl, (String)"rest/repositories", (String)mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{Collection.class, RepositoryResponse.class});
        Assert.assertTrue((repoResponses.size() > 0 ? 1 : 0) != 0);
        String repoName = ((RepositoryResponse)repoResponses.iterator().next()).getName();
        String projectName = UUID.randomUUID().toString();
        ProjectRequest project = new ProjectRequest();
        project.setDescription("test project");
        String groupId = UUID.randomUUID().toString();
        String version = random.nextInt(1000) + ".0";
        project.setName(projectName);
        project.setGroupId(groupId);
        project.setVersion(version);
        CreateProjectRequest createProjectRequest = (CreateProjectRequest)RestUtil.postEntity((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects"), (String)mediaType, (int)202, (String)user, (String)password, (Object)project, (Class[])new Class[]{CreateProjectRequest.class});
        this.waitForJobToComplete(deploymentUrl, createProjectRequest.getJobId(), createProjectRequest.getStatus());
        InstallProjectRequest installRequest = (InstallProjectRequest)RestUtil.post((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects/" + projectName + "/maven/install"), (String)mediaType, (int)202, (String)user, (String)password, (Class[])new Class[]{InstallProjectRequest.class});
        this.waitForJobToComplete(deploymentUrl, installRequest.getJobId(), installRequest.getStatus());
    }

    @Test
    public void testMavenOperationsInstallClashingGAV() throws Exception {
        Collection repoResponses = (Collection)RestUtil.get((URL)deploymentUrl, (String)"rest/repositories", (String)mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{Collection.class, RepositoryResponse.class});
        Assert.assertTrue((repoResponses.size() > 0 ? 1 : 0) != 0);
        String repoName = ((RepositoryResponse)repoResponses.iterator().next()).getName();
        String projectName = UUID.randomUUID().toString();
        ProjectRequest project = new ProjectRequest();
        project.setDescription("test project");
        String groupId = UUID.randomUUID().toString();
        String version = random.nextInt(1000) + ".0";
        project.setName(projectName);
        project.setGroupId(groupId);
        project.setVersion(version);
        CreateProjectRequest createProjectRequest = (CreateProjectRequest)RestUtil.postEntity((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects"), (String)mediaType, (int)202, (String)user, (String)password, (Object)project, (Class[])new Class[]{CreateProjectRequest.class});
        this.waitForJobToComplete(deploymentUrl, createProjectRequest.getJobId(), createProjectRequest.getStatus());
        InstallProjectRequest installRequest = (InstallProjectRequest)RestUtil.post((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects/" + projectName + "/maven/install"), (String)mediaType, (int)202, (String)user, (String)password, (Class[])new Class[]{InstallProjectRequest.class});
        this.waitForJobToComplete(deploymentUrl, installRequest.getJobId(), installRequest.getStatus());
        installRequest = (InstallProjectRequest)RestUtil.post((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects/" + projectName + "/maven/install"), (String)mediaType, (int)202, (String)user, (String)password, (Class[])new Class[]{InstallProjectRequest.class});
        this.waitForJobToHaveStatus(deploymentUrl, installRequest.getJobId(), installRequest.getStatus(), JobStatus.DUPLICATE_RESOURCE);
    }

    @Test
    public void testMavenOperationsNewProjectClashingGAV() throws Exception {
        Collection repoResponses = (Collection)RestUtil.get((URL)deploymentUrl, (String)"rest/repositories", (String)mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{Collection.class, RepositoryResponse.class});
        Assert.assertTrue((repoResponses.size() > 0 ? 1 : 0) != 0);
        String repoName = ((RepositoryResponse)repoResponses.iterator().next()).getName();
        String projectName = UUID.randomUUID().toString();
        String groupId = UUID.randomUUID().toString();
        String version = random.nextInt(1000) + ".0";
        ProjectRequest project = new ProjectRequest();
        project.setDescription("test project");
        project.setName(projectName);
        project.setGroupId(groupId);
        project.setVersion(version);
        CreateProjectRequest createProjectRequest = (CreateProjectRequest)RestUtil.postEntity((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects"), (String)mediaType, (int)202, (String)user, (String)password, (Object)project, (Class[])new Class[]{CreateProjectRequest.class});
        this.waitForJobToComplete(deploymentUrl, createProjectRequest.getJobId(), createProjectRequest.getStatus());
        InstallProjectRequest installRequest = (InstallProjectRequest)RestUtil.post((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects/" + projectName + "/maven/install"), (String)mediaType, (int)202, (String)user, (String)password, (Class[])new Class[]{InstallProjectRequest.class});
        this.waitForJobToComplete(deploymentUrl, installRequest.getJobId(), installRequest.getStatus());
        project = new ProjectRequest();
        project.setDescription("test project");
        project.setName(projectName);
        project.setGroupId(groupId);
        project.setVersion(version);
        createProjectRequest = (CreateProjectRequest)RestUtil.postEntity((URL)deploymentUrl, (String)("rest/repositories/" + repoName + "/projects"), (String)mediaType, (int)202, (String)user, (String)password, (Object)project, (Class[])new Class[]{CreateProjectRequest.class});
        this.waitForJobToHaveStatus(deploymentUrl, createProjectRequest.getJobId(), createProjectRequest.getStatus(), JobStatus.DUPLICATE_RESOURCE);
    }

    private JobResult waitForJobToComplete(URL deploymentUrl, String jobId, JobStatus jobStatus) throws Exception {
        return this.waitForJobToHaveStatus(deploymentUrl, jobId, jobStatus, JobStatus.SUCCESS);
    }

    private JobResult waitForJobToHaveStatus(URL deploymentUrl, String jobId, JobStatus jobStatus, JobStatus expectedStatus) throws Exception {
        int wait;
        Assert.assertTrue((String)("Initial status of request should be ACCEPTED or APPROVED: " + jobStatus), (jobStatus.equals((Object)JobStatus.ACCEPTED) || jobStatus.equals((Object)JobStatus.APPROVED) ? 1 : 0) != 0);
        JobResult jobResult = null;
        for (wait = 0; (jobStatus.equals((Object)JobStatus.ACCEPTED) || jobStatus.equals((Object)JobStatus.APPROVED)) && wait < 60; ++wait) {
            jobResult = (JobResult)RestUtil.get((URL)deploymentUrl, (String)("rest/jobs/" + jobId), (String)mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{JobResult.class});
            Assert.assertEquals((Object)jobResult.getJobId(), (Object)jobId);
            jobStatus = jobResult.getStatus();
            if (jobStatus.equals((Object)expectedStatus)) break;
            if (jobStatus.equals((Object)JobStatus.FAIL)) {
                Assert.fail((String)"Request failed.");
            }
            Thread.sleep(3000L);
        }
        Assert.assertTrue((String)"Too many tries!", (wait < 60 ? 1 : 0) != 0);
        return jobResult;
    }

    @Test
    public void testManipulatingOUs() throws Exception {
        ArrayList<OrganizationalUnit> ouList = new ArrayList<OrganizationalUnit>(2);
        Collection orgUnits = (Collection)RestUtil.get((URL)deploymentUrl, (String)"rest/organizationalunits", (String)mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{Collection.class, OrganizationalUnit.class});
        int origUnitsSize = orgUnits.size();
        for (int i = 0; i < 2; ++i) {
            OrganizationalUnit orgUnit = new OrganizationalUnit();
            orgUnit.setDescription("Smoke Tests OU");
            orgUnit.setName(UUID.randomUUID().toString());
            orgUnit.setOwner(this.getClass().getSimpleName());
            CreateOrganizationalUnitRequest createOURequest = (CreateOrganizationalUnitRequest)RestUtil.postEntity((URL)deploymentUrl, (String)"rest/organizationalunits", (String)mediaType, (int)202, (String)user, (String)password, (Object)orgUnit, (Class[])new Class[]{CreateOrganizationalUnitRequest.class});
            this.waitForJobToComplete(deploymentUrl, createOURequest.getJobId(), createOURequest.getStatus());
            ouList.add(orgUnit);
        }
        orgUnits = (Collection)RestUtil.get((URL)deploymentUrl, (String)"rest/organizationalunits", (String)mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{Collection.class, OrganizationalUnit.class});
        Assert.assertEquals((String)"Exepcted an OU to be added.", (long)(origUnitsSize + 2), (long)orgUnits.size());
        String repoName = UUID.randomUUID().toString();
        RepositoryRequest newRepo = new RepositoryRequest();
        newRepo.setName(repoName);
        newRepo.setDescription("repo for testing rest services");
        newRepo.setRequestType("new");
        newRepo.setOrganizationalUnitName(((OrganizationalUnit)ouList.get(0)).getName());
        CreateOrCloneRepositoryRequest createRepoRequest = (CreateOrCloneRepositoryRequest)RestUtil.postEntity((URL)deploymentUrl, (String)"rest/repositories", (String)mediaType, (int)202, (String)user, (String)password, (Object)newRepo, (Class[])new Class[]{CreateOrCloneRepositoryRequest.class});
        Assert.assertNotNull((String)"create repo job request", (Object)createRepoRequest);
        Assert.assertEquals((String)"job request status", (Object)JobStatus.APPROVED, (Object)createRepoRequest.getStatus());
        this.waitForJobToComplete(deploymentUrl, createRepoRequest.getJobId(), createRepoRequest.getStatus());
        AddRepositoryToOrganizationalUnitRequest addRepoToOuRequest = (AddRepositoryToOrganizationalUnitRequest)RestUtil.post((URL)deploymentUrl, (String)("rest/organizationalunits/" + ((OrganizationalUnit)ouList.get(1)).getName() + "/repositories/" + repoName), (String)mediaType, (int)202, (String)user, (String)password, (Class[])new Class[]{AddRepositoryToOrganizationalUnitRequest.class});
        Assert.assertNotNull((String)"add repo to ou job request", (Object)addRepoToOuRequest);
        Assert.assertEquals((String)"job request status", (Object)JobStatus.APPROVED, (Object)addRepoToOuRequest.getStatus());
        this.waitForJobToComplete(deploymentUrl, addRepoToOuRequest.getJobId(), addRepoToOuRequest.getStatus());
        OrganizationalUnit orgUnitRequest = (OrganizationalUnit)RestUtil.get((URL)deploymentUrl, (String)("rest/organizationalunits/" + ((OrganizationalUnit)ouList.get(1)).getName()), (String)mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{OrganizationalUnit.class});
        Assert.assertNotNull((String)"organizational unit request", (Object)orgUnitRequest);
        Assert.assertTrue((String)"repository has not been added to organizational unit", (boolean)orgUnitRequest.getRepositories().contains(repoName));
        RemoveRepositoryFromOrganizationalUnitRequest remRepoFromOuRquest = (RemoveRepositoryFromOrganizationalUnitRequest)RestUtil.delete((URL)deploymentUrl, (String)("rest/organizationalunits/" + ((OrganizationalUnit)ouList.get(1)).getName() + "/repositories/" + repoName), (String)mediaType, (int)202, (String)user, (String)password, (Class[])new Class[]{RemoveRepositoryFromOrganizationalUnitRequest.class});
        Assert.assertNotNull((String)"delete repo from ou job request", (Object)remRepoFromOuRquest);
        Assert.assertEquals((String)"job request status", (Object)JobStatus.APPROVED, (Object)remRepoFromOuRquest.getStatus());
        this.waitForJobToComplete(deploymentUrl, remRepoFromOuRquest.getJobId(), remRepoFromOuRquest.getStatus());
        orgUnitRequest = (OrganizationalUnit)RestUtil.get((URL)deploymentUrl, (String)("rest/organizationalunits/" + ((OrganizationalUnit)ouList.get(1)).getName()), (String)mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{OrganizationalUnit.class});
        Assert.assertNotNull((String)"organizational unit request", (Object)orgUnitRequest);
        Assert.assertFalse((String)"repository should have been deleted from organizational unit", (boolean)orgUnitRequest.getRepositories().contains(repoName));
        RemoveOrganizationalUnitRequest removeOrgUnitRequest = (RemoveOrganizationalUnitRequest)RestUtil.delete((URL)deploymentUrl, (String)("rest/organizationalunits/" + ((OrganizationalUnit)ouList.get(1)).getName()), (String)mediaType, (int)202, (String)user, (String)password, (Class[])new Class[]{RemoveOrganizationalUnitRequest.class});
        Assert.assertNotNull((String)"organizational unit request", (Object)removeOrgUnitRequest);
        this.waitForJobToComplete(deploymentUrl, removeOrgUnitRequest.getJobId(), removeOrgUnitRequest.getStatus());
        RestUtil.get((URL)deploymentUrl, (String)("rest/organizationalunits/" + ((OrganizationalUnit)ouList.get(1)).getName()), (String)mediaType, (int)404, (String)user, (String)password, (Class[])new Class[0]);
    }
}

