/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.selenium.ui;

import java.util.ArrayList;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.smoke.wb.category.KieWbSeleniumSmoke;
import org.kie.smoke.wb.selenium.model.KieSeleniumTest;
import org.kie.smoke.wb.selenium.model.LoginPage;
import org.kie.smoke.wb.selenium.model.Persp;
import org.kie.smoke.wb.selenium.model.PrimaryNavbar;
import org.kie.smoke.wb.selenium.model.persps.AbstractPerspective;

@RunWith(value=Parameterized.class)
@Category(value={KieWbSeleniumSmoke.class})
public class LoadAllPerspectivesIntegrationTest
extends KieSeleniumTest {
    private static PrimaryNavbar navbar;
    private final Persp<?> persp;

    public LoadAllPerspectivesIntegrationTest(Persp<?> persp) {
        this.persp = persp;
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> perspectives() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Persp p : Persp.getAllPerspectives()) {
            if (!IS_KIE_WB && p.isKieWbOnly()) continue;
            params.add(new Object[]{p});
        }
        return params;
    }

    @BeforeClass
    public static void login() {
        LoginPage lp = pof.createLoginPage();
        navbar = lp.loginAs("mary", "mary123@").getNavbar();
    }

    @AfterClass
    public static void logout() {
        navbar.logout();
    }

    @Test
    public void checkPerspectiveLoaded() {
        AbstractPerspective perspective = navbar.navigateTo(this.persp);
        Assert.assertTrue((String)("Perspective " + this.persp.getName() + " should be loaded"), (boolean)perspective.isDisplayed());
    }
}

