/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.selenium.model;

import org.kie.smoke.wb.selenium.model.PageObject;
import org.kie.smoke.wb.selenium.model.Persp;
import org.kie.smoke.wb.selenium.model.persps.AbstractPerspective;
import org.kie.smoke.wb.selenium.model.persps.AdministrationPerspective;
import org.kie.smoke.wb.selenium.model.persps.AppsPerspective;
import org.kie.smoke.wb.selenium.model.persps.ArtifactRepositoryPerspective;
import org.kie.smoke.wb.selenium.model.persps.ContributorsPerspective;
import org.kie.smoke.wb.selenium.model.persps.DataSetsPerspective;
import org.kie.smoke.wb.selenium.model.persps.HomePerspective;
import org.kie.smoke.wb.selenium.model.persps.JobsPerspective;
import org.kie.smoke.wb.selenium.model.persps.PeoplePerspective;
import org.kie.smoke.wb.selenium.model.persps.PluginManagementPerspective;
import org.kie.smoke.wb.selenium.model.persps.ProcessAndTaskDashboardPerspective;
import org.kie.smoke.wb.selenium.model.persps.ProcessDefinitionsPerspective;
import org.kie.smoke.wb.selenium.model.persps.ProcessDeploymentsPerspective;
import org.kie.smoke.wb.selenium.model.persps.ProcessInstancesPerspective;
import org.kie.smoke.wb.selenium.model.persps.ProjectAuthoringPerspective;
import org.kie.smoke.wb.selenium.model.persps.RuleDeploymentsPerspective;
import org.kie.smoke.wb.selenium.model.persps.TasksPerspective;
import org.kie.smoke.wb.selenium.model.persps.TimelinePerspective;
import org.kie.smoke.wb.selenium.util.ByUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.PageFactory;

public class PrimaryNavbar
extends PageObject {
    private static final String NAV_MENU = "//nav//li[contains(@class,'dropdown')][a[contains(text(),'%s')]]";
    @FindBy(css="li[title='Reset all Perspective layouts']+li")
    private WebElement logoutMenu;

    public PrimaryNavbar(WebDriver driver) {
        super(driver);
    }

    public void logout() {
        this.logoutMenu.findElement(By.tagName((String)"a")).click();
        this.selectItem(this.logoutMenu, "Log Out");
    }

    public HomePerspective homePage() {
        return this.navigateTo(Persp.HOME_PAGE);
    }

    public TimelinePerspective timeline() {
        return this.navigateTo(Persp.TIMELINE);
    }

    public PeoplePerspective people() {
        return this.navigateTo(Persp.PEOPLE);
    }

    public ProjectAuthoringPerspective projectAuthoring() {
        return this.navigateTo(Persp.PROJECT_AUTHORING);
    }

    public ContributorsPerspective contributors() {
        return this.navigateTo(Persp.CONTRIBUTORS);
    }

    public ArtifactRepositoryPerspective artifactRepository() {
        return this.navigateTo(Persp.ARTIFACT_REPOSITORY);
    }

    public AdministrationPerspective administration() {
        return this.navigateTo(Persp.ADMINISTRATION);
    }

    public ProcessDeploymentsPerspective processDeployments() {
        return this.navigateTo(Persp.PROCESS_DEPLOYMENTS);
    }

    public RuleDeploymentsPerspective ruleDeployments() {
        return this.navigateTo(Persp.RULE_DEPLOYMENTS);
    }

    public JobsPerspective jobs() {
        return this.navigateTo(Persp.JOBS);
    }

    public ProcessDefinitionsPerspective processDefinitions() {
        return this.navigateTo(Persp.PROCESS_DEFINITIONS);
    }

    public ProcessInstancesPerspective processInstances() {
        return this.navigateTo(Persp.PROCESS_INSTANCES);
    }

    public TasksPerspective tasks() {
        return this.navigateTo(Persp.TASKS);
    }

    public ProcessAndTaskDashboardPerspective processAndTaskDashboard() {
        return this.navigateTo(Persp.PROCESS_AND_TASK_DASHBOARD);
    }

    public PluginManagementPerspective pluginManagement() {
        return this.navigateTo(Persp.PLUGIN_MANAGEMENT);
    }

    public AppsPerspective apps() {
        return this.navigateTo(Persp.APPS);
    }

    public DataSetsPerspective dataSets() {
        return this.navigateTo(Persp.DATA_SETS);
    }

    public <T extends AbstractPerspective> T navigateTo(Persp<T> p) {
        if (p == Persp.TASKS) {
            this.driver.findElement(By.linkText((String)"Tasks")).click();
        } else {
            WebElement menu = this.openMenu(p.getMenu());
            this.selectItem(menu, p.getName());
        }
        AbstractPerspective perspective = (AbstractPerspective)PageFactory.initElements((WebDriver)this.driver, p.getPerspectivePageObjectClass());
        perspective.waitForLoaded();
        return (T)perspective;
    }

    private WebElement openMenu(String menuTitle) {
        WebElement menu = this.driver.findElement(ByUtil.xpath(NAV_MENU, menuTitle));
        menu.findElement(By.tagName((String)"a")).click();
        return menu;
    }

    private void selectItem(WebElement openedMenu, String itemText) {
        WebElement menuItem = openedMenu.findElement(By.linkText((String)itemText));
        menuItem.click();
    }
}

