/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.guvnor.rest.client.CreateOrCloneRepositoryRequest;
import org.guvnor.rest.client.CreateOrganizationalUnitRequest;
import org.guvnor.rest.client.InstallProjectRequest;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.OrganizationalUnit;
import org.guvnor.rest.client.RemoveRepositoryRequest;
import org.guvnor.rest.client.RepositoryRequest;
import org.guvnor.rest.client.RepositoryResponse;
import org.junit.Assert;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.smoke.wb.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRepositoryDeploymentUtil {
    private static final Logger logger = LoggerFactory.getLogger(RestRepositoryDeploymentUtil.class);
    private final URL deploymentUrl;
    private final String user;
    private final String password;
    private int sleepSecs;
    private RuntimeStrategy strategy;
    private int totalTries = 10;
    private final String contentType = "application/json";

    public RestRepositoryDeploymentUtil(URL deploymentUrl, String user, String password, int sleepSecs, RuntimeStrategy strategy) {
        this.sleepSecs = sleepSecs;
        Assert.assertTrue((String)("Sleep/timeout period is too short: " + this.sleepSecs), (this.sleepSecs > 2 ? 1 : 0) != 0);
        this.deploymentUrl = deploymentUrl;
        this.user = user;
        this.password = password;
        this.strategy = strategy;
    }

    public void setTotalTries(int tries) {
        this.totalTries = tries;
    }

    public void createRepositoryAndDeployProject(String repoUrl, String repositoryName, String project, String deploymentId, String orgUnitName, String user) {
        if (this.repositoryExists(repositoryName)) {
            JobRequest delRepoJob = this.deleteRepository(repositoryName);
            this.waitForJobsToFinish(this.sleepSecs, delRepoJob);
        }
        if (!this.organizationalUnitExists(orgUnitName)) {
            JobRequest createOrgUnitJob = this.createOrganizationalUnit(orgUnitName, user, new String[0]);
            this.waitForJobsToFinish(this.sleepSecs, createOrgUnitJob);
        }
        JobRequest createRepoJob = this.createRepository(repositoryName, orgUnitName, repoUrl);
        this.waitForJobsToFinish(this.sleepSecs, createRepoJob);
        this.deploy(deploymentId);
    }

    public void undeploy(String deploymentId) {
        JaxbDeploymentJobResult deployJob = this.removeDeploymentUnit(deploymentId);
        this.waitForDeploymentToFinish(this.sleepSecs, false, deployJob.getDeploymentUnit());
    }

    public void deploy(String deploymentId) {
        JaxbDeploymentJobResult deployJob = this.createDeploymentUnit(deploymentId, this.strategy);
        this.waitForDeploymentToFinish(this.sleepSecs, true, deployJob.getDeploymentUnit());
    }

    private boolean repositoryExists(String repositoryName) {
        Collection repos = (Collection)this.get("repositories/", 200, Collection.class, RepositoryResponse.class);
        for (RepositoryResponse repo : repos) {
            if (!repo.getName().equals(repositoryName)) continue;
            return true;
        }
        return false;
    }

    private JobRequest deleteRepository(String repositoryName) {
        logger.info("Deleting repository '{}'", (Object)repositoryName);
        RemoveRepositoryRequest entity = this.delete("repositories/" + repositoryName, 202, RemoveRepositoryRequest.class);
        if (entity.getStatus().equals((Object)JobStatus.ACCEPTED) || entity.getStatus().equals((Object)JobStatus.SUCCESS) || entity.getStatus().equals((Object)JobStatus.APPROVED)) {
            return entity;
        }
        throw new IllegalStateException("Delete request failed with status " + entity.getStatus());
    }

    private JobRequest createRepository(String repositoryName, String orgUnit, String cloneRepoUrl) {
        logger.info("Cloning repo '{}' from URL '{}'", (Object)repositoryName, (Object)cloneRepoUrl);
        RepositoryRequest repoRequest = new RepositoryRequest();
        repoRequest.setName(repositoryName);
        repoRequest.setRequestType("clone");
        repoRequest.setGitURL(cloneRepoUrl);
        repoRequest.setOrganizationalUnitName(orgUnit);
        return (JobRequest)this.post("repositories", repoRequest, 202, CreateOrCloneRepositoryRequest.class);
    }

    public boolean checkRepositoryExistence(String repositoryName) {
        logger.info("Checking existence of repo '{}'", (Object)repositoryName);
        try {
            this.get("repositories/" + repositoryName, 200, RepositoryResponse.class);
        }
        catch (IllegalStateException ise) {
            if (ise.getMessage().contains("code: 404")) {
                return false;
            }
            throw ise;
        }
        return true;
    }

    private OrganizationalUnit getOrganizaionalUnit(String name) {
        OrganizationalUnit orgUnit = null;
        try {
            orgUnit = (OrganizationalUnit)this.get("organizationalunits/" + name, 200, OrganizationalUnit.class);
        }
        catch (IllegalStateException ise) {
            String errMsg = ise.getMessage();
            Assert.assertTrue((String)errMsg, (boolean)errMsg.contains("code: 404"));
        }
        return orgUnit;
    }

    private boolean organizationalUnitExists(String orgUnitName) {
        Collection orgUnits = (Collection)this.get("organizationalunits/", 200, Collection.class, OrganizationalUnit.class);
        for (OrganizationalUnit orgUnit : orgUnits) {
            if (!orgUnit.getName().equals(orgUnitName)) continue;
            return true;
        }
        return false;
    }

    private JobRequest createOrganizationalUnit(String name, String owner, String ... repositories) {
        logger.info("Creating organizational unit '{}' owned by '{}' containing [{}]", new Object[]{name, owner, repositories});
        OrganizationalUnit ou = new OrganizationalUnit();
        ou.setRepositories(new ArrayList());
        for (int i = 0; repositories != null && i < repositories.length; ++i) {
            ou.getRepositories().add(repositories[i]);
        }
        ou.setName(name);
        ou.setOwner(owner);
        return (JobRequest)this.post("organizationalunits/", ou, 202, CreateOrganizationalUnitRequest.class);
    }

    private JobRequest installProject(String repositoryName, String project) {
        logger.info("Installing project '{}' from repo '{}'", (Object)project, (Object)repositoryName);
        String mavenOpRelUrl = this.createMavenOperationRequest(repositoryName, project, "install");
        return (JobRequest)this.post(mavenOpRelUrl, 202, InstallProjectRequest.class);
    }

    private String createMavenOperationRequest(String repositoryName, String project, String operation) {
        return "repositories/" + repositoryName + "/projects/" + project + "/maven/" + operation;
    }

    private JaxbDeploymentJobResult removeDeploymentUnit(String deploymentId) {
        logger.info("Undeploying '{}'", (Object)deploymentId);
        return this.post("deployment/" + deploymentId + "/undeploy", 202, JaxbDeploymentJobResult.class);
    }

    public JaxbDeploymentUnit getDeploymentUnit(String deploymentId) {
        logger.info("Getting info on '{}'", (Object)deploymentId);
        return (JaxbDeploymentUnit)this.get("deployment/" + deploymentId, 200, JaxbDeploymentUnit.class);
    }

    private JaxbDeploymentJobResult createDeploymentUnit(String deploymentId, RuntimeStrategy strategy) {
        logger.info("Deploying '{}'", (Object)deploymentId);
        String opUrl = "deployment/" + deploymentId + "/deploy";
        if (strategy != null) {
            opUrl = opUrl + "?strategy=" + strategy.toString();
        }
        JaxbDeploymentJobResult deployJobResult = this.post(opUrl, 202, JaxbDeploymentJobResult.class);
        return deployJobResult;
    }

    private <R, S> void waitForJobsToFinish(int sleepSecs, JobRequest ... requests) {
        HashMap<String, JobStatus> requestStatusMap = new HashMap<String, JobStatus>();
        int tryCount = 0;
        ArrayList<JobRequest> checkRequests = new ArrayList<JobRequest>(Arrays.asList(requests));
        while (!checkRequests.isEmpty() && tryCount < this.totalTries) {
            ArrayList<JobRequest> done = new ArrayList<JobRequest>(checkRequests.size());
            for (JobRequest request : requests) {
                JobResult jobResult;
                String jobId = request.getJobId();
                JobStatus jobStatus = (JobStatus)requestStatusMap.get(jobId);
                if (jobStatus == null) {
                    jobResult = (JobResult)this.get("jobs/" + jobId, 200, JobResult.class);
                    jobStatus = jobResult.getStatus();
                }
                if (JobStatus.SUCCESS.equals((Object)jobStatus)) {
                    done.add(request);
                    continue;
                }
                if (JobStatus.FAIL.equals((Object)jobStatus)) {
                    Assert.fail((String)("Job " + jobId + " failed!"));
                }
                jobResult = (JobResult)this.get("jobs/" + jobId, 200, JobResult.class);
                requestStatusMap.put(jobId, jobResult.getStatus());
            }
            checkRequests.removeAll(done);
            if (checkRequests.isEmpty()) break;
            ++tryCount;
            try {
                Thread.sleep(sleepSecs * 1000);
            }
            catch (Exception e) {
                logger.error("Unable to sleep: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void waitForDeploymentToFinish(int sleepSecs, boolean deploy, JaxbDeploymentUnit ... deployUnits) {
        HashMap<String, JaxbDeploymentUnit.JaxbDeploymentStatus> requestStatusMap = new HashMap<String, JaxbDeploymentUnit.JaxbDeploymentStatus>();
        int tryCount = 0;
        ArrayList<JaxbDeploymentUnit> deployRequests = new ArrayList<JaxbDeploymentUnit>(Arrays.asList(deployUnits));
        while (!deployRequests.isEmpty() && tryCount < this.totalTries) {
            ArrayList<JaxbDeploymentUnit> done = new ArrayList<JaxbDeploymentUnit>(deployRequests.size());
            for (JaxbDeploymentUnit deployUnit : deployUnits) {
                JaxbDeploymentUnit requestedDeployUnit;
                String deployId = deployUnit.getIdentifier();
                JaxbDeploymentUnit.JaxbDeploymentStatus jobStatus = (JaxbDeploymentUnit.JaxbDeploymentStatus)requestStatusMap.get(deployId);
                if (jobStatus == null) {
                    requestedDeployUnit = (JaxbDeploymentUnit)this.get("deployment/" + deployId, 200, JaxbDeploymentUnit.class);
                    jobStatus = requestedDeployUnit.getStatus();
                }
                if (deploy) {
                    if (JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED.equals((Object)jobStatus)) {
                        done.add(deployUnit);
                        continue;
                    }
                    if (JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOY_FAILED.equals((Object)jobStatus)) {
                        Assert.fail((String)("Deploy of " + deployId + " failed!"));
                    }
                } else {
                    if (JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOYED.equals((Object)jobStatus)) {
                        done.add(deployUnit);
                        continue;
                    }
                    if (JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOY_FAILED.equals((Object)jobStatus)) {
                        Assert.fail((String)("Undeploy of " + deployId + " failed!"));
                    }
                }
                requestedDeployUnit = (JaxbDeploymentUnit)this.get("deployment/" + deployId, 200, JaxbDeploymentUnit.class);
                requestStatusMap.put(deployId, requestedDeployUnit.getStatus());
            }
            deployRequests.removeAll(done);
            if (deployRequests.isEmpty()) break;
            ++tryCount;
            try {
                Thread.sleep(sleepSecs * 1000);
            }
            catch (Exception e) {
                logger.error("Unable to sleep: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private <T> T get(String relativeUrl, int status, Class ... returnTypes) {
        return RestUtil.get(this.deploymentUrl, "rest/" + relativeUrl, "application/json", status, this.user, this.password, returnTypes);
    }

    private <T> T post(String relativeUrl, int status, Class<T> returnType) {
        return RestUtil.post(this.deploymentUrl, "rest/" + relativeUrl, "application/json", status, this.user, this.password, returnType);
    }

    private <T> T post(String relativeUrl, Object entity, int status, Class<T> returnType) {
        return RestUtil.postEntity(this.deploymentUrl, "rest/" + relativeUrl, "application/json", status, this.user, this.password, entity, returnType);
    }

    private <T> T delete(String relativeUrl, int status, Class<T> returnType) {
        return RestUtil.delete(this.deploymentUrl, "rest/" + relativeUrl, "application/json", status, this.user, this.password, returnType);
    }
}

