/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.jms;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.jms.Queue;
import javax.naming.InitialContext;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.remote.client.api.RemoteJmsRuntimeEngineBuilder;
import org.kie.remote.client.api.RemoteJmsRuntimeEngineFactory;
import org.kie.remote.client.api.RemoteRuntimeEngineFactory;
import org.kie.services.client.api.command.RemoteRuntimeEngine;
import org.kie.smoke.wb.AbstractWorkbenchIntegrationTest;
import org.kie.smoke.wb.category.JMSSmoke;
import org.kie.smoke.wb.category.KieWbSmoke;
import org.kie.smoke.wb.util.TestConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={KieWbSmoke.class, JMSSmoke.class})
public class KieRemoteJmsSmokeIntegrationTest
extends AbstractWorkbenchIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger(KieRemoteJmsSmokeIntegrationTest.class);
    private static final String KSESSION_QUEUE_NAME = "jms/queue/KIE.SESSION";
    private static final String TASK_QUEUE_NAME = "jms/queue/KIE.TASK";
    private static final String RESPONSE_QUEUE_NAME = "jms/queue/KIE.RESPONSE";
    private final String deploymentId = TestConstants.KJAR_DEPLOYMENT_ID;
    private final InitialContext remoteInitialContext = RemoteRuntimeEngineFactory.getRemoteJbossInitialContext((String)"localhost", (String)"mary", (String)"mary123@");

    public void remoteApiInitiatorIdentityTest(String user, String password) {
        RemoteJmsRuntimeEngineFactory remoteSessionFactory = (RemoteJmsRuntimeEngineFactory)((RemoteJmsRuntimeEngineBuilder)((RemoteJmsRuntimeEngineBuilder)((RemoteJmsRuntimeEngineBuilder)RemoteJmsRuntimeEngineFactory.newBuilder().addDeploymentId(this.deploymentId)).addRemoteInitialContext(this.remoteInitialContext).addUserName(user)).addPassword(password)).buildFactory();
        RemoteRuntimeEngine runtimeEngine = remoteSessionFactory.newRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        ProcessInstance procInst = ksession.startProcess("org.test.kjar.writedocument");
        Assert.assertNotNull((String)"Null process instance!", (Object)procInst);
        long procId = procInst.getId();
        List procLogs = runtimeEngine.getAuditService().findActiveProcessInstances("org.test.kjar.writedocument");
        boolean procLogFound = false;
        for (ProcessInstanceLog log : procLogs) {
            if (log == null || log.getProcessInstanceId() != procId) continue;
            procLogFound = true;
            Assert.assertNotEquals((String)"The identity should not be unknown!", (Object)"unknown", (Object)log.getIdentity());
        }
        Assert.assertTrue((String)"Process instance log could not be found.", (boolean)procLogFound);
    }

    public void remoteApiHumanTaskGroupIdTest(URL deploymentUrl) {
        RemoteJmsRuntimeEngineBuilder jreBuilder = ((RemoteJmsRuntimeEngineBuilder)RemoteJmsRuntimeEngineFactory.newBuilder().addDeploymentId(this.deploymentId)).useSsl(true).addHostName("localhost").addJmsConnectorPort(5446).addKeystoreLocation("ssl/client_keystore.jks").addKeystorePassword("CLIENT_KEYSTORE_PASSWORD").useKeystoreAsTruststore();
        try {
            jreBuilder.addTaskServiceQueue((Queue)this.remoteInitialContext.lookup(TASK_QUEUE_NAME)).addKieSessionQueue((Queue)this.remoteInitialContext.lookup(KSESSION_QUEUE_NAME)).addResponseQueue((Queue)this.remoteInitialContext.lookup(RESPONSE_QUEUE_NAME));
        }
        catch (Exception e) {
            String msg = "Unable to lookup queue instances: " + e.getMessage();
            logger.error(msg, (Throwable)e);
            Assert.fail((String)msg);
        }
        RuntimeEngine krisRuntimeEngine = ((RemoteJmsRuntimeEngineBuilder)((RemoteJmsRuntimeEngineBuilder)jreBuilder.addUserName("krisv")).addPassword("krisv123@")).build();
        RuntimeEngine maryRuntimeEngine = ((RemoteJmsRuntimeEngineBuilder)((RemoteJmsRuntimeEngineBuilder)jreBuilder.addUserName("mary")).addPassword("mary123@")).build();
        RuntimeEngine johnRuntimeEngine = ((RemoteJmsRuntimeEngineBuilder)((RemoteJmsRuntimeEngineBuilder)jreBuilder.addUserName("john")).addPassword("john123@")).build();
        this.runHumanTaskGroupIdTest(krisRuntimeEngine, johnRuntimeEngine, maryRuntimeEngine);
    }

    public void runHumanTaskGroupIdTest(RuntimeEngine krisRuntimeEngine, RuntimeEngine johnRuntimeEngine, RuntimeEngine maryRuntimeEngine) {
        KieSession ksession = krisRuntimeEngine.getKieSession();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "krisv");
        params.put("reason", "Yearly performance evaluation");
        ProcessInstance processInstance = ksession.startProcess("org.test.kjar.evaluation", params);
        Assert.assertNotNull((String)"Null process instance!", (Object)processInstance);
        long procInstId = processInstance.getId();
        String user = "krisv";
        TaskService taskService = krisRuntimeEngine.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner(user, "en-UK");
        TaskSummary task = this.findTaskSummary(procInstId, tasks);
        Assert.assertNotNull((String)("Unable to find " + user + "'s task"), (Object)task);
        taskService.start(task.getId().longValue(), user);
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("performance", "exceeding");
        taskService.complete(task.getId().longValue(), user, results);
        user = "john";
        taskService = johnRuntimeEngine.getTaskService();
        tasks = taskService.getTasksAssignedAsPotentialOwner(user, "en-UK");
        task = this.findTaskSummary(procInstId, tasks);
        Assert.assertNotNull((String)("Unable to find " + user + "'s task"), (Object)task);
        taskService.start(task.getId().longValue(), user);
        results = new HashMap();
        results.put("performance", "acceptable");
        taskService.complete(task.getId().longValue(), user, results);
        user = "mary";
        taskService = maryRuntimeEngine.getTaskService();
        tasks = taskService.getTasksAssignedAsPotentialOwner(user, "en-UK");
        task = this.findTaskSummary(procInstId, tasks);
        Assert.assertNotNull((String)("Unable to find " + user + "'s task"), (Object)task);
        taskService.start(task.getId().longValue(), user);
        results = new HashMap();
        results.put("performance", "outstanding");
        taskService.complete(task.getId().longValue(), user, results);
        ProcessInstanceLog procInstLog = maryRuntimeEngine.getAuditService().findProcessInstance(procInstId);
    }

    protected TaskSummary findTaskSummary(Long procInstId, List<TaskSummary> taskSumList) {
        for (TaskSummary task : taskSumList) {
            if (!procInstId.equals(task.getProcessInstanceId())) continue;
            return task;
        }
        Assert.fail((String)("Unable to find task summary for process instance " + procInstId));
        return null;
    }

    @Ignore(value="JMS configuration on container side is not yet implemented")
    @Test
    public void testJmsRemoteApiStartProcessInstanceInitiator() throws Exception {
        this.remoteApiInitiatorIdentityTest("mary", "mary123@");
    }

    @Ignore(value="JMS configuration on container side is not yet implemented")
    @Test
    public void testJmsRemoteApiHumanTaskGroupId() throws Exception {
        this.remoteApiHumanTaskGroupIdTest(deploymentUrl);
    }
}

