/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.rest;

import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.guvnor.rest.client.AddRepositoryToOrganizationalUnitRequest;
import org.guvnor.rest.client.CompileProjectRequest;
import org.guvnor.rest.client.CreateOrCloneRepositoryRequest;
import org.guvnor.rest.client.CreateOrganizationalUnitRequest;
import org.guvnor.rest.client.CreateProjectRequest;
import org.guvnor.rest.client.Entity;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.OrganizationalUnit;
import org.guvnor.rest.client.RemoveRepositoryFromOrganizationalUnitRequest;
import org.guvnor.rest.client.RepositoryRequest;
import org.jboss.resteasy.client.ClientRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.smoke.wb.AbstractWorkbenchIntegrationTest;
import org.kie.smoke.wb.category.KieDroolsWbSmoke;
import org.kie.smoke.wb.category.KieWbSmoke;
import org.kie.smoke.wb.util.RestRequestHelper;
import org.kie.smoke.wb.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={KieWbSmoke.class, KieDroolsWbSmoke.class})
public class WorkbenchRestSmokeIntegrationTest
extends AbstractWorkbenchIntegrationTest {
    private static Logger logger = LoggerFactory.getLogger(WorkbenchRestSmokeIntegrationTest.class);
    private final int maxTries = 10;
    private final MediaType mediaType = MediaType.APPLICATION_JSON_TYPE;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
    private static ObjectMapper mapper = new ObjectMapper();

    protected static void addToRequestBody(ClientRequest restRequest, Object obj) throws Exception {
        String body = WorkbenchRestSmokeIntegrationTest.convertObjectToJsonString(obj);
        logger.debug("]] " + body);
        restRequest.body(MediaType.APPLICATION_JSON_TYPE, (Object)body);
    }

    protected static String convertObjectToJsonString(Object object) throws JsonGenerationException, JsonMappingException, IOException {
        return mapper.writeValueAsString(object);
    }

    protected static Object convertJsonStringToObject(String jsonStr, Class<?> type) throws JsonParseException, JsonMappingException, IOException {
        return mapper.readValue(jsonStr, type);
    }

    private RestRequestHelper getRestRequestHelper(URL deploymentUrl) {
        return RestRequestHelper.newInstance(deploymentUrl, "mary", "mary123@", 500, MediaType.APPLICATION_JSON_TYPE);
    }

    @Test
    public void testManipulatingRepositories() throws Exception {
        RestRequestHelper requestHelper = this.getRestRequestHelper(deploymentUrl);
        ClientRequest restRequest = requestHelper.createRequest("repositories");
        Collection repoResponses = RestUtil.get(restRequest, this.mediaType, Collection.class);
        Assert.assertTrue((repoResponses.size() > 0 ? 1 : 0) != 0);
        String ufPlaygroundUrl = null;
        for (Map repoRespMap : repoResponses) {
            if (!"uf-playground".equals(repoRespMap.get("name"))) continue;
            ufPlaygroundUrl = (String)repoRespMap.get("gitURL");
        }
        Assert.assertEquals((String)"UF-Playground Git URL", (Object)"git://uf-playground", ufPlaygroundUrl);
        restRequest = requestHelper.createRequest("repositories");
        RepositoryRequest newRepo = new RepositoryRequest();
        String repoName = UUID.randomUUID().toString();
        newRepo.setName(repoName);
        newRepo.setDescription("repo for testing rest services");
        newRepo.setRequestType("new");
        WorkbenchRestSmokeIntegrationTest.addToRequestBody(restRequest, newRepo);
        CreateOrCloneRepositoryRequest createJobRequest = RestUtil.post(restRequest, this.mediaType, 202, CreateOrCloneRepositoryRequest.class);
        logger.debug("]] " + WorkbenchRestSmokeIntegrationTest.convertObjectToJsonString(createJobRequest));
        Assert.assertNotNull((String)"create repo job request", (Object)createJobRequest);
        Assert.assertEquals((String)"job request status", (Object)JobStatus.APPROVED, (Object)createJobRequest.getStatus());
        String jobId = createJobRequest.getJobId();
        this.waitForJobToComplete(deploymentUrl, jobId, createJobRequest.getStatus(), requestHelper);
        restRequest = requestHelper.createRequest("repositories/" + repoName + "/projects");
        Entity project = new Entity();
        project.setDescription("test project");
        String testProjectName = "test-project";
        project.setName(testProjectName);
        WorkbenchRestSmokeIntegrationTest.addToRequestBody(restRequest, project);
        CreateProjectRequest createProjectRequest = RestUtil.post(restRequest, this.mediaType, 202, CreateProjectRequest.class);
        logger.debug("]] " + WorkbenchRestSmokeIntegrationTest.convertObjectToJsonString(createProjectRequest));
        this.waitForJobToComplete(deploymentUrl, jobId, createProjectRequest.getStatus(), requestHelper);
    }

    @Test
    public void testMavenOperations() throws Exception {
        RestRequestHelper requestHelper = this.getRestRequestHelper(deploymentUrl);
        ClientRequest restRequest = requestHelper.createRequest("repositories");
        Collection repoResponses = RestUtil.get(restRequest, this.mediaType, Collection.class);
        Assert.assertTrue((repoResponses.size() > 0 ? 1 : 0) != 0);
        String repoName = (String)((Map)repoResponses.iterator().next()).get("name");
        restRequest = requestHelper.createRequest("repositories/" + repoName + "/projects");
        Entity project = new Entity();
        project.setDescription("test project");
        String projectName = UUID.randomUUID().toString();
        project.setName(projectName);
        WorkbenchRestSmokeIntegrationTest.addToRequestBody(restRequest, project);
        CreateProjectRequest createProjectRequest = RestUtil.post(restRequest, this.mediaType, 202, CreateProjectRequest.class);
        logger.debug("]] " + WorkbenchRestSmokeIntegrationTest.convertObjectToJsonString(createProjectRequest));
        this.waitForJobToComplete(deploymentUrl, createProjectRequest.getJobId(), createProjectRequest.getStatus(), requestHelper);
        restRequest = requestHelper.createRequest("repositories/" + repoName + "/projects/" + projectName + "/maven/compile");
        CompileProjectRequest compileRequest = RestUtil.post(restRequest, this.mediaType, 202, CompileProjectRequest.class);
        logger.debug("]] " + WorkbenchRestSmokeIntegrationTest.convertObjectToJsonString(compileRequest));
        this.waitForJobToComplete(deploymentUrl, createProjectRequest.getJobId(), createProjectRequest.getStatus(), requestHelper);
    }

    private void waitForJobToComplete(URL deploymentUrl, String jobId, JobStatus jobStatus, RestRequestHelper requestHelper) throws Exception {
        int wait;
        Assert.assertEquals((String)"Initial status of request should be APPROVED", (Object)JobStatus.APPROVED, (Object)jobStatus);
        for (wait = 0; jobStatus.equals((Object)JobStatus.APPROVED) && wait < 10; ++wait) {
            ClientRequest restRequest = requestHelper.createRequest("jobs/" + jobId);
            JobResult jobResult = RestUtil.get(restRequest, this.mediaType, JobResult.class);
            logger.debug("]] " + WorkbenchRestSmokeIntegrationTest.convertObjectToJsonString(jobResult));
            Assert.assertEquals((Object)jobResult.getJobId(), (Object)jobId);
            jobStatus = jobResult.getStatus();
            Thread.sleep(3000L);
        }
        Assert.assertTrue((String)"Too many tries!", (wait < 10 ? 1 : 0) != 0);
    }

    @Test
    public void testManipulatingOUs() throws Exception {
        RestRequestHelper requestHelper = this.getRestRequestHelper(deploymentUrl);
        ClientRequest restRequest = requestHelper.createRequest("organizationalunits");
        Collection orgUnits = RestUtil.get(restRequest, this.mediaType, Collection.class);
        int origUnitsSize = orgUnits.size();
        restRequest = requestHelper.createRequest("organizationalunits");
        OrganizationalUnit orgUnit = new OrganizationalUnit();
        orgUnit.setDescription("Test OU");
        orgUnit.setName(UUID.randomUUID().toString());
        orgUnit.setOwner(this.getClass().getSimpleName());
        WorkbenchRestSmokeIntegrationTest.addToRequestBody(restRequest, orgUnit);
        CreateOrganizationalUnitRequest createOURequest = RestUtil.post(restRequest, this.mediaType, 202, CreateOrganizationalUnitRequest.class);
        this.waitForJobToComplete(deploymentUrl, createOURequest.getJobId(), createOURequest.getStatus(), requestHelper);
        restRequest = requestHelper.createRequest("organizationalunits");
        orgUnits = RestUtil.get(restRequest, this.mediaType, Collection.class);
        Assert.assertEquals((String)"Exepcted an OU to be added.", (long)(origUnitsSize + 1), (long)orgUnits.size());
        restRequest = requestHelper.createRequest("repositories");
        RepositoryRequest newRepo = new RepositoryRequest();
        String repoName = UUID.randomUUID().toString();
        newRepo.setName(repoName);
        newRepo.setDescription("repo for testing rest services");
        newRepo.setRequestType("new");
        WorkbenchRestSmokeIntegrationTest.addToRequestBody(restRequest, newRepo);
        CreateOrCloneRepositoryRequest createRepoRequest = RestUtil.post(restRequest, this.mediaType, 202, CreateOrCloneRepositoryRequest.class);
        logger.debug("]] " + WorkbenchRestSmokeIntegrationTest.convertObjectToJsonString(createRepoRequest));
        Assert.assertNotNull((String)"create repo job request", (Object)createRepoRequest);
        Assert.assertEquals((String)"job request status", (Object)JobStatus.APPROVED, (Object)createRepoRequest.getStatus());
        this.waitForJobToComplete(deploymentUrl, createRepoRequest.getJobId(), createRepoRequest.getStatus(), requestHelper);
        restRequest = requestHelper.createRequest("organizationalunits/" + orgUnit.getName() + "/repositories/" + repoName);
        AddRepositoryToOrganizationalUnitRequest addRepoToOuRequest = RestUtil.post(restRequest, this.mediaType, 202, AddRepositoryToOrganizationalUnitRequest.class);
        logger.debug("]] " + WorkbenchRestSmokeIntegrationTest.convertObjectToJsonString(addRepoToOuRequest));
        Assert.assertNotNull((String)"add repo to ou job request", (Object)addRepoToOuRequest);
        Assert.assertEquals((String)"job request status", (Object)JobStatus.APPROVED, (Object)addRepoToOuRequest.getStatus());
        this.waitForJobToComplete(deploymentUrl, addRepoToOuRequest.getJobId(), addRepoToOuRequest.getStatus(), requestHelper);
        restRequest = requestHelper.createRequest("organizationalunits/" + orgUnit.getName());
        OrganizationalUnit orgUnitRequest = RestUtil.get(restRequest, this.mediaType, OrganizationalUnit.class);
        logger.debug("]] " + WorkbenchRestSmokeIntegrationTest.convertObjectToJsonString(orgUnitRequest));
        Assert.assertNotNull((String)"organizational unit request", (Object)orgUnitRequest);
        Assert.assertTrue((String)"repository has not been added to organizational unit", (boolean)orgUnitRequest.getRepositories().contains(repoName));
        restRequest = requestHelper.createRequest("organizationalunits/" + orgUnit.getName() + "/repositories/" + repoName);
        RemoveRepositoryFromOrganizationalUnitRequest remRepoFromOuRquest = RestUtil.delete(restRequest, this.mediaType, 202, RemoveRepositoryFromOrganizationalUnitRequest.class);
        logger.debug("]] " + WorkbenchRestSmokeIntegrationTest.convertObjectToJsonString(remRepoFromOuRquest));
        Assert.assertNotNull((String)"add repo to ou job request", (Object)remRepoFromOuRquest);
        Assert.assertEquals((String)"job request status", (Object)JobStatus.APPROVED, (Object)remRepoFromOuRquest.getStatus());
        this.waitForJobToComplete(deploymentUrl, remRepoFromOuRquest.getJobId(), remRepoFromOuRquest.getStatus(), requestHelper);
        restRequest = requestHelper.createRequest("organizationalunits/" + orgUnit.getName());
        orgUnitRequest = RestUtil.get(restRequest, this.mediaType, OrganizationalUnit.class);
        logger.debug("]] " + WorkbenchRestSmokeIntegrationTest.convertObjectToJsonString(orgUnitRequest));
        Assert.assertNotNull((String)"organizational unit request", (Object)orgUnitRequest);
        Assert.assertFalse((String)"repository should have been deleted from organizational unit", (boolean)orgUnitRequest.getRepositories().contains(repoName));
    }

    static {
        mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_CONCRETE_AND_ARRAYS);
    }
}

