/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.guvnor.rest.client.CreateOrCloneRepositoryRequest;
import org.guvnor.rest.client.CreateOrganizationalUnitRequest;
import org.guvnor.rest.client.InstallProjectRequest;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.OrganizationalUnit;
import org.guvnor.rest.client.RemoveRepositoryRequest;
import org.guvnor.rest.client.RepositoryRequest;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.ReaderException;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.smoke.wb.util.RestRequestHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRepositoryDeploymentUtil {
    private static final Logger logger = LoggerFactory.getLogger(RestRepositoryDeploymentUtil.class);
    public final RuntimeStrategy strategy;
    private RestRequestHelper requestHelper;
    private int sleepSecs = 3;
    private int totalTries = 3;
    private static final int GET = 0;
    private static final int POST = 1;
    private static final int DELETE = 2;

    public RestRepositoryDeploymentUtil(URL deploymentUrl, String user, String password, RuntimeStrategy strategy) {
        this.requestHelper = RestRequestHelper.newInstance(deploymentUrl, user, password);
        this.strategy = strategy != null ? strategy : RuntimeStrategy.SINGLETON;
    }

    public void createAndDeployRepository(String repoUrl, String repositoryName, String project, String deploymentId, String orgUnit, String user) {
        try {
            this.deleteRepository(repositoryName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        JobRequest createRepoJob = this.createRepository(repositoryName, repoUrl);
        JobRequest createOrgUnitJob = this.createOrganizationalUnit(orgUnit, user, repositoryName);
        this.waitForJobsToFinish(this.sleepSecs, createRepoJob, createOrgUnitJob);
        JaxbDeploymentJobResult deployJob = this.createDeploymentUnit(deploymentId, this.strategy);
        JaxbDeploymentUnit deployUnit = deployJob.getDeploymentUnit();
        this.waitForDeploymentToFinish(this.sleepSecs, deployUnit);
    }

    public void setSleepSeconds(int sleepSecs) {
        this.sleepSecs = sleepSecs;
    }

    public void setTotalTries(int totalTries) {
        this.totalTries = totalTries;
    }

    private JobRequest deleteRepository(String repositoryName) {
        logger.info("Deleting repository '{}'", (Object)repositoryName);
        RemoveRepositoryRequest entity = this.delete(this.createRequest("repositories/" + repositoryName), RemoveRepositoryRequest.class);
        if (entity.getStatus() == JobStatus.ACCEPTED || entity.getStatus() == JobStatus.SUCCESS) {
            return entity;
        }
        throw new IllegalStateException("Delete request failed with status " + entity.getStatus());
    }

    private JobRequest createRepository(String repositoryName, String cloneRepoUrl) {
        logger.info("Cloning repo '{}' from URL '{}'", (Object)repositoryName, (Object)cloneRepoUrl);
        RepositoryRequest repoRequest = new RepositoryRequest();
        repoRequest.setName(repositoryName);
        repoRequest.setRequestType("clone");
        repoRequest.setGitURL(cloneRepoUrl);
        String input = this.serializeToJsonString(repoRequest);
        ClientRequest request = this.createRequest("repositories/", input);
        return (JobRequest)this.post(request, CreateOrCloneRepositoryRequest.class);
    }

    private JobRequest createOrganizationalUnit(String name, String owner, String ... repositories) {
        logger.info("Creating organizational unit '{}' owned by '{}' containing [{}]", new Object[]{name, owner, repositories});
        OrganizationalUnit ou = new OrganizationalUnit();
        ou.setRepositories(new ArrayList());
        for (int i = 0; repositories != null && i < repositories.length; ++i) {
            ou.getRepositories().add(repositories[i]);
        }
        ou.setName(name);
        ou.setOwner(owner);
        String input = this.serializeToJsonString(ou);
        return (JobRequest)this.post(this.createRequest("organizationalunits/", input), CreateOrganizationalUnitRequest.class);
    }

    private String serializeToJsonString(Object object) {
        String input = null;
        try {
            input = new ObjectMapper().writeValueAsString(object);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to serialize " + object.getClass().getSimpleName(), e);
        }
        return input;
    }

    private JobRequest installProject(String repositoryName, String project) {
        logger.info("Installing project '{}' from repo '{}'", (Object)project, (Object)repositoryName);
        ClientRequest request = this.createMavenOperationRequest(repositoryName, project, "install");
        return (JobRequest)this.post(request, InstallProjectRequest.class);
    }

    private ClientRequest createMavenOperationRequest(String repositoryName, String project, String operation) {
        logger.info("Calling maven '{}' operation on project '{}' in repo '{}'", new Object[]{operation, project, repositoryName});
        return this.createRequest("repositories/" + repositoryName + "/projects/" + project + "/maven/" + operation);
    }

    private JaxbDeploymentJobResult removeDeploymentUnit(String deploymentId) {
        logger.info("Undeploying '{}'", (Object)deploymentId);
        ClientRequest request = this.createRequest("deployment/" + deploymentId + "/undeploy");
        return this.post(request, JaxbDeploymentJobResult.class);
    }

    private JaxbDeploymentJobResult createDeploymentUnit(String deploymentId, RuntimeStrategy strategy) {
        logger.info("Deploying '{}'", (Object)deploymentId);
        String opUrl = "deployment/" + deploymentId + "/deploy";
        if (strategy != null) {
            opUrl = opUrl + "?strategy=" + strategy.toString();
        }
        ClientRequest request = this.createRequest(opUrl);
        JaxbDeploymentJobResult jr = this.post(request, JaxbDeploymentJobResult.class);
        return jr;
    }

    private <R, S> void waitForJobsToFinish(int sleepSecs, JobRequest ... requests) {
        HashMap<String, JobStatus> requestStatusMap = new HashMap<String, JobStatus>();
        int allDone = 0;
        int tryCount = 0;
        while (allDone < requests.length && tryCount < this.totalTries) {
            for (JobRequest request : requests) {
                String jobId = request.getJobId();
                JobStatus jobStatus = (JobStatus)requestStatusMap.get(jobId);
                if (JobStatus.SUCCESS.equals((Object)jobStatus)) {
                    ++allDone;
                    continue;
                }
                ClientRequest restRequest = this.createRequest("jobs/" + jobId);
                JobResult jobResult = this.get(restRequest, JobResult.class);
                requestStatusMap.put(jobId, jobResult.getStatus());
            }
            ++tryCount;
            try {
                Thread.sleep(sleepSecs * 1000);
            }
            catch (Exception e) {
                logger.error("Unable to sleep: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void waitForDeploymentToFinish(int sleepSecs, JaxbDeploymentUnit ... deployUnits) {
        HashMap<String, JaxbDeploymentUnit.JaxbDeploymentStatus> requestStatusMap = new HashMap<String, JaxbDeploymentUnit.JaxbDeploymentStatus>();
        int allDone = 0;
        int tryCount = 0;
        while (allDone < deployUnits.length && tryCount < this.totalTries) {
            for (JaxbDeploymentUnit deployUnit : deployUnits) {
                String deployId = deployUnit.getIdentifier();
                JaxbDeploymentUnit.JaxbDeploymentStatus jobStatus = (JaxbDeploymentUnit.JaxbDeploymentStatus)requestStatusMap.get(deployId);
                if (JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED.equals((Object)jobStatus)) {
                    ++allDone;
                    continue;
                }
                ClientRequest restRequest = this.createRequest("deployment/" + deployId);
                JaxbDeploymentUnit requestedDeployUnit = this.get(restRequest, JaxbDeploymentUnit.class);
                requestStatusMap.put(deployId, requestedDeployUnit.getStatus());
            }
            ++tryCount;
            try {
                Thread.sleep(sleepSecs * 1000);
            }
            catch (Exception e) {
                logger.error("Unable to sleep: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private ClientRequest createRequest(String relativeUrl) {
        this.requestHelper.setMediaType(MediaType.APPLICATION_JSON_TYPE);
        return this.requestHelper.createRequest(relativeUrl);
    }

    private ClientRequest createRequest(String resourcePath, String body) {
        return this.createRequest(resourcePath).body(MediaType.APPLICATION_JSON_TYPE, (Object)body);
    }

    private <T> T get(ClientRequest request, Class<T> returnType) {
        return this.process(request, 0, returnType);
    }

    private <T> T post(ClientRequest request, Class<T> returnType) {
        return this.process(request, 1, returnType);
    }

    private <T> T delete(ClientRequest request, Class<T> returnType) {
        return this.process(request, 2, returnType);
    }

    private <T> T process(ClientRequest request, int method, Class<T> returnType) {
        ClientResponse response = null;
        try {
            switch (method) {
                case 0: {
                    response = request.get(returnType);
                    break;
                }
                case 1: {
                    response = request.post(returnType);
                    break;
                }
                case 2: {
                    response = request.delete(returnType);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            String contentType = (String)response.getHeaders().getFirst((Object)"Content-Type");
            if ("application/json".equals(contentType) || "application/xml".equals(contentType)) {
                Object res;
                try {
                    this.checkResponse(response);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    T t = null;
                    response.releaseConnection();
                    return t;
                }
                Object object = res = response.getEntity(returnType);
                return (T)object;
            }
            try {
                String responseBody = ((String)response.getEntity(String.class)).replaceAll("><", ">\n<");
                String headerTag = "<h1>";
                int h1StartPosition = responseBody.indexOf("<h1>");
                if (h1StartPosition < 0) {
                    logger.error("Failed cloning repository. Full response body on DEBUG.");
                    logger.debug("Repository cloning response body: {}", (Object)responseBody);
                    throw new IllegalStateException("Unexpected content-type: " + contentType);
                }
                int h1EndPosition = responseBody.indexOf("</h1>");
                String reason = responseBody.substring(h1StartPosition + "<h1>".length(), h1EndPosition);
                logger.error("Failed cloning repository, reason given: '{}'. Full response body on DEBUG.", (Object)reason);
                logger.debug("Repository cloning response body: {}", (Object)responseBody);
                throw new IllegalStateException("Failed cloning repository.");
            }
            catch (ReaderException ex) {
                response.resetStream();
                logger.error("Bad entity: {}", response.getEntity(String.class));
                throw new IllegalStateException(ex);
            }
        }
        finally {
            response.releaseConnection();
        }
    }

    private void checkResponse(ClientResponse<?> responseObj) throws Exception {
        ClientResponse test = BaseClientResponse.copyFromError(responseObj);
        responseObj.resetStream();
        if (test.getResponseStatus() == Response.Status.BAD_REQUEST) {
            throw new BadRequestException((String)test.getEntity(String.class));
        }
        if (test.getResponseStatus() != Response.Status.OK && test.getResponseStatus() != Response.Status.ACCEPTED && test.getResponseStatus() != Response.Status.NOT_FOUND) {
            throw new IllegalStateException("Request operation failed. Response status = " + test.getResponseStatus() + "\n\n" + (String)test.getEntity(String.class));
        }
        logger.info("Response entity: [{}]", test.getEntity(String.class));
    }
}

