/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.util;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.MediaType;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.spi.interception.ClientExecutionContext;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;
import org.kie.services.client.api.command.exception.RemoteCommunicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRequestHelper {
    private ClientRequestFactory requestFactory;
    private URL serverPlusRestUrl = null;
    private MediaType type = null;
    private String username = null;
    private String password = null;
    private int timeout = 5;
    private boolean formBasedAuth = false;
    private static int DEFAULT_TIMEOUT = 5;
    public static AtomicInteger idGen = new AtomicInteger(1);

    private URL addRestToPath(URL origUrl) {
        StringBuilder urlString = new StringBuilder(origUrl.toExternalForm());
        if (!urlString.toString().endsWith("/")) {
            urlString.append("/");
        }
        urlString.append("rest/");
        this.serverPlusRestUrl = RestRequestHelper.convertStringToUrl(urlString.toString());
        return this.serverPlusRestUrl;
    }

    private static URL convertStringToUrl(String urlString) {
        URL realUrl;
        try {
            realUrl = new URL(urlString);
        }
        catch (MalformedURLException murle) {
            throw new IllegalArgumentException("URL (" + urlString + ") is incorrectly formatted: " + murle.getMessage(), murle);
        }
        return realUrl;
    }

    private RestRequestHelper() {
    }

    public static RestRequestHelper newInstance(URL serverPortUrl, String username, String password, int timeout, MediaType mediaType, boolean formBasedAuth) {
        RestRequestHelper inst = new RestRequestHelper();
        URL serverPlusRestUrl = inst.addRestToPath(serverPortUrl);
        inst.requestFactory = formBasedAuth ? RestRequestHelper.createFormBasedAuthenticatingRequestFactory(serverPlusRestUrl, username, password, timeout) : RestRequestHelper.createAuthenticatingRequestFactory(serverPlusRestUrl, username, password, timeout);
        inst.type = mediaType;
        inst.username = username;
        inst.password = password;
        return inst;
    }

    public static RestRequestHelper newInstance(URL serverPortUrl, String username, String password, int timeout, MediaType mediaType) {
        return RestRequestHelper.newInstance(serverPortUrl, username, password, timeout, mediaType, false);
    }

    public static RestRequestHelper newInstance(URL serverPortUrl, String username, String password, int timeout) {
        return RestRequestHelper.newInstance(serverPortUrl, username, password, timeout, null);
    }

    public static RestRequestHelper newInstance(URL serverPortUrl, String username, String password) {
        return RestRequestHelper.newInstance(serverPortUrl, username, password, DEFAULT_TIMEOUT, null);
    }

    public RestRequestHelper setMediaType(MediaType type) {
        this.type = type;
        return this;
    }

    public MediaType getMediaType() {
        return this.type;
    }

    public RestRequestHelper setTimeout(int timeout) {
        this.timeout = timeout;
        this.requestFactory = RestRequestHelper.createAuthenticatingRequestFactory(this.serverPlusRestUrl, this.username, this.password, timeout);
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public RestRequestHelper setFormBasedAuth(boolean useFormBasedAuth) {
        this.formBasedAuth = useFormBasedAuth;
        return this;
    }

    public boolean getFormBasedAuth() {
        return this.formBasedAuth;
    }

    public ClientRequest createRequest(String restOperationUrl) {
        if (restOperationUrl.startsWith("/")) {
            restOperationUrl = restOperationUrl.substring(1);
        }
        ClientRequest request = this.requestFactory.createRelativeRequest(restOperationUrl);
        if (this.type != null) {
            request.accept(this.type);
        }
        return request;
    }

    public static ClientRequestFactory createRequestFactory(URL restBaseUrl, String username, String password, int timeout) {
        return RestRequestHelper.createAuthenticatingRequestFactory(restBaseUrl, username, password, timeout);
    }

    public static ClientRequestFactory createRequestFactory(URL restBaseUrl, String username, String password) {
        return RestRequestHelper.createAuthenticatingRequestFactory(restBaseUrl, username, password, DEFAULT_TIMEOUT);
    }

    public static ClientRequestFactory createRequestFactory(URL restBaseUrl, String username, String password, boolean useFormBasedAuth) {
        if (useFormBasedAuth) {
            return RestRequestHelper.createFormBasedAuthenticatingRequestFactory(restBaseUrl, username, password, DEFAULT_TIMEOUT);
        }
        return RestRequestHelper.createAuthenticatingRequestFactory(restBaseUrl, username, password, DEFAULT_TIMEOUT);
    }

    public static ClientRequestFactory createRequestFactory(URL restBaseUrl, String username, String password, int timeout, boolean useFormBasedAuth) {
        if (useFormBasedAuth) {
            return RestRequestHelper.createFormBasedAuthenticatingRequestFactory(restBaseUrl, username, password, timeout);
        }
        return RestRequestHelper.createAuthenticatingRequestFactory(restBaseUrl, username, password, timeout);
    }

    public static ClientRequestFactory createAuthenticatingRequestFactory(URL url, String username, String password, int timeout) {
        BasicHttpContext localContext = new BasicHttpContext();
        DefaultHttpClient preemptiveAuthClient = RestRequestHelper.createPreemptiveAuthHttpClient(username, password, timeout, localContext);
        ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor((HttpClient)preemptiveAuthClient, (HttpContext)localContext);
        try {
            return new ClientRequestFactory((ClientExecutor)clientExecutor, url.toURI());
        }
        catch (URISyntaxException urise) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is not formatted correctly.", urise);
        }
    }

    public static ClientRequestFactory createFormBasedAuthenticatingRequestFactory(URL url, String username, String password, int timeout) {
        try {
            return new FormBasedAuthenticatingClientRequestFactory(url.toURI(), username, password, timeout);
        }
        catch (URISyntaxException urise) {
            throw new RemoteCommunicationException("Invalid URL: " + url.toExternalForm(), (Throwable)urise);
        }
    }

    private static DefaultHttpClient createPreemptiveAuthHttpClient(String userName, String password, int timeout, BasicHttpContext localContext) {
        BasicHttpParams params = new BasicHttpParams();
        int timeoutMilliSeconds = timeout * 1000;
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeoutMilliSeconds);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeoutMilliSeconds);
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        if (userName != null && !"".equals(userName)) {
            client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(userName, password));
            BasicScheme basicAuth = new BasicScheme();
            String contextId = UUID.randomUUID().toString();
            localContext.setAttribute(contextId, (Object)basicAuth);
            client.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth(contextId), 0);
        }
        String hostname = "localhost";
        try {
            hostname = Inet6Address.getLocalHost().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        String userAgent = "org.kie.services.client (" + idGen.incrementAndGet() + " / " + hostname + ")";
        HttpProtocolParams.setUserAgent((HttpParams)client.getParams(), (String)userAgent);
        return client;
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        private final String contextId;

        public PreemptiveAuth(String contextId) {
            this.contextId = contextId;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute(this.contextId);
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    authState.update(authScheme, creds);
                }
            }
        }
    }

    static class FormBasedAuthenticatingInterceptor
    implements ClientExecutionInterceptor {
        private static final Logger logger = LoggerFactory.getLogger(FormBasedAuthenticatingInterceptor.class);
        private static final String LOGIN_FORM = "/j_security_check";
        private static final String FORM_BASED_AUTH_PROPERTY = "org.kie.remote.form.based.auth";
        private final String username;
        private final String password;
        private String sessionCookie = null;

        public FormBasedAuthenticatingInterceptor(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public ClientResponse<?> execute(ClientExecutionContext ctx) throws Exception {
            ClientRequest origRequest = ctx.getRequest();
            if (this.sessionCookie != null) {
                origRequest.header("Cookie", (Object)this.sessionCookie);
            }
            URL restUrl = new URL(origRequest.getUri());
            String restUrlString = restUrl.toExternalForm();
            String origRequestMethod = origRequest.getHttpMethod();
            this.debug("Processing request: [" + origRequestMethod + "] " + restUrlString + (this.sessionCookie == null ? "" : " (session: " + this.sessionCookie + ")"));
            ClientResponse response = ctx.proceed();
            int status = response.getStatus();
            this.debug("Response received [" + status + "]");
            if (restUrlString.endsWith(LOGIN_FORM) || Boolean.parseBoolean((String)origRequest.getAttributes().get(FORM_BASED_AUTH_PROPERTY))) {
                return response;
            }
            String requestCookie = (String)response.getHeaders().getFirst((Object)"Set-Cookie");
            Object contentTypeObj = response.getHeaders().getFirst((Object)"Content-Type");
            boolean doFormBasedAuth = false;
            if (contentTypeObj != null && contentTypeObj instanceof String && ((String)contentTypeObj).startsWith("text/html") && requestCookie != null && !requestCookie.equals(this.sessionCookie)) {
                this.debug("New session cookie: " + requestCookie);
                doFormBasedAuth = true;
                this.sessionCookie = requestCookie;
            }
            if (doFormBasedAuth) {
                response.releaseConnection();
                String appBase = "/" + restUrl.getPath().substring(1).replaceAll("/.*", "");
                URL appBaseUrl = new URL(restUrl.getProtocol(), restUrl.getHost(), restUrl.getPort(), appBase);
                ClientRequestFactory requestFactory = new ClientRequestFactory(appBaseUrl.toURI());
                ClientRequest formRequest = requestFactory.createRelativeRequest(LOGIN_FORM);
                formRequest = formRequest.formParameter("j_username", (Object)this.username).formParameter("j_password", (Object)this.password);
                if (this.sessionCookie != null) {
                    formRequest.header("Cookie", (Object)this.sessionCookie);
                }
                try {
                    this.debug("Trying form-based authentication for session '" + this.sessionCookie + "'");
                    response = formRequest.post();
                    int formRequestStatus = response.getStatus();
                    if (formRequestStatus != 302) {
                        String errMsg = "Unable to complete form-based authentication in via " + formRequest.getUri();
                        System.err.println(errMsg + "\n [" + formRequestStatus + "] " + (String)response.getEntity(String.class));
                        throw new RemoteCommunicationException(errMsg + " (see output)");
                    }
                    this.debug("Form-based authentication succeeded.");
                }
                catch (RemoteCommunicationException rce) {
                    throw rce;
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    String errMsg = "Unable to complete form-based authentication in via " + formRequest.getUri();
                    throw new RemoteCommunicationException(errMsg, (Throwable)e);
                }
                finally {
                    try {
                        response.releaseConnection();
                    }
                    catch (Exception e) {}
                }
                try {
                    if (this.sessionCookie == null) {
                        throw new IllegalStateException("A cookie for a authenticated session should be available at this point!");
                    }
                    this.debug("Retrying original request (proceed): [" + origRequestMethod + "] " + restUrlString);
                    response = ctx.proceed();
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RemoteCommunicationException("Unable to " + origRequestMethod + " to " + restUrlString, (Throwable)e);
                }
            }
            return response;
        }

        private void debug(String msg) {
            logger.debug(msg);
        }
    }

    static class FormBasedAuthenticatingClientRequestFactory
    extends ClientRequestFactory {
        private final String username;
        private final String password;
        private final ClientExecutor executor;

        public FormBasedAuthenticatingClientRequestFactory(URI uri, String username, String password, int timeout) {
            super(uri);
            this.username = username;
            this.password = password;
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpParams params = httpClient.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)(timeout * 1000));
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)(timeout * 1000));
            this.executor = new ApacheHttpClient4Executor((HttpClient)httpClient);
        }

        public ClientRequest createRelativeRequest(String uriTemplate) {
            ClientRequest request = this.executor.createRequest(this.getBase().toString() + uriTemplate);
            request.registerInterceptor((Object)new FormBasedAuthenticatingInterceptor(this.username, this.password));
            return request;
        }

        public ClientRequest createRequest(String uriTemplate) {
            ClientRequest request = this.executor.createRequest(uriTemplate);
            request.registerInterceptor((Object)new FormBasedAuthenticatingInterceptor(this.username, this.password));
            return request;
        }
    }
}

