/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtil {
    private static Logger logger = LoggerFactory.getLogger(RestUtil.class);
    private static final int GET = 0;
    private static final int POST = 1;
    private static final int DEL = 2;
    public static long restCallDurationLimit = 500L;
    private static SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");

    public static ClientResponse<?> delete(ClientRequest restRequest, MediaType mediaType) {
        return RestUtil.httpMethodReturnResponse(2, restRequest, mediaType, 200);
    }

    public static ClientResponse<?> get(ClientRequest restRequest, MediaType mediaType) {
        return RestUtil.httpMethodReturnResponse(0, restRequest, mediaType, 200);
    }

    public static ClientResponse<?> post(ClientRequest restRequest, MediaType mediaType) {
        return RestUtil.httpMethodReturnResponse(1, restRequest, mediaType, 200);
    }

    public static <T> T delete(ClientRequest restRequest, MediaType mediaType, Class<T> responseType) {
        return RestUtil.httpMethodReturnType(2, restRequest, mediaType, 200, responseType);
    }

    public static <T> T get(ClientRequest restRequest, MediaType mediaType, Class<T> responseType) {
        return RestUtil.httpMethodReturnType(0, restRequest, mediaType, 200, responseType);
    }

    public static <T> T post(ClientRequest restRequest, MediaType mediaType, Class<T> responseType) {
        return RestUtil.httpMethodReturnType(1, restRequest, mediaType, 200, responseType);
    }

    public static <T> T delete(ClientRequest restRequest, MediaType mediaType, int status, Class<T> responseType) {
        return RestUtil.httpMethodReturnType(2, restRequest, mediaType, status, responseType);
    }

    public static <T> T get(ClientRequest restRequest, MediaType mediaType, int status, Class<T> responseType) {
        return RestUtil.httpMethodReturnType(0, restRequest, mediaType, status, responseType);
    }

    public static <T> T post(ClientRequest restRequest, MediaType mediaType, int status, Class<T> responseType) {
        return RestUtil.httpMethodReturnType(1, restRequest, mediaType, status, responseType);
    }

    public static void post(ClientRequest restRequest, MediaType mediaType, int status) {
        ClientResponse<?> responseObj = RestUtil.httpMethodReturnResponse(1, restRequest, mediaType, status);
        responseObj.releaseConnection();
    }

    private static ClientResponse<?> httpMethodReturnResponse(int type, ClientRequest restRequest, MediaType mediaType, int status) {
        RestUtil.setAcceptHeader(restRequest, mediaType);
        ClientResponse<?> responseObj = RestUtil.logAndExecuteRequest(type, restRequest);
        return RestUtil.checkResponse(responseObj, status);
    }

    private static <T> T httpMethodReturnType(int type, ClientRequest restRequest, MediaType mediaType, int status, Class<T> responseType) {
        ClientResponse<?> responseObj = RestUtil.httpMethodReturnResponse(type, restRequest, mediaType, status);
        return RestUtil.getResponseEntity(responseObj, responseType);
    }

    private static ClientResponse<?> logAndExecuteRequest(int type, ClientRequest restRequest) {
        String typeName;
        switch (type) {
            case 0: {
                typeName = "GET";
                break;
            }
            case 1: {
                typeName = "POST";
                break;
            }
            case 2: {
                typeName = "DEL";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown HTTP method type: " + type);
            }
        }
        try {
            logger.debug(">> [{} {}] {}", new Object[]{typeName, restRequest.getHeaders().getFirst((Object)"Accept"), restRequest.getUri()});
        }
        catch (Exception e) {
            logger.error("Unable to log information about rest request:  {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)"Unable to log information about rest request; see log and stack trace");
        }
        ClientResponse response = null;
        try {
            switch (type) {
                case 0: {
                    response = restRequest.get();
                    break;
                }
                case 1: {
                    response = restRequest.post();
                    break;
                }
                case 2: {
                    response = restRequest.delete();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown HTTP method type: " + type);
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to execute rest request:  {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)"Unable to log information about rest request; see log and stack trace");
        }
        return response;
    }

    private static <T> T getResponseEntity(ClientResponse<?> responseObj, Class<T> responseType) {
        Object responseEntity = null;
        try {
            responseEntity = responseObj.getEntity(responseType);
        }
        catch (Exception e) {
            String msg = "Unable to serialize " + responseType.getSimpleName() + " instance";
            logger.error(msg, (Throwable)e);
            responseObj.resetStream();
            logger.error("Body of response:\n {}", responseObj.getEntity(String.class));
            Assert.fail((String)msg);
            throw new RuntimeException("Fail should keep this exception from being thrown!");
        }
        return (T)responseEntity;
    }

    private static ClientResponse<?> checkResponse(ClientResponse<?> responseObj, int status) {
        String contentType;
        responseObj.resetStream();
        int reqStatus = responseObj.getStatus();
        if (reqStatus != status) {
            logger.warn("Response with exception:\n" + (String)responseObj.getEntity(String.class));
            Assert.fail((String)("Incorrect status: " + reqStatus));
        }
        if ((contentType = (String)responseObj.getHeaders().getFirst((Object)"Content-Type")) != null && !contentType.startsWith("application/xml") && !contentType.startsWith("application/json")) {
            logger.warn("Incorrect format for response: " + contentType + "\n" + (String)responseObj.getEntity(String.class));
            Assert.fail((String)("Incorrect response media type: " + contentType));
        }
        return responseObj;
    }

    public static void setAcceptHeader(ClientRequest restRequest, MediaType mediaType) {
        Assert.assertNotNull((String)"Null media type.", (Object)mediaType);
        MultivaluedMap headers = restRequest.getHeaders();
        headers.putSingle((Object)"Accept", (Object)(mediaType.getType() + "/" + mediaType.getSubtype()));
        Assert.assertNotNull((String)"Null ACCEPT headers!", (Object)headers.get((Object)"Accept"));
        Assert.assertEquals((String)"Multiple ACCEPT headers!", (long)1L, (long)((List)headers.get((Object)"Accept")).size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientResponse<?> checkTimeResponse(ClientResponse<?> responseObj) throws Exception {
        ClientResponse<?> clientResponse;
        long start = System.currentTimeMillis();
        try {
            clientResponse = RestUtil.checkResponse(responseObj, 202);
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - start;
            Assert.assertTrue((String)("Rest call took too long: " + duration + "ms"), (duration < restCallDurationLimit ? 1 : 0) != 0);
            logger.info("Op time : " + sdf.format(new Date(duration)));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - start;
        Assert.assertTrue((String)("Rest call took too long: " + duration + "ms"), (duration < restCallDurationLimit ? 1 : 0) != 0);
        logger.info("Op time : " + sdf.format(new Date(duration)));
        return clientResponse;
    }

    public static ClientResponse<?> checkResponsePostTime(ClientRequest restRequest, MediaType mediaType, int status) throws Exception {
        RestUtil.setAcceptHeader(restRequest, mediaType);
        long before = System.currentTimeMillis();
        logger.debug("BEFORE: " + sdf.format(before));
        ClientResponse<?> responseObj = RestUtil.checkResponse(restRequest.post(), status);
        long after = System.currentTimeMillis();
        logger.debug("AFTER: " + sdf.format(after));
        long duration = after - before;
        Assert.assertTrue((String)("Call took longer than " + restCallDurationLimit / 1000L + " seconds: " + duration + "ms"), (duration < restCallDurationLimit ? 1 : 0) != 0);
        return responseObj;
    }
}

