/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.ws;

import java.net.URL;
import java.util.Arrays;
import javax.ws.rs.core.MediaType;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.remote.client.api.RemoteRuntimeEngineFactory;
import org.kie.remote.client.api.RemoteWebserviceClientBuilder;
import org.kie.remote.client.jaxb.ClientJaxbSerializationProvider;
import org.kie.remote.client.jaxb.JaxbCommandsRequest;
import org.kie.remote.client.jaxb.JaxbCommandsResponse;
import org.kie.remote.jaxb.gen.JaxbStringObjectPairArray;
import org.kie.remote.jaxb.gen.StartProcessCommand;
import org.kie.remote.jaxb.gen.util.JaxbStringObjectPair;
import org.kie.remote.services.ws.command.generated.CommandWebService;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.JsonSerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceResponse;
import org.kie.smoke.wb.AbstractWorkbenchIntegrationTest;
import org.kie.smoke.wb.util.TestConstants;
import org.kie.tests.MyType;
import org.kie.tests.Person;
import org.kie.tests.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieRemoteWebServiceSmokeIntegrationTest
extends AbstractWorkbenchIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger(KieRemoteWebServiceSmokeIntegrationTest.class);
    private final String deploymentId;
    private final KModuleDeploymentUnit deploymentUnit;
    private static final RuntimeStrategy strategy = RuntimeStrategy.SINGLETON;
    private static final String SCRIPT_TASK_PROCESS_ID = "org.test.kjar.scripttask";
    private MediaType mediaType;
    private int timeout;
    private static final int DEFAULT_TIMEOUT = 10;
    private static JaxbSerializationProvider jaxbSerializationProvider;
    private JsonSerializationProvider jsonSerializationProvider;

    public KieRemoteWebServiceSmokeIntegrationTest() {
        Class[] extraClasses = new Class[]{MyType.class, Person.class, Request.class};
        jaxbSerializationProvider = ClientJaxbSerializationProvider.newInstance(Arrays.asList(extraClasses));
        this.jsonSerializationProvider = new JsonSerializationProvider();
        this.deploymentId = TestConstants.KJAR_DEPLOYMENT_ID;
        this.mediaType = MediaType.APPLICATION_XML_TYPE;
        this.timeout = 1000;
        this.deploymentUnit = new KModuleDeploymentUnit("org.test", "kjar", "1.0");
        Assert.assertEquals((String)"Returned deployment unit identifier is incorrect!", (Object)this.deploymentId, (Object)this.deploymentUnit.getIdentifier());
    }

    private CommandWebService createCommandServiceClient(URL deploymentUrl, String deploymentId, String user, String pwd) throws Exception {
        CommandWebService client = (CommandWebService)((RemoteWebserviceClientBuilder)((RemoteWebserviceClientBuilder)((RemoteWebserviceClientBuilder)((RemoteWebserviceClientBuilder)RemoteRuntimeEngineFactory.newCommandWebServiceClientBuilder().addServerUrl(deploymentUrl).addUserName(user)).addPassword(pwd)).addDeploymentId(TestConstants.KJAR_DEPLOYMENT_ID)).addExtraJaxbClasses(new Class[]{MyType.class})).buildBasicAuthClient();
        return client;
    }

    @BeforeClass
    public static void setupDeployment() throws Exception {
        KieRemoteWebServiceSmokeIntegrationTest.deployJbpmPlayGroundIntegrationTests(RuntimeStrategy.SINGLETON);
    }

    @AfterClass
    public static void waitForTxOnServer() throws InterruptedException {
        long sleep = 1L;
        logger.info("Waiting " + sleep + " secs for tx's on server to close.");
        Thread.sleep(sleep * 1000L);
    }

    @Test
    public void startSimpleProcess() throws Exception {
        CommandWebService commandWebService = this.createCommandServiceClient(deploymentUrl, this.deploymentId, "mary", "mary123@");
        logger.info("[Client] Webservice request.");
        StartProcessCommand cmd = new StartProcessCommand();
        cmd.setProcessId(SCRIPT_TASK_PROCESS_ID);
        JaxbStringObjectPairArray map = new JaxbStringObjectPairArray();
        JaxbStringObjectPair keyValue = new JaxbStringObjectPair();
        keyValue.setKey("myobject");
        keyValue.setValue((Object)new MyType("variable", 29));
        map.getItems().add(keyValue);
        cmd.setParameter(map);
        JaxbCommandsRequest req = new JaxbCommandsRequest(TestConstants.KJAR_DEPLOYMENT_ID, (Command)cmd);
        JaxbCommandsResponse response = commandWebService.execute(req);
        Assert.assertNotNull((String)"Null webservice response", (Object)response);
        Assert.assertFalse((String)"Empty webservice response", (boolean)response.getResponses().isEmpty());
        JaxbCommandResponse cmdResp = (JaxbCommandResponse)response.getResponses().get(0);
        Assert.assertNotNull((String)"Null command response", (Object)cmdResp);
        if (!(cmdResp instanceof JaxbProcessInstanceResponse)) {
            System.out.println("!!: " + cmdResp.getClass().getSimpleName());
            Assert.assertTrue((String)"Incorrect cmd response type", (boolean)(cmdResp instanceof JaxbProcessInstanceResponse));
        }
        logger.info("[WebService] response: {} [{}]", (Object)((JaxbProcessInstanceResponse)cmdResp).getId(), (Object)((JaxbProcessInstanceResponse)cmdResp).getProcessId());
    }
}

