/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb;

import java.net.MalformedURLException;
import java.net.URL;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.smoke.wb.util.RestRepositoryDeploymentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorkbenchIntegrationTest {
    private static Logger logger = LoggerFactory.getLogger(AbstractWorkbenchIntegrationTest.class);
    protected static final URL deploymentUrl;
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            System.out.println("Starting test: " + description.getMethodName());
        }
    };

    protected static void deployJbpmPlayGroundIntegrationTests(RuntimeStrategy strategy) {
        int sleepSecs = 5;
        RestRepositoryDeploymentUtil deployUtil = new RestRepositoryDeploymentUtil(deploymentUrl, "mary", "mary123@", sleepSecs, strategy);
        deployUtil.setTotalTries(6);
        String repoUrl = "https://github.com/droolsjbpm/jbpm-playground.git";
        String repositoryName = "playground";
        String project = "integration-tests";
        String deploymentId = "org.test:kjar:1.0";
        String orgUnitName = "integTestUser";
        deployUtil.createRepositoryAndDeployProject(repoUrl, repositoryName, project, deploymentId, orgUnitName, "mary");
        try {
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    static {
        try {
            deploymentUrl = new URL(System.getProperty("deployable.base.uri"));
            logger.info("deployable.base.uri=" + deploymentUrl.toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed deployment URL '" + System.getProperty("deployable.base.uri") + "'!", e);
        }
    }
}

