/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.rest;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.net.util.Base64;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.remote.client.api.RemoteRestRuntimeEngineBuilder;
import org.kie.remote.client.api.RemoteRuntimeEngineFactory;
import org.kie.remote.client.jaxb.ClientJaxbSerializationProvider;
import org.kie.remote.client.jaxb.JaxbTaskSummaryListResponse;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbHistoryLogList;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbProcessInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbVariableInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnitList;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinition;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceResponse;
import org.kie.smoke.wb.AbstractWorkbenchIntegrationTest;
import org.kie.smoke.wb.category.KieWbSmoke;
import org.kie.smoke.wb.util.RestUtil;
import org.kie.smoke.wb.util.TestConstants;
import org.kie.tests.MyType;
import org.kie.tests.Person;
import org.kie.tests.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={KieWbSmoke.class})
public class KieRemoteRestSmokeIntegrationTest
extends AbstractWorkbenchIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger(KieRemoteRestSmokeIntegrationTest.class);
    private static final String taskUserId = "salaboy";
    private final String deploymentId = TestConstants.KJAR_DEPLOYMENT_ID;
    private final KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.test", "kjar", "1.0");
    private String mediaType = "application/xml";

    public KieRemoteRestSmokeIntegrationTest() {
        Assert.assertEquals((String)"Returned deployment unit identifier is incorrect!", (Object)this.deploymentId, (Object)this.deploymentUnit.getIdentifier());
    }

    private RuntimeEngine getRemoteRuntime(URL deploymentUrl, String user, String password) {
        return ((RemoteRestRuntimeEngineBuilder)((RemoteRestRuntimeEngineBuilder)((RemoteRestRuntimeEngineBuilder)((RemoteRestRuntimeEngineBuilder)RemoteRuntimeEngineFactory.newRestBuilder().addDeploymentId(this.deploymentId)).addUrl(deploymentUrl).addUserName(user)).addPassword(password)).addExtraJaxbClasses(new Class[]{MyType.class, Person.class, Request.class})).build();
    }

    @BeforeClass
    public static void setupDeployment() throws Exception {
        KieRemoteRestSmokeIntegrationTest.deployJbpmPlayGroundIntegrationTests(RuntimeStrategy.SINGLETON);
    }

    @AfterClass
    public static void waitForTxOnServer() throws InterruptedException {
        long sleep = 1L;
        logger.info("Waiting " + sleep + " secs for tx's on server to close.");
        Thread.sleep(sleep * 1000L);
    }

    @Test
    public void testUrlsGetDeployments() throws Exception {
        String user = "mary";
        String password = "mary123@";
        JaxbDeploymentUnitList depList = (JaxbDeploymentUnitList)RestUtil.get((URL)deploymentUrl, (String)"rest/deployment/", (String)this.mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{JaxbDeploymentUnitList.class});
        Assert.assertNotNull((String)"Null answer!", (Object)depList);
        Assert.assertNotNull((String)"Null deployment list!", (Object)depList.getDeploymentUnitList());
        Assert.assertTrue((String)"Empty deployment list!", (depList.getDeploymentUnitList().size() > 0 ? 1 : 0) != 0);
        String deploymentId = ((JaxbDeploymentUnit)depList.getDeploymentUnitList().get(0)).getIdentifier();
        JaxbDeploymentUnit dep = (JaxbDeploymentUnit)RestUtil.get((URL)deploymentUrl, (String)("rest/deployment/" + deploymentId), (String)this.mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{JaxbDeploymentUnit.class});
        Assert.assertNotNull((String)"Null answer!", (Object)dep);
        Assert.assertNotNull((String)"Null deployment list!", (Object)dep);
        Assert.assertEquals((String)"Empty status!", (Object)JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED, (Object)dep.getStatus());
        URL url = new URL(deploymentUrl, deploymentUrl.getPath() + "rest/deployment/");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        String authString = user + ":" + password;
        byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
        String authStringEnc = new String(authEncBytes);
        connection.setRequestProperty("Authorization", "Basic " + authStringEnc);
        connection.setRequestMethod("GET");
        logger.debug(">> [GET] " + url.toExternalForm());
        connection.connect();
        int respCode = connection.getResponseCode();
        if (200 != respCode) {
            logger.warn(connection.getContent().toString());
        }
        Assert.assertEquals((long)200L, (long)respCode);
        JaxbSerializationProvider jaxbSerializer = ClientJaxbSerializationProvider.newInstance();
        String xmlStrObj = this.getConnectionContent(connection.getContent());
        depList = (JaxbDeploymentUnitList)jaxbSerializer.deserialize(xmlStrObj);
        Assert.assertNotNull((String)"Null answer!", (Object)depList);
        Assert.assertNotNull((String)"Null deployment list!", (Object)depList.getDeploymentUnitList());
        Assert.assertTrue((String)"Empty deployment list!", (depList.getDeploymentUnitList().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRestHistoryLogs() throws Exception {
        String user = "mary";
        String password = "mary123@";
        JaxbProcessInstanceResponse processInstance = (JaxbProcessInstanceResponse)RestUtil.post((URL)deploymentUrl, (String)("rest/runtime/" + this.deploymentId + "/process/" + "org.test.kjar.scripttask.var" + "/start?map_x=initVal"), (String)this.mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{JaxbProcessInstanceResponse.class});
        long scriptTaskVarProcInstId = processInstance.getId();
        JaxbHistoryLogList historyLogList = (JaxbHistoryLogList)RestUtil.get((URL)deploymentUrl, (String)"rest/history/instances", (String)this.mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{JaxbHistoryLogList.class});
        List auditEventList = historyLogList.getResult();
        Assert.assertFalse((String)"Empty list of audit events.", (boolean)auditEventList.isEmpty());
        for (Object event : auditEventList) {
            Assert.assertTrue((String)"ProcessInstanceLog", (boolean)(event instanceof ProcessInstanceLog));
            ProcessInstanceLog procLog = (ProcessInstanceLog)event;
            Object[][] out = new Object[][]{{procLog.getDuration(), "duration"}, {procLog.getEnd(), "end date"}, {procLog.getIdentity(), "identity"}, {procLog.getOutcome(), "outcome"}, {procLog.getParentProcessInstanceId(), "parent proc id"}, {procLog.getProcessId(), "process id"}, {procLog.getProcessInstanceId(), "process instance id"}, {procLog.getProcessName(), "process name"}, {procLog.getProcessVersion(), "process version"}, {procLog.getStart(), "start date"}, {procLog.getStatus(), "status"}};
            for (int i = 0; i < out.length; ++i) {
            }
        }
        ProcessInstanceLog origProcInstLog = (ProcessInstanceLog)auditEventList.get(0);
        long procInstId = origProcInstLog.getProcessInstanceId();
        JaxbProcessInstanceLog procInstLog = (JaxbProcessInstanceLog)RestUtil.get((URL)deploymentUrl, (String)("rest/history/instance/" + origProcInstLog.getProcessInstanceId()), (String)this.mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{JaxbProcessInstanceLog.class});
        Assert.assertNotNull((String)"Null process instance log!", (Object)procInstLog);
        Assert.assertEquals((String)"Log process instance id", (long)procInstId, (long)procInstLog.getProcessInstanceId());
        Assert.assertEquals((String)"Process instance status", (Object)origProcInstLog.getStatus(), (Object)procInstLog.getStatus());
        historyLogList = (JaxbHistoryLogList)RestUtil.get((URL)deploymentUrl, (String)("rest/history/instance/" + procInstId + "/node"), (String)this.mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{JaxbHistoryLogList.class});
        Assert.assertNotNull((String)"Null process instance log!", (Object)historyLogList);
        auditEventList = historyLogList.getResult();
        Assert.assertTrue((String)"Empty audit event list!", (auditEventList != null && !auditEventList.isEmpty() ? 1 : 0) != 0);
        historyLogList = (JaxbHistoryLogList)RestUtil.get((URL)deploymentUrl, (String)("rest/history/instance/" + scriptTaskVarProcInstId + "/variable/x"), (String)this.mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{JaxbHistoryLogList.class});
        List historyVarLogList = historyLogList.getHistoryLogList();
        for (int i = 0; i < historyVarLogList.size(); ++i) {
            JaxbVariableInstanceLog varLog = (JaxbVariableInstanceLog)historyVarLogList.get(i);
            JaxbVariableInstanceLog historyVarLog = (JaxbVariableInstanceLog)historyVarLogList.get(i);
            Assert.assertEquals((Object)historyVarLog.getValue(), (Object)varLog.getValue());
            Assert.assertEquals((String)"Incorrect variable id", (Object)"x", (Object)varLog.getVariableId());
            Assert.assertEquals((String)"Incorrect process id", (Object)"org.test.kjar.scripttask.var", (Object)varLog.getProcessId());
            Assert.assertEquals((String)"Incorrect process instance id", (long)scriptTaskVarProcInstId, (long)varLog.getProcessInstanceId());
        }
        JaxbProcessDefinition procDef = (JaxbProcessDefinition)RestUtil.get((URL)deploymentUrl, (String)("rest/runtime/" + this.deploymentId + "/process/" + "org.test.kjar.ObjectVariableProcess"), (String)this.mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{JaxbProcessDefinition.class});
        Assert.assertNotNull((String)"Empty process definition!", (Object)procDef);
        Assert.assertEquals((String)"Process definition id", (Object)"org.test.kjar.ObjectVariableProcess", (Object)procDef.getId());
        String varId = "myobject";
        String varVal = "10";
        JaxbProcessInstanceResponse procInstResp = (JaxbProcessInstanceResponse)RestUtil.post((URL)deploymentUrl, (String)("rest/runtime/" + this.deploymentId + "/process/" + "org.test.kjar.ObjectVariableProcess" + "/start?map_" + varId + "=" + varVal), (String)this.mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{JaxbProcessInstanceResponse.class});
        long objVarProcInstId = procInstResp.getResult().getId();
        JaxbHistoryLogList jhll = (JaxbHistoryLogList)RestUtil.get((URL)deploymentUrl, (String)("rest/history/variable/" + varId), (String)this.mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{JaxbHistoryLogList.class});
        ArrayList<VariableInstanceLog> viLogs = new ArrayList<VariableInstanceLog>();
        if (jhll != null) {
            List history = jhll.getResult();
            for (Object ae : history) {
                VariableInstanceLog viLog = (VariableInstanceLog)ae;
                if (viLog.getProcessInstanceId() != objVarProcInstId) continue;
                viLogs.add(viLog);
            }
        }
        Assert.assertNotNull((String)"Empty VariableInstanceLog list.", viLogs);
        Assert.assertEquals((String)"VariableInstanceLog list size", (long)1L, (long)viLogs.size());
        VariableInstanceLog vil = (VariableInstanceLog)viLogs.get(0);
        Assert.assertNotNull((String)"Empty VariableInstanceLog instance.", (Object)vil);
        Assert.assertEquals((String)"Process instance id", (long)vil.getProcessInstanceId(), (long)objVarProcInstId);
        Assert.assertEquals((String)"Variable id", (Object)vil.getVariableId(), (Object)"myobject");
        Assert.assertEquals((String)"Variable value", (Object)vil.getValue(), (Object)varVal);
        jhll = (JaxbHistoryLogList)RestUtil.get((URL)deploymentUrl, (String)("rest/history/variable/" + varId + "/instances"), (String)this.mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{JaxbHistoryLogList.class});
        Assert.assertNotNull((String)"Empty ProcesInstanceLog list", (Object)jhll);
        ArrayList<ProcessInstanceLog> piLogs = new ArrayList<ProcessInstanceLog>();
        if (jhll != null) {
            List history = jhll.getResult();
            for (Object ae : history) {
                piLogs.add((ProcessInstanceLog)ae);
            }
        }
        Assert.assertNotNull((String)"Empty ProcesInstanceLog list", piLogs);
        Assert.assertEquals((String)"ProcessInstanceLog list size", (long)piLogs.size(), (long)1L);
        ProcessInstanceLog pi = (ProcessInstanceLog)piLogs.get(0);
        Assert.assertNotNull((Object)pi);
    }

    @Test
    public void testRestRemoteApiHumanTaskProcess() throws Exception {
        String user = taskUserId;
        String password = "sala123@";
        RuntimeEngine engine = this.getRemoteRuntime(deploymentUrl, user, password);
        KieSession ksession = engine.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("org.test.kjar.writedocument");
        Assert.assertNotNull((String)"Null ProcessInstance!", (Object)processInstance);
        long procInstId = processInstance.getId();
        logger.debug("Started process instance: " + processInstance + " " + procInstId);
        TaskService taskService = engine.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner(taskUserId, "en-UK");
        long taskId = this.findTaskId(procInstId, tasks);
        logger.debug("Found task " + taskId);
        Task task = taskService.getTaskById(taskId);
        logger.debug("Got task " + taskId + ": " + task);
        taskService.start(taskId, taskUserId);
        taskService.complete(taskId, taskUserId, null);
        logger.debug("Now expecting failure");
        try {
            taskService.complete(taskId, taskUserId, null);
            Assert.fail((String)("Should not be able to complete task " + taskId + " a second time."));
        }
        catch (Throwable t) {
            logger.info("The above exception was an expected part of the test.");
        }
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        List taskIds = taskService.getTasksByStatusByProcessInstanceId(procInstId, statuses, "en-UK");
        Assert.assertEquals((String)"Expected 2 tasks.", (long)2L, (long)taskIds.size());
    }

    protected long findTaskId(Long procInstId, List<TaskSummary> taskSumList) {
        long taskId = -1L;
        TaskSummary task = this.findTaskSummary(procInstId, taskSumList);
        if (task != null) {
            taskId = task.getId();
        }
        Assert.assertNotEquals((String)"Could not determine taskId!", (long)-1L, (long)taskId);
        return taskId;
    }

    protected TaskSummary findTaskSummary(Long procInstId, List<TaskSummary> taskSumList) {
        for (TaskSummary task : taskSumList) {
            if (!procInstId.equals(task.getProcessInstanceId())) continue;
            return task;
        }
        Assert.fail((String)("Unable to find task summary for process instance " + procInstId));
        return null;
    }

    @Test
    public void testRestRemoteApiExtraJaxbClasses() throws Exception {
        String user = "mary";
        String password = "mary123@";
        RuntimeEngine engine = this.getRemoteRuntime(deploymentUrl, user, password);
        this.testParamSerialization(engine, new MyType("variable", 29));
        this.testParamSerialization(engine, new Float(23.01));
        this.testParamSerialization(engine, new Float[]{Float.valueOf(39.391f)});
    }

    private void testParamSerialization(RuntimeEngine engine, Object param) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("myobject", param);
        KieSession ksession = engine.getKieSession();
        ProcessInstance procInst = ksession.startProcess("org.test.kjar.ObjectVariableProcess", parameters);
        Assert.assertNotNull((String)"No process instance returned!", (Object)procInst);
        long procInstId = procInst.getId();
        List varLogList = engine.getAuditService().findVariableInstancesByName("type", false);
        VariableInstanceLog thisProcInstVarLog = null;
        for (VariableInstanceLog varLog : varLogList) {
            if (varLog.getProcessInstanceId() != procInstId) continue;
            thisProcInstVarLog = varLog;
        }
        Assert.assertNotNull((String)"No VariableInstanceLog found!", thisProcInstVarLog);
        Assert.assertEquals((Object)"type", (Object)thisProcInstVarLog.getVariableId());
        Assert.assertEquals((String)"De/serialization of Kjar type did not work.", (Object)param.getClass().getName(), (Object)thisProcInstVarLog.getValue());
        varLogList = engine.getAuditService().findVariableInstances(procInstId, "type");
        Assert.assertNotNull((String)"No variable log list retrieved!", (Object)varLogList);
        Assert.assertTrue((String)"Variable log list is empty!", (varLogList.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRestRemoteApiRuleTaskProcess() throws Exception {
        RuntimeEngine runtimeEngine = this.getRemoteRuntime(deploymentUrl, "mary", "mary123@");
        KieSession ksession = runtimeEngine.getKieSession();
        AuditService auditService = runtimeEngine.getAuditService();
        Person person = new Person("guest", "Dluhoslav Chudobny");
        person.setAge(25);
        Request request = new Request("1");
        request.setPersonId("guest");
        request.setAmount(500);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("request", request);
        params.put("person", person);
        ProcessInstance pi = ksession.startProcess("org.test.kjar.RuleTask", params);
        Assert.assertNotNull((String)"No Process instance returned!", (Object)pi);
        ksession.fireAllRules();
        Assert.assertNull((Object)ksession.getProcessInstance(pi.getId()));
        List varLogs = auditService.findVariableInstancesByName("requestReason", false);
        for (VariableInstanceLog varLog : varLogs) {
            if (varLog.getProcessInstanceId().longValue() != pi.getId()) continue;
            Assert.assertEquals((Object)"Poor customer", (Object)varLog.getValue());
        }
    }

    @Test
    public void testRestUrlsGroupAssignmentProcess() throws Exception {
        JaxbProcessInstanceResponse procInstResp = (JaxbProcessInstanceResponse)RestUtil.post((URL)deploymentUrl, (String)("rest/runtime/" + this.deploymentId + "/process/" + "org.test.kjar.GroupAssignmentHumanTask" + "/start"), (String)this.mediaType, (int)200, (String)"mary", (String)"mary123@", (Class[])new Class[]{JaxbProcessInstanceResponse.class});
        Assert.assertEquals((long)1L, (long)procInstResp.getState());
        long procInstId = procInstResp.getId();
        TaskSummary taskSummary = this.getTaskSummary(procInstId, Status.Ready, "mary", "mary123@");
        long taskId = taskSummary.getId();
        Assert.assertNull((Object)taskSummary.getActualOwner());
        Assert.assertNull((Object)taskSummary.getPotentialOwners());
        Assert.assertEquals((Object)"Task 1", (Object)taskSummary.getName());
        RestUtil.post((URL)deploymentUrl, (String)("rest/task/" + taskId + "/claim"), (String)this.mediaType, (int)200, (String)"mary", (String)"mary123@", (Class[])new Class[0]);
        RestUtil.post((URL)deploymentUrl, (String)("rest/task/" + taskId + "/start"), (String)this.mediaType, (int)200, (String)"mary", (String)"mary123@", (Class[])new Class[0]);
        RestUtil.post((URL)deploymentUrl, (String)("rest/task/" + taskId + "/complete"), (String)this.mediaType, (int)200, (String)"mary", (String)"mary123@", (Class[])new Class[0]);
        taskSummary = this.getTaskSummary(procInstId, Status.Reserved, "mary", "mary123@");
        Assert.assertEquals((Object)"Task 2", (Object)taskSummary.getName());
        Assert.assertEquals((Object)"mary", (Object)taskSummary.getActualOwner().getId());
        taskId = taskSummary.getId();
        RestUtil.post((URL)deploymentUrl, (String)("rest/task/" + taskId + "/release"), (String)this.mediaType, (int)200, (String)"mary", (String)"mary123@", (Class[])new Class[0]);
        RestUtil.post((URL)deploymentUrl, (String)("rest/task/" + taskId + "/start"), (String)this.mediaType, (int)200, (String)"john", (String)"john123@", (Class[])new Class[0]);
        RestUtil.post((URL)deploymentUrl, (String)("rest/task/" + taskId + "/complete"), (String)this.mediaType, (int)200, (String)"john", (String)"john123@", (Class[])new Class[0]);
        taskSummary = this.getTaskSummary(procInstId, Status.Reserved, "john", "john123@");
        Assert.assertEquals((Object)"Task 3", (Object)taskSummary.getName());
        Assert.assertEquals((Object)"john", (Object)taskSummary.getActualOwner().getId());
        taskId = taskSummary.getId();
        RestUtil.post((URL)deploymentUrl, (String)("rest/task/" + taskId + "/start"), (String)this.mediaType, (int)200, (String)"john", (String)"john123@", (Class[])new Class[0]);
        RestUtil.post((URL)deploymentUrl, (String)("rest/task/" + taskId + "/complete"), (String)this.mediaType, (int)200, (String)"john", (String)"john123@", (Class[])new Class[0]);
        JaxbProcessInstanceLog jaxbProcInstLog = (JaxbProcessInstanceLog)RestUtil.get((URL)deploymentUrl, (String)("rest/history/instance/" + procInstId), (String)this.mediaType, (int)200, (String)"mary", (String)"mary123@", (Class[])new Class[]{JaxbProcessInstanceLog.class});
        ProcessInstanceLog procInstLog = jaxbProcInstLog.getResult();
        Assert.assertEquals((String)"Process instance has not completed!", (long)2L, (long)procInstLog.getStatus().intValue());
    }

    private TaskSummary getTaskSummary(long processInstanceId, Status status, String user, String password) throws Exception {
        JaxbTaskSummaryListResponse taskSumListResp = (JaxbTaskSummaryListResponse)RestUtil.get((URL)deploymentUrl, (String)("rest/task/query?processInstanceId=" + processInstanceId + "&status=" + status.toString()), (String)this.mediaType, (int)200, (String)user, (String)password, (Class[])new Class[]{JaxbTaskSummaryListResponse.class});
        List taskSumList = taskSumListResp.getResult();
        Assert.assertEquals((long)1L, (long)taskSumList.size());
        return (TaskSummary)taskSumList.get(0);
    }

    private String getConnectionContent(Object content) throws Exception {
        InputStreamReader in = new InputStreamReader((InputStream)content);
        BufferedReader buff = new BufferedReader(in);
        StringBuffer text = new StringBuffer();
        String line = buff.readLine();
        while (line != null) {
            text.append(line);
            line = buff.readLine();
        }
        return text.toString();
    }
}

