/*
 * Decompiled with CFR 0.152.
 */
package org.kie.soup.commons.util;

import org.junit.Assert;
import org.junit.Test;
import org.kie.soup.commons.util.ListSplitter;

public class ListSplitterTest {
    @Test
    public void basicABC() throws Exception {
        String[] split = ListSplitter.split((String)"a,b,c");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"a", (Object)split[0]);
        Assert.assertEquals((Object)"b", (Object)split[1]);
        Assert.assertEquals((Object)"c", (Object)split[2]);
    }

    @Test
    public void keepSpacesABC() throws Exception {
        String[] split = ListSplitter.split((String)"a, b ,c");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"a", (Object)split[0]);
        Assert.assertEquals((Object)" b ", (Object)split[1]);
        Assert.assertEquals((Object)"c", (Object)split[2]);
    }

    @Test
    public void specialABC() throws Exception {
        String[] split = ListSplitter.split((String)"'a','b','c'");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"a", (Object)split[0]);
        Assert.assertEquals((Object)"b", (Object)split[1]);
        Assert.assertEquals((Object)"c", (Object)split[2]);
    }

    @Test
    public void specialABCSpaces() throws Exception {
        String[] split = ListSplitter.split((String)" 'a' , 'b' , 'c' ");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"a", (Object)split[0]);
        Assert.assertEquals((Object)"b", (Object)split[1]);
        Assert.assertEquals((Object)"c", (Object)split[2]);
    }

    @Test
    public void basicCharacters() throws Exception {
        String[] split = ListSplitter.split((String)"',!,%,)");
        Assert.assertEquals((long)4L, (long)split.length);
        Assert.assertEquals((Object)"'", (Object)split[0]);
        Assert.assertEquals((Object)"!", (Object)split[1]);
        Assert.assertEquals((Object)"%", (Object)split[2]);
        Assert.assertEquals((Object)")", (Object)split[3]);
    }

    @Test
    public void splitItemsWithCommas() throws Exception {
        String[] split = ListSplitter.split((String)"'One sentence.','Another one, but with comma.','Third one. I'll make things, if possible, even more complicated.'");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"One sentence.", (Object)split[0]);
        Assert.assertEquals((Object)"Another one, but with comma.", (Object)split[1]);
        Assert.assertEquals((Object)"Third one. I'll make things, if possible, even more complicated.", (Object)split[2]);
    }

    @Test
    public void changeQuoteCharacter() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)"\"Helsinki, Finland\", Boston");
        Assert.assertEquals((long)2L, (long)split.length);
        Assert.assertEquals((Object)"Helsinki, Finland", (Object)split[0]);
        Assert.assertEquals((Object)"Boston", (Object)split[1]);
    }

    @Test
    public void changeQuoteCharacterPreserveQuotes() throws Exception {
        String[] split = ListSplitter.splitPreserveQuotes((String)"\"", (boolean)true, (String)"\"Helsinki, Finland\", Boston");
        Assert.assertEquals((long)2L, (long)split.length);
        Assert.assertEquals((Object)"\"Helsinki, Finland\"", (Object)split[0]);
        Assert.assertEquals((Object)"Boston", (Object)split[1]);
    }

    @Test
    public void changeQuoteCharacterSkipTrimming() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)false, (String)"\"Helsinki, Finland\", Boston");
        Assert.assertEquals((long)2L, (long)split.length);
        Assert.assertEquals((Object)"Helsinki, Finland", (Object)split[0]);
        Assert.assertEquals((Object)" Boston", (Object)split[1]);
    }

    @Test
    public void testQuoteCharacterUsedJustForComplexEnumEnd() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)"Prague, Boston, \"Helsinki, Finland\"");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"Prague", (Object)split[0]);
        Assert.assertEquals((Object)"Boston", (Object)split[1]);
        Assert.assertEquals((Object)"Helsinki, Finland", (Object)split[2]);
    }

    @Test
    public void testQuoteCharacterUsedJustForComplexEnumMiddle() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)"Prague, \"Helsinki, Finland\", Boston");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"Prague", (Object)split[0]);
        Assert.assertEquals((Object)"Helsinki, Finland", (Object)split[1]);
        Assert.assertEquals((Object)"Boston", (Object)split[2]);
    }

    @Test
    public void testDoubleQuotes() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)" \"Prague\", \"\"Helsinki, Finland\"\" ");
        Assert.assertEquals((long)2L, (long)split.length);
        Assert.assertEquals((Object)"Prague", (Object)split[0]);
        Assert.assertEquals((Object)"\"Helsinki, Finland\"", (Object)split[1]);
    }

    @Test
    public void testJustOneItem() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)" \"Prague\" ");
        Assert.assertEquals((long)1L, (long)split.length);
        Assert.assertEquals((Object)"Prague", (Object)split[0]);
    }

    @Test
    public void testJustOneComplexItem() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)" \"Prague, Czechia\" ");
        Assert.assertEquals((long)1L, (long)split.length);
        Assert.assertEquals((Object)"Prague, Czechia", (Object)split[0]);
    }

    @Test
    public void testQuoteCharacterUsedJustForComplexEnumStart() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)"\"Helsinki, Finland\", Prague, Boston");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"Helsinki, Finland", (Object)split[0]);
        Assert.assertEquals((Object)"Prague", (Object)split[1]);
        Assert.assertEquals((Object)"Boston", (Object)split[2]);
    }
}

