/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.json;

import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.json.DataSetJSONMarshaller;
import org.dashbuilder.json.JsonObject;
import org.junit.Assert;
import org.junit.Test;

public class DataSetJsonTest {
    DataSetJSONMarshaller datasetJsonMarshaller = DataSetJSONMarshaller.get();
    public static final String CONFLICTING_ID_DS_JSON = "{\n  \"column.0\": {\n    \"id\": \"ID\",\n    \"type\": \"NUMBER\",\n    \"values\": [\n      \"0.0\"\n    ]\n  },\n  \"column.1\": {\n    \"id\": \"ID\",\n    \"type\": \"NUMBER\",\n    \"values\": [\n      \"265.0\"\n    ]\n  }\n}";

    @Test
    public void testDataSetMarshalling() {
        DataSet original = DataSetFactory.newDataSetBuilder().label("month").number("2012").number("2013").number("2014").row(new Object[]{Month.JANUARY, 1000.0, 2000.0, 3000.0}).row(new Object[]{Month.FEBRUARY, 1400.0, 2300.0, 2000.0}).row(new Object[]{Month.MARCH, 1300.0, 2000.0, 1400.0}).row(new Object[]{Month.APRIL, 900.0, 2100.0, 1500.0}).row(new Object[]{Month.MAY, 1300.0, 2300.0, 1600.0}).row(new Object[]{Month.JUNE, 1010.0, 2000.0, 1500.0}).row(new Object[]{Month.JULY, 1050.0, 2400.0, 3000.0}).row(new Object[]{Month.AUGUST, 2300.0, 2000.0, 3200.0}).row(new Object[]{Month.SEPTEMBER, 1900.0, 2700.0, 3000.0}).row(new Object[]{Month.OCTOBER, 1200.0, 2200.0, 3100.0}).row(new Object[]{Month.NOVEMBER, 1400.0, 2100.0, 3100.0}).row(new Object[]{Month.DECEMBER, 1100.0, 2100.0, 4200.0}).buildDataSet();
        JsonObject _jsonObj = this.datasetJsonMarshaller.toJson(original);
        Assert.assertNotNull((Object)_jsonObj.toString());
        DataSet unmarshalled = this.datasetJsonMarshaller.fromJson(_jsonObj);
        Assert.assertEquals((Object)unmarshalled, (Object)original);
    }

    @Test
    public void testDoubleNumberColumnJsonUnmarshall() {
        DataSet dataset = this.datasetJsonMarshaller.fromJson(CONFLICTING_ID_DS_JSON);
        Assert.assertEquals((long)2L, (long)dataset.getColumns().size());
        DataColumn cl0 = (DataColumn)dataset.getColumns().get(0);
        Assert.assertEquals((Object)0.0, cl0.getValues().get(0));
        Assert.assertEquals((Object)"ID", (Object)cl0.getId());
        DataColumn cl1 = (DataColumn)dataset.getColumns().get(1);
        Assert.assertEquals((Object)265.0, cl1.getValues().get(0));
        Assert.assertEquals((Object)"ID", (Object)cl1.getId());
    }
}

