/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.json;

import java.util.Arrays;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.BeanDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.impl.DataSetMetadataImpl;
import org.dashbuilder.dataset.json.DataSetDefJsonTest;
import org.dashbuilder.dataset.json.DataSetMetadataJSONMarshaller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataSetMetadataJSONMarshallerTest {
    String METADATA_JSON = "{\n  \"uuid\": \"abc\",\n  \"numberOfRows\": 2,\n  \"numberOfColumns\": 1,\n  \"columnIds\": [\n    \"TEST\"\n  ],\n  \"columnTypes\": [\n    \"TEXT\"\n  ],\n  \"estimatedSize\": 10,\n  \"definition\": {\n    \"provider\": \"BEAN\",\n    \"isPublic\": true,\n    \"cacheEnabled\": false,\n    \"cacheMaxRows\": 1000,\n    \"pushEnabled\": false,\n    \"pushMaxSize\": 1024,\n    \"refreshAlways\": false\n  }\n}";
    String METADATA_JSON_WITH_NULL_VALUES = "{\n  \"definition\": {\n    \"provider\": \"BEAN\",\n    \"isPublic\": true,\n    \"cacheEnabled\": false,\n    \"cacheMaxRows\": 1000,\n    \"pushEnabled\": false,\n    \"pushMaxSize\": 1024,\n    \"refreshAlways\": false\n  }\n}";
    private DataSetMetadataJSONMarshaller marshaller;

    @Before
    public void setup() {
        this.marshaller = new DataSetMetadataJSONMarshaller(DataSetDefJsonTest.jsonMarshaller);
    }

    @Test
    public void toJsonTest() {
        DataSetMetadataImpl meta = new DataSetMetadataImpl((DataSetDef)new BeanDataSetDef(), "abc", 2, 1, Arrays.asList("TEST"), Arrays.asList(ColumnType.TEXT), 10);
        Assert.assertEquals((Object)this.METADATA_JSON, (Object)this.marshaller.toJson((DataSetMetadata)meta));
    }

    @Test
    public void fromJsonTest() throws Exception {
        DataSetMetadata meta = this.marshaller.fromJSON(this.METADATA_JSON);
        Assert.assertEquals((Object)"abc", (Object)meta.getUUID());
        Assert.assertEquals((long)2L, (long)meta.getNumberOfRows());
        Assert.assertEquals((long)1L, (long)meta.getNumberOfColumns());
        Assert.assertEquals(Arrays.asList("TEST"), (Object)meta.getColumnIds());
        Assert.assertEquals(Arrays.asList(ColumnType.TEXT), (Object)meta.getColumnTypes());
        Assert.assertEquals((long)10L, (long)meta.getEstimatedSize());
        Assert.assertNotNull((Object)meta.getDefinition());
    }

    @Test
    public void toJsonWithNullValuesTest() {
        DataSetMetadata meta = this.marshaller.fromJSON(this.METADATA_JSON_WITH_NULL_VALUES);
        Assert.assertEquals(null, (Object)meta.getUUID());
        Assert.assertEquals((long)0L, (long)meta.getNumberOfRows());
        Assert.assertEquals((long)0L, (long)meta.getNumberOfColumns());
        Assert.assertTrue((boolean)meta.getColumnIds().isEmpty());
        Assert.assertTrue((boolean)meta.getColumnTypes().isEmpty());
        Assert.assertEquals((long)0L, (long)meta.getEstimatedSize());
        Assert.assertNotNull((Object)meta.getDefinition());
    }
}

