/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.csv;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.dashbuilder.dataprovider.csv.CSVFileStorage;
import org.dashbuilder.dataprovider.csv.CSVParser;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataSetDefFactory;
import org.junit.Assert;
import org.junit.Test;

public class CSVParserTest {
    private final CSVDataSetDef csvDataSet = (CSVDataSetDef)DataSetDefFactory.newCSVDataSetDef().separatorChar(',').quoteChar('\'').escapeChar('\\').datePattern("YYYY-MM-dd").numberPattern("##.##").buildDef();

    @Test
    public void exceptionThrown_whenFirstLineHasLessFieldsThanHeader() throws Exception {
        String CSV_DATA = "'Name','Age'\n'Jan''15'";
        MockCSVFileStorage mockStorage = new MockCSVFileStorage("'Name','Age'\n'Jan''15'");
        CSVParser testedParser = new CSVParser(this.csvDataSet, (CSVFileStorage)mockStorage);
        try {
            DataSet dataSetShouldNotLoad = testedParser.load();
            Assert.fail((String)"IllegalArgumentException should be thrown when 1st row of CSV data has less fields than the header");
        }
        catch (IllegalArgumentException iae) {
            String expectedExceptionMessage = "CSV parse error : The first row has fewer columns (1) than the header (2)";
            Assert.assertEquals((Object)expectedExceptionMessage, (Object)iae.getMessage());
        }
    }

    @Test
    public void dataSetCreated_whenCsvDataValid() throws Exception {
        String CSV_DATA = "'Name','Weight','Date of birth'\n'Jan','75.64','1950-01-20'";
        MockCSVFileStorage mockStorage = new MockCSVFileStorage("'Name','Weight','Date of birth'\n'Jan','75.64','1950-01-20'");
        CSVParser testedParser = new CSVParser(this.csvDataSet, (CSVFileStorage)mockStorage);
        DataSet dset = testedParser.load();
        Assert.assertEquals((long)1L, (long)dset.getRowCount());
        Assert.assertEquals((Object)ColumnType.LABEL, (Object)dset.getColumnById("Name").getColumnType());
        Assert.assertEquals((Object)ColumnType.NUMBER, (Object)dset.getColumnById("Weight").getColumnType());
        Assert.assertEquals((Object)ColumnType.DATE, (Object)dset.getColumnById("Date of birth").getColumnType());
    }

    @Test
    public void stringFieldStartingWithNumber_shouldBeParsedAsLabel() throws Exception {
        String CSV_DATA = "Age,Address\n25,12 Downing street\n75,White House 52";
        MockCSVFileStorage mockStorage = new MockCSVFileStorage("Age,Address\n25,12 Downing street\n75,White House 52");
        CSVParser testedParser = new CSVParser(this.csvDataSet, (CSVFileStorage)mockStorage);
        DataSet dset = testedParser.load();
        Assert.assertEquals((long)2L, (long)dset.getRowCount());
        Assert.assertEquals((Object)ColumnType.NUMBER, (Object)dset.getColumnById("Age").getColumnType());
        Assert.assertEquals((Object)ColumnType.LABEL, (Object)dset.getColumnById("Address").getColumnType());
    }

    static class MockCSVFileStorage
    implements CSVFileStorage {
        private final String csvData;

        MockCSVFileStorage(String csvData) {
            this.csvData = csvData;
        }

        public InputStream getCSVInputStream(CSVDataSetDef ignored) {
            return new ByteArrayInputStream(this.csvData.getBytes(StandardCharsets.UTF_8));
        }

        public String getCSVString(CSVDataSetDef def) {
            return null;
        }

        public void saveCSVFile(CSVDataSetDef def) {
        }

        public void deleteCSVFile(CSVDataSetDef def) {
        }
    }
}

