/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.kafka.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.dashbuilder.dataprovider.kafka.metrics.KafkaMetricCollector;
import org.dashbuilder.dataprovider.kafka.model.KafkaMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanMetricCollector
implements KafkaMetricCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MBeanMetricCollector.class);
    private static final String[] NAME_KEYS = new String[]{"name", "request", "delayedOperation"};
    private String name;
    private String[] attributes;

    public static MBeanMetricCollector metricCollector(String name) {
        return MBeanMetricCollector.metricCollector(name, new String[0]);
    }

    public static MBeanMetricCollector metricCollector(String name, String[] attributes) {
        MBeanMetricCollector collector = new MBeanMetricCollector();
        collector.name = name;
        collector.attributes = attributes;
        return collector;
    }

    private MBeanMetricCollector() {
    }

    @Override
    public List<KafkaMetric> collect(MBeanServerConnection mbsc) {
        ObjectName objectName;
        try {
            objectName = new ObjectName(this.name);
        }
        catch (MalformedObjectNameException e) {
            LOGGER.warn("Not able to access MBean {}", (Object)this.name);
            LOGGER.debug("Not able to access MBean", (Throwable)e);
            return Collections.emptyList();
        }
        if (this.attributes == null || this.attributes.length == 0) {
            this.attributes = this.readAllAttributes(mbsc, objectName);
        }
        return Arrays.stream(this.attributes).map(attr -> this.buildMetric(mbsc, objectName, (String)attr)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<KafkaMetric> buildMetric(MBeanServerConnection mbsc, ObjectName objectName, String attrName) {
        Object attrValue = this.readAttribute(mbsc, objectName, attrName);
        return Optional.ofNullable(attrValue).map(attr -> KafkaMetric.from(objectName.getDomain(), objectName.getKeyProperty("type"), this.buildName(objectName), attrName, attr));
    }

    @Override
    public String getName() {
        return this.name;
    }

    private String[] readAllAttributes(MBeanServerConnection mbsc, ObjectName objectName) {
        try {
            return (String[])Arrays.stream(mbsc.getMBeanInfo(objectName).getAttributes()).filter(MBeanAttributeInfo::isReadable).map(MBeanFeatureInfo::getName).toArray(String[]::new);
        }
        catch (Exception e) {
            LOGGER.info("Not able to read attributes for MBean {}", (Object)this.name);
            LOGGER.debug("Not able read MBean attributes", (Throwable)e);
            return new String[0];
        }
    }

    private String buildName(ObjectName objectName) {
        String metricName = Arrays.stream(NAME_KEYS).map(objectName::getKeyProperty).filter(Objects::nonNull).collect(Collectors.joining());
        return metricName.trim().isEmpty() ? objectName.getKeyProperty("type") : metricName;
    }

    private Object readAttribute(MBeanServerConnection mbsc, ObjectName name, String attr) {
        try {
            return mbsc.getAttribute(name, attr);
        }
        catch (Exception e) {
            LOGGER.info("Not able to read MBean {} attribute {}", (Object)this.name, (Object)attr);
            LOGGER.debug("Not able to read MBean attribute", (Throwable)e);
            return null;
        }
    }

    public String[] getAttributes() {
        return this.attributes;
    }
}

