/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.kafka.metrics.group;

import java.util.List;
import org.dashbuilder.dataprovider.kafka.mbean.MBeanDefinitions;
import org.dashbuilder.dataprovider.kafka.mbean.MBeanNameFactory;
import org.dashbuilder.dataprovider.kafka.mbean.ObjectNamePrototype;
import org.dashbuilder.dataprovider.kafka.metrics.KafkaMetricCollector;
import org.dashbuilder.dataprovider.kafka.metrics.MBeanMetricCollector;
import org.dashbuilder.dataprovider.kafka.metrics.group.MetricsCollectorGroup;
import org.dashbuilder.dataprovider.kafka.model.KafkaMetricsRequest;

class BrokerMetricsGroup
implements MetricsCollectorGroup {
    private static final ObjectNamePrototype KAFKA_CONTROLLER_TYPE = ObjectNamePrototype.withDomainAndType("kafka.controller", "KafkaController");
    private static final ObjectNamePrototype CONTROLLER_STATS_TYPE = ObjectNamePrototype.withDomainAndType("kafka.controller", "ControllerStats");
    private static final ObjectNamePrototype KAFKA_REQUEST_HANDLER_POOL_TYPE = ObjectNamePrototype.withDomainAndType("kafka.server", "KafkaRequestHandlerPool");
    private static final ObjectNamePrototype REQUEST_CHANNEL_TYPE = ObjectNamePrototype.withDomainAndType("kafka.network", "RequestChannel");
    private static final ObjectNamePrototype SOCKET_SERVER_TYPE = ObjectNamePrototype.withDomainAndType("kafka.network", "SocketServer");
    private static final ObjectNamePrototype REPLICA_MANAGER = ObjectNamePrototype.withDomainAndType("kafka.server", "ReplicaManager");
    private static final ObjectNamePrototype REPLICA_FETCHER_MANAGER = ObjectNamePrototype.withDomainAndType("kafka.server", "ReplicaFetcherManager");
    private static final ObjectNamePrototype BROKER_TOPIC_METRICS = ObjectNamePrototype.withDomainAndType("kafka.server", "BrokerTopicMetrics");
    private static final ObjectNamePrototype REQUEST_METRICS_TOTAL_TIME_MS = ObjectNamePrototype.withDomainTypeAndName("kafka.network", "RequestMetrics", "TotalTimeMs");
    private static final ObjectNamePrototype REQUEST_METRICS_LOCAL_TIME_MS = ObjectNamePrototype.withDomainTypeAndName("kafka.network", "RequestMetrics", "LocalTimeMs");
    private static final ObjectNamePrototype REQUEST_METRICS_REMOTE_TIME_MS = ObjectNamePrototype.withDomainTypeAndName("kafka.network", "RequestMetrics", "RemoteTimeMs");
    private static final ObjectNamePrototype REQUEST_METRICS_RESPONSE_QUEUE_TIME_MS = ObjectNamePrototype.withDomainTypeAndName("kafka.network", "RequestMetrics", "ResponseQueueTimeMs");
    private static final ObjectNamePrototype REQUEST_METRICS_RESPONSE_SEND_TIME_MS = ObjectNamePrototype.withDomainTypeAndName("kafka.network", "RequestMetrics", "ResponseSendTimeMs");
    private static final ObjectNamePrototype REQUEST_METRICS_REQUEST_QUEUE_TIME_MS = ObjectNamePrototype.withDomainTypeAndName("kafka.network", "RequestMetrics", "RequestQueueTimeMs");
    private static final ObjectNamePrototype DELAYED_OPERATION_PURGATORY_PURGATORY_SIZE = ObjectNamePrototype.withDomainTypeAndName("kafka.server", "DelayedOperationPurgatory", "PurgatorySize");
    private static final List<KafkaMetricCollector> COLLECTORS;

    BrokerMetricsGroup() {
    }

    @Override
    public List<KafkaMetricCollector> getMetricsCollectors(KafkaMetricsRequest request) {
        return COLLECTORS;
    }

    static {
        KafkaMetricCollector[] collectors = new KafkaMetricCollector[]{MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(KAFKA_CONTROLLER_TYPE, "GlobalPartitionCount")), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(KAFKA_CONTROLLER_TYPE, "ActiveControllerCount")), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(KAFKA_CONTROLLER_TYPE, "OfflinePartitionsCount")), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(CONTROLLER_STATS_TYPE, "LeaderElectionRateAndTimeMs"), MetricsCollectorGroup.mergeAttrs(MBeanDefinitions.TIME_MS_ATTRS, MBeanDefinitions.PER_TIME_ATTRS)), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(CONTROLLER_STATS_TYPE, "UncleanLeaderElectionsPerSec"), MBeanDefinitions.PER_TIME_ATTRS), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(REPLICA_MANAGER, "UnderReplicatedPartitions")), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(REPLICA_MANAGER, "UnderMinIsrPartitionCount")), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(REPLICA_MANAGER, "ReassigningPartitions")), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(REPLICA_MANAGER, "IsrShrinksPerSec"), MBeanDefinitions.PER_TIME_ATTRS), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(REPLICA_MANAGER, "IsrExpandsPerSec"), MBeanDefinitions.PER_TIME_ATTRS), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(REPLICA_MANAGER, "PartitionCount")), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(REPLICA_MANAGER, "LeaderCount")), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(SOCKET_SERVER_TYPE, "NetworkProcessorAvgIdlePercent")), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(BROKER_TOPIC_METRICS, "BytesInPerSec"), MBeanDefinitions.PER_TIME_ATTRS), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(BROKER_TOPIC_METRICS, "BytesOutPerSec"), MBeanDefinitions.PER_TIME_ATTRS), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(BROKER_TOPIC_METRICS, "TotalProduceRequestsPerSec"), MBeanDefinitions.PER_TIME_ATTRS), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(BROKER_TOPIC_METRICS, "TotalFetchRequestsPerSec"), MBeanDefinitions.PER_TIME_ATTRS), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(BROKER_TOPIC_METRICS, "FailedProduceRequestsPerSec"), MBeanDefinitions.PER_TIME_ATTRS), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(BROKER_TOPIC_METRICS, "ReassignmentBytesInPerSec"), MBeanDefinitions.PER_TIME_ATTRS), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(BROKER_TOPIC_METRICS, "ReassignmentBytesOutPerSec"), MBeanDefinitions.PER_TIME_ATTRS), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(BROKER_TOPIC_METRICS, "MessagesInPerSec"), MBeanDefinitions.PER_TIME_ATTRS), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(BROKER_TOPIC_METRICS, "FailedFetchRequestsPerSec"), MBeanDefinitions.PER_TIME_ATTRS), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(REQUEST_CHANNEL_TYPE, "RequestQueueSize")), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(REQUEST_CHANNEL_TYPE, "ResponseQueueSize")), MBeanMetricCollector.metricCollector(MBeanNameFactory.withName(KAFKA_REQUEST_HANDLER_POOL_TYPE, "RequestHandlerAvgIdlePercent"), MBeanDefinitions.PER_TIME_ATTRS), MBeanMetricCollector.metricCollector(REPLICA_FETCHER_MANAGER.copy().name("MaxLag").clientId("Replica").build())};
        COLLECTORS = MetricsCollectorGroup.merge(collectors, MBeanNameFactory.withProduceDelayedAndFetchDelayedOperation(DELAYED_OPERATION_PURGATORY_PURGATORY_SIZE), MBeanNameFactory.withProduceFetchConsumerAndFetchFollowerRequest(REQUEST_METRICS_TOTAL_TIME_MS), MBeanNameFactory.withProduceFetchConsumerAndFetchFollowerRequest(REQUEST_METRICS_REQUEST_QUEUE_TIME_MS), MBeanNameFactory.withProduceFetchConsumerAndFetchFollowerRequest(REQUEST_METRICS_LOCAL_TIME_MS), MBeanNameFactory.withProduceFetchConsumerAndFetchFollowerRequest(REQUEST_METRICS_REMOTE_TIME_MS), MBeanNameFactory.withProduceFetchConsumerAndFetchFollowerRequest(REQUEST_METRICS_RESPONSE_QUEUE_TIME_MS), MBeanNameFactory.withProduceFetchConsumerAndFetchFollowerRequest(REQUEST_METRICS_RESPONSE_SEND_TIME_MS));
    }
}

